#include "Mesh.H"

// Mesh
///////////////////////////////////////////////////////////////////////////////
LPMESH CreateMesh()
{
	LPMESH mesh = new MESH;
	if ( !mesh )
		return NULL;

	ZeroMemory( mesh, sizeof(MESH) );
	mesh->Matrix = IdentityMatrix();
	mesh->lpMaterial = CreateMaterial( "DEFAULT MATERIAL" );

	return mesh;
}

void DestroyMesh( LPDIRECT3DVIEWPORT2 lpViewport, LPMESH lpMesh )
{
	// Destory Material
	if ( lpMesh->lpMaterial )
		DestroyMaterial( lpMesh->lpMaterial );

	// Destory Texture
	if ( lpMesh->lpTexture )
		DestroyTexture( lpMesh->lpTexture );


	// Destory Light
	if ( lpMesh->lpLight )
	{
		DeleteLight( lpViewport, lpMesh->lpLight );
		DestroyLight( lpMesh->lpLight );
	}


	// Destory Camera
	if ( lpMesh->lpCamera )
		DestroyCamera( lpMesh->lpCamera );


	// Destory Object
	if ( lpMesh->lpObject )
		DestroyObject( lpMesh->lpObject );

	delete [] lpMesh;
}


// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
HRESULT SetupMesh( LPDIRECTDRAW2 lpDD, LPDIRECT3D2 lpD3D, LPDIRECT3DDEVICE2 lpDev, LPDIRECT3DVIEWPORT2 lpViewport, LPMESH lpMesh )
{
	HRESULT hresult;
/*
    lpDev->SetLightState( D3DLIGHTSTATE_AMBIENT, 
		                  D3DRGBA( lpMesh->ambient.r,
						           lpMesh->ambient.g,
								   lpMesh->ambient.b,
								   lpMesh->ambient.a ) );
*/
	LPMATERIAL material = CreateMaterial( lpMesh->lpMaterial, "BACKGROUND" );
	material->Material.dcvAmbient.r = lpMesh->ambient.r;
	material->Material.dcvAmbient.g = lpMesh->ambient.g;
	material->Material.dcvAmbient.b = lpMesh->ambient.b;
	strcpy( material->szTextureName, "CLOUD.PCX" );

	// Setup light;
	hresult = SetupLight( lpD3D, lpViewport, lpMesh->lpLight );
	if ( hresult != D3D_OK )
	{
		MESSAGE( "SetupLight" );
		return hresult;
	}

	// Setup material;
	hresult = SetupMaterial( lpDD, lpD3D, lpDev, lpMesh->lpMaterial, &lpMesh->lpTexture );
	if ( hresult != D3D_OK )
	{
		MESSAGE( "SetupMaterial" );
		return hresult;
	}

	hresult = SetAsBackground( lpD3D, lpDev, lpViewport, material );
	if ( hresult != D3D_OK )
	{
		MESSAGE( "SetAsBackground" );
		return hresult;
	}


    SetCamera( lpDev, lpMesh->lpCamera );

	return D3D_OK;
}

void RenderMesh( LPDIRECT3DDEVICE2 lpDev, LPMESH lpMesh )
{
    lpDev->SetTransform( D3DTRANSFORMSTATE_WORLD, &lpMesh->Matrix );

	LPOBJECT lpObject = lpMesh->lpObject;
	while ( lpObject )
	{
		RenderObject( lpDev, lpObject );

		lpObject = lpObject->lpNext;
	}
}


// Etc Func
///////////////////////////////////////////////////////////////////////////////
void DebugMesh( LPMESH lpMesh )
{
	FILE *fp = fopen( "DEBUG.DAT", "wt" );


	int i=0;
	LPLIGHT lpLight = lpMesh->lpLight;
	while ( lpLight )
	{
        fprintf( fp, "\nLight[%d] Name = %s\n",
                     i++,
                     lpLight->szName );

        fprintf( fp, "Type = %d\n",
                     lpLight->Light.dltType );
        fprintf( fp, "Color R=%10f G=%10f B=%10f\n",
                     lpLight->Light.dcvColor.r,
                     lpLight->Light.dcvColor.g,
                     lpLight->Light.dcvColor.b );
        fprintf( fp, "Position x=%10f y=%10f z=%10f\n",
                     lpLight->Light.dvPosition.x,
                     lpLight->Light.dvPosition.y,
                     lpLight->Light.dvPosition.z );
        fprintf( fp, "Direction x=%10f y=%10f z=%10f\n",
                     lpLight->Light.dvDirection.x,
                     lpLight->Light.dvDirection.y,
                     lpLight->Light.dvDirection.z );
        fprintf( fp, "Falloff = %d\n",
                     lpLight->Light.dvFalloff );
        fprintf( fp, "Phi = %d\n",
                     lpLight->Light.dvPhi );

        fprintf( fp, "lpD3DLight=%ld\n",
                     lpLight->lpD3DLight );

		lpLight = lpLight->lpNext;
	}

	i=0;
	LPCAMERA lpCamera = lpMesh->lpCamera;
	while ( lpCamera )
	{
        fprintf( fp, "\nCamera[%d] Name = %s\n", 
			         i++, 
					 lpCamera->szName );

        fprintf( fp, "Position x=%10f y=%10f z=%10f\n",
                     lpCamera->dvPosition.x,
                     lpCamera->dvPosition.y,
                     lpCamera->dvPosition.z );
        fprintf( fp, "Direction x=%10f y=%10f z=%10f\n",
                     lpCamera->dvDirection.x,
                     lpCamera->dvDirection.y,
                     lpCamera->dvDirection.z );
        fprintf( fp, "Bank = %10f\n",
                     lpCamera->bank );
        fprintf( fp, "Lens = %10f\n",
                     lpCamera->lens );
        fprintf( fp, "NearPlane = %10f\n",
                     lpCamera->nearPlane );
        fprintf( fp, "FarPlane = %10f\n",
                     lpCamera->farPlane );

		lpCamera = lpCamera->lpNext;
	}


	i=0;
    char *shading[]={
        "NONE", "FLAT", "GOURAUD", "PHONG", "METAL"
    };

	LPMATERIAL lpMaterial = lpMesh->lpMaterial;
	while ( lpMaterial )
	{
        fprintf( fp, "\nMaterial[%d] Name = %s\n",
                     i++,
                     lpMaterial->szName );

        fprintf( fp, "Type=%s\n",
                     shading[lpMaterial->shadeType] );
        fprintf( fp, "Ambient R=%10f G=%10f B=%10f\n",
                     lpMaterial->Material.ambient.r,
                     lpMaterial->Material.ambient.g,
                     lpMaterial->Material.ambient.b );
        fprintf( fp, "Diffuse R=%10f G=%10f B=%10f\n",
                     lpMaterial->Material.diffuse.r,
                     lpMaterial->Material.diffuse.g,
                     lpMaterial->Material.diffuse.b );
        fprintf( fp, "Specular R=%10f G=%10f B=%10f\n",
                     lpMaterial->Material.specular.r,
                     lpMaterial->Material.specular.g,
                     lpMaterial->Material.specular.b );
        fprintf( fp, "Emissive R=%10f G=%10f B=%10f\n",
                     lpMaterial->Material.emissive.r,
                     lpMaterial->Material.emissive.g,
                     lpMaterial->Material.emissive.b );
        fprintf( fp, "Power=%10f\n",
                     lpMaterial->Material.power );
        fprintf( fp, "Texture Name=%s\n",
                     lpMaterial->szTextureName );

        fprintf( fp, "lpD3DMaterial=%ld\n",
                     lpMaterial->lpD3DMaterial );

		lpMaterial = lpMaterial->lpNext;
	}


	i=0;
	LPTEXTURE lpTexture = lpMesh->lpTexture;
	while ( lpTexture )
	{
        fprintf( fp, "\nTexture[%d] Name = %s\n", 
			         i++, 
					 lpTexture->szName );

		fprintf( fp, "Handle = %d\n",
					 lpTexture->Handle );

		fprintf( fp, "lpDDSurface = %ld\n",
					 lpTexture->lpDDSurface );

		lpTexture = lpTexture->lpNext;
	}

	fclose( fp );
}




