#ifndef __Mesh_H__
#define __Mesh_H__

#include "Object.H"

#pragma pack(1)
typedef struct {
	COLORVALUE		ambient;

	LPTEXTURE		lpTexture;
	LPMATERIAL  	lpMaterial;

	LPLIGHT     	lpLight;
	LPCAMERA    	lpCamera;
	LPOBJECT    	lpObject;

	D3DMATRIX		Matrix;
	char			szName[100];
} MESH, *LPMESH;
#pragma pack()


// Mesh
///////////////////////////////////////////////////////////////////////////////
LPMESH CreateMesh();
void DestroyMesh( LPDIRECT3DVIEWPORT2 lpViewport, LPMESH lpMesh );

// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
HRESULT SetupMesh( LPDIRECTDRAW2 lpDD, LPDIRECT3D2 lpD3D, LPDIRECT3DDEVICE2 lpDev, LPDIRECT3DVIEWPORT2 lpViewport, LPMESH lpMesh );

void RenderMesh( LPDIRECT3DDEVICE2 lpDev, LPMESH lpMesh );

// Etc Func
///////////////////////////////////////////////////////////////////////////////
LPMESH LoadOBJ( char *FileName );
LPMESH Load3DS( char *FileName );

void DebugMesh( LPMESH lpMesh );

#endif