#include "Mesh.H"


#define chunkMATERIAL           0x10
#define chunkOBJECT             0x20
    #define chunkFACEMAT        0x21
#define chunkLIGHT              0x30
#define chunkCAMERA             0x40
#define chunkAMBIENT            0x50
#define chunkEND                0xff

static BOOL ReadHeader( FILE *fp )
{
    HEADER Header;
    fread( &Header, sizeof(HEADER), 1, fp );

    // Read Magic
    DWORD magic = ((DWORD)(('M'<<24)+('R'<<16)+('O'<<8)+('F')));
    if ( Header.magic != magic )
		return FALSE;

	// Read Version
    if ( Header.version != 1 )
        return FALSE;

    return TRUE;
}

static void ReadName( FILE *fp, char *lpszName )
{
    BYTE len = fgetc( fp );
    fread( lpszName, len, 1, fp );
    lpszName[len] = 0;
}

static BYTE ReadChunk( FILE *fp )
{
    BYTE chunk;

    fread( &chunk, sizeof(BYTE), 1, fp );
    return chunk;
}


static BOOL ReadMaterial( FILE *fp, LPMATERIAL *lpMaterial )
{
    LPMATERIAL material;

    if ( !*lpMaterial )
        material = *lpMaterial = CreateMaterial( "DEFAULT" );
    else
        material = CreateMaterial( *lpMaterial, "DEFAULT" );
    if ( !material )
        return FALSE;


    ReadName( fp, material->szName );

    fread( &material->shadeType, sizeof(WORD), 1, fp );

    fread( &material->Material.dcvDiffuse.r, sizeof(float), 1, fp );
    fread( &material->Material.dcvDiffuse.g, sizeof(float), 1, fp );
    fread( &material->Material.dcvDiffuse.b, sizeof(float), 1, fp );
    fread( &material->Material.dcvDiffuse.a, sizeof(float), 1, fp );

    fread( &material->Material.dcvAmbient.r, sizeof(float), 1, fp );
    fread( &material->Material.dcvAmbient.g, sizeof(float), 1, fp );
    fread( &material->Material.dcvAmbient.b, sizeof(float), 1, fp );
    fread( &material->Material.dcvAmbient.a, sizeof(float), 1, fp );

    fread( &material->Material.dcvSpecular.r, sizeof(float), 1, fp );
    fread( &material->Material.dcvSpecular.g, sizeof(float), 1, fp );
    fread( &material->Material.dcvSpecular.b, sizeof(float), 1, fp );
    fread( &material->Material.dcvSpecular.a, sizeof(float), 1, fp );

    fread( &material->Material.dvPower, sizeof(float), 1, fp );
    
	ReadName( fp, material->szTextureName );
    
    return TRUE;
}

static BOOL ReadTriMeshMatGroup( FILE *fp, LPTRIMESHMATGROUP *lpTriMeshMatGroup )
{
    LPTRIMESHMATGROUP group;

    if ( !*lpTriMeshMatGroup )
        group = *lpTriMeshMatGroup = CreateTriMeshMatGroup( "DEFAULT" );
    else
        group = CreateTriMeshMatGroup( *lpTriMeshMatGroup, "DEFAULT" );
    if ( !group )
        return FALSE;


    ReadName( fp, group->szName );

    fread( &group->NumTriangles, sizeof(WORD), 1, fp );
    group->lpTriangles = new WORD [group->NumTriangles];
    for ( int i=0; i<group->NumTriangles; i++ )
        fread( &group->lpTriangles[i], sizeof(WORD), 1, fp );

    return TRUE;
}

static BOOL ReadObject( FILE *fp, LPOBJECT *lpObject )
{
    LPOBJECT object;

    if ( !*lpObject )
        object = *lpObject = CreateObject( "DEFAULT" );
    else
        object = CreateObject( *lpObject, "DEFAULT" );
    if ( !object )
        return FALSE;


    ReadName( fp, object->szName );

    fread( &object->NumVertices, sizeof(WORD), 1, fp );
    object->lpVertices  = new VECTOR [object->NumVertices];
    object->lpTVertices = new TVERTEX [object->NumVertices];
    for ( int i=0; i<object->NumVertices; i++ )
    {
        fread( &object->lpVertices[i].x, sizeof(float), 1, fp );
        fread( &object->lpVertices[i].y, sizeof(float), 1, fp );
        fread( &object->lpVertices[i].z, sizeof(float), 1, fp );

        fread( &object->lpTVertices[i].tu, sizeof(float), 1, fp );
        fread( &object->lpTVertices[i].tv, sizeof(float), 1, fp );
    }

    fread( &object->NumTriangles, sizeof(WORD), 1, fp );
    object->lpTriangles = new TRIANGLE [object->NumTriangles];
    for ( i=0; i<object->NumTriangles; i++ )
    {
        fread( &object->lpTriangles[i].vindices[0], sizeof(WORD), 1, fp );
        fread( &object->lpTriangles[i].vindices[1], sizeof(WORD), 1, fp );
        fread( &object->lpTriangles[i].vindices[2], sizeof(WORD), 1, fp );

        fread( &object->lpTriangles[i].nindices[0], sizeof(WORD), 1, fp );
        fread( &object->lpTriangles[i].nindices[1], sizeof(WORD), 1, fp );
        fread( &object->lpTriangles[i].nindices[2], sizeof(WORD), 1, fp );
    }

    fread( &object->NumNormals, sizeof(WORD), 1, fp );
    for ( i=0; i<object->NumNormals; i++ )
    {
        fread( &object->lpNormals[i].x, sizeof(float), 1, fp );
        fread( &object->lpNormals[i].y, sizeof(float), 1, fp );
        fread( &object->lpNormals[i].z, sizeof(float), 1, fp );
    }

    BYTE chunk = ReadChunk( fp );
    while ( chunk != chunkEND )
    {
        switch ( chunk )
        {
            case chunkFACEMAT:
                ReadTriMeshMatGroup( fp, &object->lpTriMeshMatGroup );
                break;

            default:
                return FALSE;
        }

        chunk = ReadChunk( fp );
    }

    return TRUE;
}

static BOOL ReadLight( FILE *fp, LPLIGHT *lpLight )
{
    LPLIGHT light;

    if ( !*lpLight )
        light = *lpLight = CreateLight( "DEFAULT" );
    else
        light = CreateLight( *lpLight, "DEFAULT" );
    if ( !light )
        return FALSE;


    ReadName( fp, light->szName );

    fread( &light->Light.dltType, sizeof(D3DLIGHTTYPE), 1, fp );

    fread( &light->Light.dcvColor.r, sizeof(float), 1, fp );
    fread( &light->Light.dcvColor.g, sizeof(float), 1, fp );
    fread( &light->Light.dcvColor.b, sizeof(float), 1, fp );

    fread( &light->Light.dvPosition.x, sizeof(float), 1, fp );
    fread( &light->Light.dvPosition.y, sizeof(float), 1, fp );
    fread( &light->Light.dvPosition.z, sizeof(float), 1, fp );

    fread( &light->Light.dvDirection.x, sizeof(float), 1, fp );
    fread( &light->Light.dvDirection.y, sizeof(float), 1, fp );
    fread( &light->Light.dvDirection.z, sizeof(float), 1, fp );

    fread( &light->Light.dvRange, sizeof(float), 1, fp );
    fread( &light->Light.dvFalloff, sizeof(float), 1, fp );

    fread( &light->Light.dvTheta, sizeof(float), 1, fp );
    fread( &light->Light.dvPhi, sizeof(float), 1, fp );

    return TRUE;
}

static BOOL ReadCamera( FILE *fp, LPCAMERA *lpCamera )
{
    LPCAMERA camera;

    if ( !*lpCamera )
        camera = *lpCamera = CreateCamera( "DEFAULT" );
    else
        camera = CreateCamera( *lpCamera, "DEFAULT" );
    if ( !camera )
        return FALSE;


    ReadName( fp, camera->szName );

    fread( &camera->dvPosition.x, sizeof(float), 1, fp );
    fread( &camera->dvPosition.y, sizeof(float), 1, fp );
    fread( &camera->dvPosition.z, sizeof(float), 1, fp );

    fread( &camera->dvDirection.x, sizeof(float), 1, fp );
    fread( &camera->dvDirection.y, sizeof(float), 1, fp );
    fread( &camera->dvDirection.z, sizeof(float), 1, fp );

    fread( &camera->bank, sizeof(float), 1, fp );
    fread( &camera->lens, sizeof(float), 1, fp );

    fread( &camera->nearPlane, sizeof(float), 1, fp );
    fread( &camera->farPlane,  sizeof(float), 1, fp );

    return TRUE;
}

static BOOL ReadAmbient( FILE *fp, float *r, float *g, float *b, float *a )
{
    fread( r, sizeof(float), 1, fp );
    fread( g, sizeof(float), 1, fp );
    fread( b, sizeof(float), 1, fp );

	*a = 1.0f;
    return TRUE;
}


LPMESH LoadOBJ( char *lpszFileName )
{
    FILE *fp = fopen( lpszFileName, "rb" );
    if ( !fp )
        return NULL;

    if ( !ReadHeader( fp ) )
    {
		fclose( fp );
		return NULL;
    }

    LPMESH lpMesh = CreateMesh();
    if ( !lpMesh )
        return NULL;

    ReadName( fp, lpMesh->szName );


    BYTE chunk = ReadChunk( fp );
    while ( chunk != chunkEND )
    {
        switch ( chunk )
        {
            case chunkMATERIAL:
                ReadMaterial( fp, &lpMesh->lpMaterial );
                break;

            case chunkOBJECT:
                ReadObject( fp, &lpMesh->lpObject );
                break;

            case chunkLIGHT:
                ReadLight( fp, &lpMesh->lpLight );
                break;

            case chunkCAMERA:
                ReadCamera( fp, &lpMesh->lpCamera );
                break;

            case chunkAMBIENT:
                ReadAmbient( fp, &lpMesh->ambient.r, 
					             &lpMesh->ambient.g, 
								 &lpMesh->ambient.b,
								 &lpMesh->ambient.a );
                break;
        }

        chunk = ReadChunk( fp );
    }

	fclose( fp );


/*
    LPTRIMESHMATGROUP group = lpMesh->lpObject->lpTriMeshMatGroup;
	while ( group )
	{
		LPMATERIAL material = FindMaterial( lpMesh->lpMaterial, group->szName );
		for ( int i=0; i<group->NumTriangles; i++ )
			lpMesh->lpObject->lpTriangles[group->lpTriangles[i]].lpMaterial = material;

		group = group->lpNext;
	}
*/    
    return lpMesh;
}
