#include "Object.H"

#include "Matrix.H"


// Face Material Group List
///////////////////////////////////////////////////////////////////////////////
LPTRIMESHMATGROUP CreateTriMeshMatGroup( char* lpszName )
{
    LPTRIMESHMATGROUP group = new TRIMESHMATGROUP;
    if ( !group )
		return NULL;

    ZeroMemory( group, sizeof(TRIMESHMATGROUP) );
    strcpy( group->szName, lpszName );

    return group;
}

LPTRIMESHMATGROUP CreateTriMeshMatGroup( LPTRIMESHMATGROUP lpTriMeshMatGroup, char* lpszName )
{
    if ( !lpTriMeshMatGroup )
        return CreateTriMeshMatGroup( lpszName );

    LPTRIMESHMATGROUP group = new TRIMESHMATGROUP;
    if ( !group )
        return NULL;

	ZeroMemory( group, sizeof(TRIMESHMATGROUP) );
    strcpy( group->szName, lpszName );

    LPTRIMESHMATGROUP lastGroup = lpTriMeshMatGroup;
    while ( lastGroup->lpNext )
        lastGroup = lastGroup->lpNext;

    lastGroup->lpNext = group;

    return group;
}

void DestroyTriMeshMatGroup( LPTRIMESHMATGROUP lpTriMeshMatGroup )
{
    LPTRIMESHMATGROUP group;

    while ( lpTriMeshMatGroup->lpNext )
	{
        group = lpTriMeshMatGroup->lpNext;
        lpTriMeshMatGroup->lpNext = lpTriMeshMatGroup->lpNext->lpNext;

		if ( group->lpTriangles )
			delete [] group->lpTriangles;

        delete [] group;
	}

    delete [] lpTriMeshMatGroup;
}



// Object List
///////////////////////////////////////////////////////////////////////////////
LPOBJECT FindObject( LPOBJECT lpObject, char* lpszName )
{
	LPOBJECT object = lpObject;

	while ( object )
	{
		if ( !strcmp( lpszName, object->szName ) )
			break;

		object = object->lpNext;
	}

	return object;
}

LPOBJECT CreateObject( char* lpszName )
{
	LPOBJECT object = new OBJECT;
	if ( !object )
		return NULL;

	ZeroMemory( object, sizeof(OBJECT) );
	strcpy( object->szName, lpszName );

	object->Matrix = IdentityMatrix();

	return object;
}

LPOBJECT CreateObject( LPOBJECT lpObject, char* lpszName )
{
	if ( !lpObject )
		return CreateObject( lpszName );

	LPOBJECT object = FindObject( lpObject, lpszName );
	if ( !object )
	{
		object = new OBJECT;
		if ( !object )
			return NULL;

		ZeroMemory( object, sizeof(OBJECT) );
		strcpy( object->szName, lpszName );

		object->Matrix = IdentityMatrix();


		LPOBJECT lastObject = lpObject;
		while ( lastObject->lpNext )
			lastObject = lastObject->lpNext;

		lastObject->lpNext = object;
	}

	return object;
}

void DestroyObject( LPOBJECT lpObject )
{
	LPOBJECT object;

	while ( lpObject->lpNext )
	{
		object = lpObject->lpNext;
		lpObject->lpNext = lpObject->lpNext->lpNext;

		if ( object->lpVertices )
			delete [] object->lpVertices;

		if ( object->lpTriangles )
			delete [] object->lpTriangles;

		if ( object->lpTriMeshMatGroup )
			DestroyTriMeshMatGroup( object->lpTriMeshMatGroup );

		delete [] object;
	}

	delete [] lpObject;
}


void AddObject( LPOBJECT lpObject, LPOBJECT lpChildObject )
{
	LPOBJECT object = FindObject( lpObject, lpChildObject->szName );
	if ( !object )
	{
		object = lpObject;
		while ( object->lpNext )
			object = object->lpNext;

		object->lpNext = lpChildObject;
	}
}


void CalcVertexNormals( LPOBJECT lpObject )
{
	D3DVECTOR u, v, n;
	lpObject->lpD3DVertex = new D3DVERTEX [lpObject->NumVertices];

	LPD3DVERTEX lpD3DVertex = lpObject->lpD3DVertex;
	for ( int i=0; i<lpObject->NumVertices; i++ )
	{
		lpD3DVertex[i].x = lpObject->lpVertices[i].x;
		lpD3DVertex[i].y = lpObject->lpVertices[i].y;
		lpD3DVertex[i].z = lpObject->lpVertices[i].z;

		lpD3DVertex[i].tu = lpObject->lpTVertices[i].tu;
		lpD3DVertex[i].tv = lpObject->lpTVertices[i].tv;

		lpD3DVertex[i].nx = 0;
		lpD3DVertex[i].ny = 0;
		lpD3DVertex[i].nz = 0;
	}

	LPTRIANGLE lpTriangles = lpObject->lpTriangles;
	for ( i=0; i<lpObject->NumTriangles; i++ )
	{
		u.x = lpD3DVertex[ lpTriangles[i].vindices[0] ].x - lpD3DVertex[ lpTriangles[i].vindices[1] ].x;
		u.y = lpD3DVertex[ lpTriangles[i].vindices[0] ].y - lpD3DVertex[ lpTriangles[i].vindices[1] ].y;
		u.z = lpD3DVertex[ lpTriangles[i].vindices[0] ].z - lpD3DVertex[ lpTriangles[i].vindices[1] ].z;

		v.x = lpD3DVertex[ lpTriangles[i].vindices[0] ].x - lpD3DVertex[ lpTriangles[i].vindices[2] ].x;
		v.y = lpD3DVertex[ lpTriangles[i].vindices[0] ].y - lpD3DVertex[ lpTriangles[i].vindices[2] ].y;
		v.z = lpD3DVertex[ lpTriangles[i].vindices[0] ].z - lpD3DVertex[ lpTriangles[i].vindices[2] ].z;

		n = Normalize( CrossProduct( u, v ) );

		lpD3DVertex[ lpTriangles[i].vindices[0] ].nx += n.x;
		lpD3DVertex[ lpTriangles[i].vindices[0] ].ny += n.y;
		lpD3DVertex[ lpTriangles[i].vindices[0] ].nz += n.z;

		lpD3DVertex[ lpTriangles[i].vindices[1] ].nx += n.x;
		lpD3DVertex[ lpTriangles[i].vindices[1] ].ny += n.y;
		lpD3DVertex[ lpTriangles[i].vindices[1] ].nz += n.z;

		lpD3DVertex[ lpTriangles[i].vindices[2] ].nx += n.x;
		lpD3DVertex[ lpTriangles[i].vindices[2] ].ny += n.y;
		lpD3DVertex[ lpTriangles[i].vindices[2] ].nz += n.z;
	}

	for ( i = 0; i< lpObject->NumVertices; i++ )
	{
		n.x = lpD3DVertex[i].nx;
		n.y = lpD3DVertex[i].ny;
		n.z = lpD3DVertex[i].nz;	

		n = Normalize( n );

		lpD3DVertex[i].nx = n.x;
		lpD3DVertex[i].ny = n.y;
		lpD3DVertex[i].nz = n.z;	
	}
}

void CalcTriMeshMatGroup( LPOBJECT lpObject, LPMATERIAL lpMaterial )
{
	LPTRIMESHMATGROUP group = lpObject->lpTriMeshMatGroup;
	if ( !group )
	{
		group = CreateTriMeshMatGroup( "DEFAULT MATERIAL" );

		group->NumTriangles = lpObject->NumTriangles;
		group->lpTriangles = new WORD [ group->NumTriangles ];
		for ( int i=0; i<group->NumTriangles; i++ )
			group->lpTriangles[i] = i;
	}

	while ( group )
	{
		LPMATERIAL material = FindMaterial( lpMaterial, group->szName );
		if ( !material )
			material = FindMaterial( lpMaterial, "DEFAULT MATERIAL" );

		group->lpMaterial = material;

		group = group->lpNext;
	}
}

void CalcObject( LPOBJECT lpObject, LPMATERIAL lpMaterial )
{
	if ( !lpObject->lpTVertices )
	{
		lpObject->lpTVertices = new TVERTEX [ lpObject->NumVertices ];
		ZeroMemory( lpObject->lpTVertices, sizeof(TVERTEX)*lpObject->NumVertices );
	}

	CalcTriMeshMatGroup( lpObject, lpMaterial );

	CalcVertexNormals( lpObject );
}


// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
void CalcNormals( LPD3DVERTEX lpD3DVertex )
{
	D3DVECTOR u, v, n;

	u.x = lpD3DVertex[1].x - lpD3DVertex[0].x;
	u.y = lpD3DVertex[1].y - lpD3DVertex[0].y;
	u.z = lpD3DVertex[1].z - lpD3DVertex[0].z;

	v.x = lpD3DVertex[2].x - lpD3DVertex[0].x;
	v.y = lpD3DVertex[2].y - lpD3DVertex[0].y;
	v.z = lpD3DVertex[2].z - lpD3DVertex[0].z;

	n = Normalize( CrossProduct( u, v ) );

	lpD3DVertex[0].nx = n.x;
	lpD3DVertex[0].ny = n.y;
	lpD3DVertex[0].nz = n.z;

	lpD3DVertex[1].nx = n.x;
	lpD3DVertex[1].ny = n.y;
	lpD3DVertex[1].nz = n.z;

	lpD3DVertex[2].nx = n.x;
	lpD3DVertex[2].ny = n.y;
	lpD3DVertex[2].nz = n.z;
}

static WORD vlist[10000];
void RenderObject( LPDIRECT3DDEVICE2 lpDev, LPOBJECT lpObject )
{
	LPTRIANGLE	lpTriangles = lpObject->lpTriangles;

	LPTRIMESHMATGROUP group = lpObject->lpTriMeshMatGroup;
	while ( group )
	{
		SetAsCurrent( lpDev, group->lpMaterial );

		/*	OBJECT DATA STRUCT
			
			Name				Type			Size
			============================================================
			NumVertexList		WORD			NumVertices * 3;
			lpVertexList		WORD
			
			NumVertices			WORD
			lpVertices			D3DVERTEX

		*/

		for ( int i=0; i<group->NumTriangles; i++ )
		{
			vlist[3*i+0] = lpTriangles[ group->lpTriangles[i] ].vindices[0];
			vlist[3*i+1] = lpTriangles[ group->lpTriangles[i] ].vindices[1];
			vlist[3*i+2] = lpTriangles[ group->lpTriangles[i] ].vindices[2];
		}


		lpDev->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 
			                         D3DVT_VERTEX, 
									 (LPVOID)lpObject->lpD3DVertex, 
									 lpObject->NumVertices, 
									 (LPWORD)vlist, 
									 group->NumTriangles*3, 
									 D3DDP_WAIT );

		group = group->lpNext;
	}
}



