#ifndef __Object_H__
#define __Object_H__

#include "D3DIM.H"

#include "Light.H"
#include "Camera.H"
#include "Texture.H"
#include "Material.H"

#include "Matrix.H"


#pragma pack(1)

struct HEADER {
    DWORD   magic;
    BYTE    version;
};

typedef struct {
	WORD        vindices[3];			// array of triangle vertex indices
	WORD        nindices[3];			// array of triangle normal indices
	WORD        findex;					// index of triangle facet normal
} TRIANGLE, *LPTRIANGLE;

typedef struct _TRIMESHMATGROUP {
	WORD				NumTriangles;
	LPWORD				lpTriangles;

	char				szName[100];

	LPMATERIAL			lpMaterial;

	_TRIMESHMATGROUP	*lpNext;		// pointer to next trimesh mat group
} TRIMESHMATGROUP, *LPTRIMESHMATGROUP;

typedef struct _OBJECT {
	WORD				NumVertices;    	// number of vertices
	LPVECTOR			lpVertices;     	// array of vertices
	LPTVERTEX			lpTVertices;     	// array of texture vertices

	WORD				NumTriangles;       // number of triangles
	LPTRIANGLE			lpTriangles;        // array of triangles

	LPVECTOR			lpFacetNormals;     // array of facet normals

	WORD				NumNormals;			// number of normals
	LPVECTOR			lpNormals;      	// array of normals

	LPTRIMESHMATGROUP	lpTriMeshMatGroup;	// pointer to trimesh mat group

	D3DMATRIX			Matrix;				// object matrix
	LPD3DVERTEX			lpD3DVertex;

	char				szName[100];    	// name of this object
	_OBJECT				*lpNext;			// pointer to next object
} OBJECT, *LPOBJECT;
#pragma pack()



// TriMesh Material Group List
///////////////////////////////////////////////////////////////////////////////
LPTRIMESHMATGROUP CreateTriMeshMatGroup( char* lpszName );
LPTRIMESHMATGROUP CreateTriMeshMatGroup( LPTRIMESHMATGROUP lpTriMeshMatGroup, char* lpszName );

void DestroyTriMeshMatGroup( LPTRIMESHMATGROUP lpTriMeshMatGroup );


// Object List
///////////////////////////////////////////////////////////////////////////////
LPOBJECT FindObject( LPOBJECT lpObject, char* lpszName );

LPOBJECT CreateObject( char* lpszName );
LPOBJECT CreateObject( LPOBJECT lpObject, char* lpszName );

void DestroyObject( LPOBJECT lpObject );

void AddObject( LPOBJECT lpObject, LPOBJECT lpChildObject );


// Direct3D Func
///////////////////////////////////////////////////////////////////////////////
void CalcNormals( LPD3DVERTEX lpD3DVertex );

void RenderObject( LPDIRECT3DDEVICE2 lpDev, LPOBJECT lpObject );


// Etc Func
///////////////////////////////////////////////////////////////////////////////
void CalcTriMeshMatGroup( LPOBJECT lpObject, LPMATERIAL lpMaterial );

void CalcFacetNormals( LPOBJECT lpObject );
void CalcVertexNormals( LPOBJECT lpObject, float angle );

void CalcObject( LPOBJECT lpObject, LPMATERIAL lpMaterial );

#endif
