#include "Texture.H"

#pragma pack(1)
struct PCXHEADER {
	BYTE		ID;
	BYTE		Version;
	BYTE		Encoding;
	BYTE		BitsPerPixel;
	short		XMin;
	short		YMin;
	short		XMax;
	short		YMax;
	short		XResolution;
	short		YResolution;
	RGBENTRY	Palette[16];
	BYTE		Reserved;
	BYTE		NumPlanes;
	short		BytesPerRow;
	short		PalType;  // 1 for Color or B & W, 2 for Gray scale
	short		XScreen;
	short		YScreen;
	BYTE		Filter[54];
};
#pragma pack()


LPIMAGE LoadPCX( char *lpszFileName )
{
    // Open PCX File
    FILE *fp = fopen( lpszFileName, "rb" );
    if ( !fp )
        return FALSE;

	// Read PCX Header
    PCXHEADER Header;
	fread( &Header, sizeof(PCXHEADER), 1, fp );

    if ( Header.ID != 0x0A )
    {
        fclose( fp );
        return NULL;
    }
    if ( Header.Version != 5 )
    {
        fclose( fp );
        return NULL;
    }
    if ( Header.Encoding != 1 )
    {
        fclose( fp );
        return NULL;
    }
    if ( Header.BitsPerPixel != 8 )
    {
        fclose( fp );
        return NULL;
    }


    LPIMAGE lpImage = CreateImage( Header.BytesPerRow, Header.YMax-Header.YMin+1, Header.BitsPerPixel );
    if ( !lpImage )
    {
        fclose( fp );
        return NULL;
    }

    LPBYTE ptr = lpImage->lpData;

    // Read RLE Data
    fseek( fp, 128, SEEK_SET );

	int i, j = lpImage->Height;
    do
    {
        i = 0;
        do
        {
            char c = fgetc( fp );
            if ( (c & 192) == 192 )
            {
                c &= ~192;

                char oc = fgetc( fp );
                do
                {
                    *(ptr++) = oc;
                    i++;
                }
                while ( --c && i < lpImage->Width );
            }
            else
            {
                *(ptr++) = c;
                i++;
            }
        }
        while ( i < lpImage->Width );
    }
    while (--j);


	// Read 256 Color Palette Entry
    fseek( fp, -768, SEEK_END );
    for ( i=0; i<256; i++ )
    {
        lpImage->rgbEntry[i].Red   = (BYTE)fgetc( fp );
        lpImage->rgbEntry[i].Green = (BYTE)fgetc( fp );
        lpImage->rgbEntry[i].Blue  = (BYTE)fgetc( fp );
    }

	fclose( fp );

    return lpImage;
}
