#ifndef __Texture_H__
#define __Texture_H__

#include "D3DIM.H"

#pragma pack(1)
typedef struct {
    BYTE    Red;
    BYTE    Green;
    BYTE    Blue;
} RGBENTRY, *LPRGBENTRY;

typedef struct {
    WORD        Width;
    WORD        Height;
    BYTE        BitsPerPixel;

    LPBYTE      lpData;
    RGBENTRY    rgbEntry[256];
} IMAGE, *LPIMAGE;

typedef struct _TEXTURE {
	LPDIRECTDRAWSURFACE lpDDSurface;  // memory texture
	D3DTEXTUREHANDLE    Handle;

	char    			szName[100];
	_TEXTURE			*lpNext;
} TEXTURE, *LPTEXTURE;
#pragma pack()


// Texture List
///////////////////////////////////////////////////////////////////////////////
LPTEXTURE FindTexture( LPTEXTURE lpTexture, char* lpszName );

LPTEXTURE CreateTexture( char* lpszName );
LPTEXTURE CreateTexture( LPTEXTURE lpTexture, char* lpszName );

void DestroyTexture( LPTEXTURE lpTexture );

void AddTexture( LPTEXTURE lpTexture, LPTEXTURE lpChildTexture );


// Texture Func
///////////////////////////////////////////////////////////////////////////////
LPTEXTURE LoadTexture( LPDIRECTDRAW2 lpDD, LPDIRECT3DDEVICE2 lpDev, LPTEXTURE *lpTexture, char *lpszFileName );
LPTEXTURE Image2Texture( LPDIRECTDRAW2 lpDD, LPDIRECT3DDEVICE2 lpDev, LPTEXTURE *lpTexture, LPIMAGE lpImage, char *lpszName );


// Image Func
///////////////////////////////////////////////////////////////////////////////
LPIMAGE LoadCEL( char *lpszFileName );
LPIMAGE LoadPCX( char *lpszFileName );

LPIMAGE CreateImage( WORD Width, WORD Height, BYTE BPP );
void DestroyImage( LPIMAGE lpImage );


#endif
