#include <stdio.h>
#include <math.h>

#define Xdspsize 320
#define Ydspsize 200
#define Xwinsize 84
#define Ywinsize 64

#define lensize 60
#define xyrate 0.6

#define PI 3.14159
#define FADERES 50

int dx,dy;
int Ximgsize,Yimgsize;

typedef struct {
	unsigned char r;
	unsigned char g;
	unsigned char b;
} rgbpal;

unsigned char far *vtr=0xa0000000;
unsigned char far picbuf[65535];
rgbpal pal[256];

float radi(float deg)
{
    float radian;

    if(deg > 360 || deg < 0) return(-1);

    radian=(PI*deg)/180;

    return(radian);
}

float arad(float radian)
{
    float deg;

    deg=(radian*180)/PI;

    return(deg);
}

float dsin(float deg)
{
    return(sin(radi(deg)));
}

float dcos(float deg)
{
    return(cos(radi(deg)));
}

float dasin(float radian)
{
    return(arad(asin(radian)));
}

float dacos(float radian)
{
    return(arad(acos(radian)));
}

float dtan(float deg)
{
    return(tan(radi(deg)));
}

void setcol(char ColReg, char Red, char Green, char Blue )
{
    asm{
        mov   dx,0x03c8
        mov   al,[ColReg]
        out   dx,al

        inc   dx

        mov   al,[Red]
        out   dx,al
        mov   al,[Green]
        out   dx,al
        mov   al,[Blue]
        out   dx,al
    }
}

long filesize(FILE *stream)
{
    long curpos,length;

    curpos = ftell(stream);
    fseek(stream, 0L, SEEK_END);
    length = ftell(stream);
    fseek(stream, curpos, SEEK_SET);
    return length;
}

void loadpic(void)
{
    FILE *fp;
    int i,x,y,gray;
    long size;

    fp=fopen("unpcx.raw","rb");
    size=filesize(fp);

    fread(&Ximgsize,1,2,fp);
    fread(&Yimgsize,1,2,fp);

    // load picture
    fread(picbuf,1,(size-4)%65536,fp);
    fclose( fp );

    fp=fopen("unpcx.pal","rb");
    size=filesize(fp);

    // load palette
    fread(pal,1,size,fp);
    fclose( fp );

    //set palette
    for(i=0;i<256;i++) setcol(i,0,0,0);
}

float fade[768];
int fadein(int fadcnt)
{
    int i,wf,ff;

    ff=0;
    for( i=0 ; i<256 ; i++ ) {
        wf=0;
        if(pal[i].r>fade[i*3+0]) {fade[i*3+0]+=(float)pal[i].r/fadcnt;wf=ff=1;}
        if(pal[i].g>fade[i*3+1]) {fade[i*3+1]+=(float)pal[i].g/fadcnt;wf=ff=1;}
        if(pal[i].b>fade[i*3+2]) {fade[i*3+2]+=(float)pal[i].b/fadcnt;wf=ff=1;}

        if(wf) setcol(i,(char)fade[i*3]>>2,(char)fade[i*3+1]>>2,(char)fade[i*3+2]>>2);
    }

    return ff;
}

int fadeout(int fadcnt)
{
    int i,wf,ff;

    ff=0;
    for( i=0 ; i<256 ; i++ ) {
        wf=0;
        if(fade[i*3+0]>=1) {fade[i*3+0]-=(float)pal[i].r/fadcnt;wf=ff=1;}
        if(fade[i*3+1]>=1) {fade[i*3+1]-=(float)pal[i].g/fadcnt;wf=ff=1;}
        if(fade[i*3+2]>=1) {fade[i*3+2]-=(float)pal[i].b/fadcnt;wf=ff=1;}

        if(wf) setcol(i,(char)fade[i*3]>>2,(char)fade[i*3+1]>>2,(char)fade[i*3+2]>>2);
    }

    return ff;
}

void main(void)
{
    unsigned i,j;
    int a,b,infg;
    float g;

    asm mov   ax,0x13
    asm int   0x10

    loadpic();

    memcpy(vtr,picbuf,64000);
    delay(500);

    infg=1;

    dx=0;
    dy=0;
    a=4;
    b=4;

    while(1) {
        if(infg) infg=fadein(FADERES);

        for(j=0;j<Ywinsize;j++) {
            for(i=0;i<Xwinsize;i++) {
                g=1;
                if(sqrt((float)(i*i*xyrate+j*j))<lensize) g=dtan(sqrt((float)(i*i*xyrate+j*j))/2.5+20);

                vtr[(Ydspsize/2+j+dy)*Xdspsize+Xdspsize/2-i+dx]=picbuf[(int)(Yimgsize/2+(j*g)+dy)*Ximgsize+(int)(Ximgsize/2-(i*g)+dx)];
                vtr[(Ydspsize/2+j+dy)*Xdspsize+Xdspsize/2+i+dx]=picbuf[(int)(Yimgsize/2+(j*g)+dy)*Ximgsize+(int)(Ximgsize/2+(i*g)+dx)];
                vtr[(Ydspsize/2-j+dy)*Xdspsize+Xdspsize/2-i+dx]=picbuf[(int)(Yimgsize/2-(j*g)+dy)*Ximgsize+(int)(Ximgsize/2-(i*g)+dx)];
                vtr[(Ydspsize/2-j+dy)*Xdspsize+Xdspsize/2+i+dx]=picbuf[(int)(Yimgsize/2-(j*g)+dy)*Ximgsize+(int)(Ximgsize/2+(i*g)+dx)];
            }
        }

        dx+=a;
        dy+=b*xyrate;
        if(Xdspsize<Xdspsize/2+Xwinsize+dx) {a=-4;dx+=a;}
        if(0>Xdspsize/2-Xwinsize+dx) {a=4;dx+=a;}
        if(Ydspsize<Ydspsize/2+Ywinsize+dy) {b=-4;dy+=b*xyrate;}
        if(0>Ydspsize/2-Ywinsize+dy) {b=4;dy+=b*xyrate;}

        if(kbhit()) {
            infg=0;
            if(fadeout(FADERES)==0) {getch(); break;}
        }
    }

    asm mov   ax,0x03
    asm int   0x10
}
