#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <dos.h>
#include <conio.h>

typedef struct {
	unsigned char r;
	unsigned char g;
	unsigned char b;
} rgbpal;

typedef struct {
   char manufacturer;
   char version;
   char encoding;
   char bpp;
   int xmin,ymin;
   int xmax,ymax;
   int hres;
   int vres;
   char palette[48];
   char reserved;
   char colour_planes;
   int bpl;
   int palette_type;
   char filler[58];
}PCXHEAD;

int ys=0,yn=480,xs=0,xn=640;
int rate=1;

void main(int argc, char *argv[])
{
    rgbpal pal[256];
    PCXHEAD header;

    FILE *fpr,*fpw;
    long bytes,size;
    int i,k,count,c;

    fpr=fopen(argv[1],"rb");

    if(fpr==0) {printf("PCX file not found!\n"); exit(0);}

    fseek(fpr,-769l,SEEK_END);

    if (fgetc(fpr)!=0x0c || fread(pal,1,768,fpr)!=768)
    {
        printf("Palette Broken\n");
        exit(0);
    }

    rewind(fpr);
    if (fread((char *)&header,1,128,fpr)!=128) {
        printf("file header Broken\n");
        exit(0);
    }

    if (header.manufacturer!=0x0a || header.version != 5 || header.bpp !=8 || header.colour_planes!=1)
    {
        printf("Not 256 Color PCX\n");
        exit(0);
    }

    fpw=fopen("unpcx.raw","wb");
    if(header.xmax+1<xn) i=header.xmax+1;
    else i=xn/rate;
    if(header.ymax+1<yn) k=header.ymax+1;
    else k=yn/rate;
    fwrite(&i,1,2,fpw);
    fwrite(&k,1,2,fpw);

    size=(long)(header.ymax+1)*header.bpl;
    bytes=0;
    while(bytes<size) {
        c=fgetc(fpr);
        c&=0xff;
        if((c&0xc0)==0xc0) {
            count=c&0x3f;
            c=fgetc(fpr);
            while(count) {
                if(bytes/header.bpl>=ys && bytes/header.bpl<ys+yn && bytes%header.bpl>=xs && bytes%header.bpl<xs+xn)
                if((bytes/header.bpl)%rate==0 && (bytes%header.bpl)%rate==0) fputc(c,fpw);++bytes;--count;
            }
        }
        else {
            if(bytes/header.bpl>=ys && bytes/header.bpl<ys+yn && bytes%header.bpl>=xs && bytes%header.bpl<xs+xn)
            if((bytes/header.bpl)%rate==0 && (bytes%header.bpl)%rate==0) fputc((unsigned char)c,fpw);++bytes;
        }
    }
    fclose(fpw);
    fpw=fopen("unpcx.pal","wb");
    fwrite(pal,768,1,fpw);
    fclose(fpw);
    fpw=fopen("unpcx.inf","wt");

    fprintf(fpw,"menu=%d\n",header.manufacturer);
    fprintf(fpw,"ver =%d\n",header.version);
    fprintf(fpw,"enc =%d\n",header.encoding);
    fprintf(fpw,"bpp =%d\n",header.bpp);
    fprintf(fpw,"xmin= %d, xmax= %d\n",header.xmin,header.xmax);
    fprintf(fpw,"ymin= %d, ymax= %d\n",header.ymin,header.ymax);
    fprintf(fpw,"hres= %d, vres= %d\n",header.hres,header.vres);
    fprintf(fpw,"plans=%d\n",header.colour_planes);
    fprintf(fpw,"bpl =%d\n",header.bpl);
    fprintf(fpw,"paltype =%d\n",header.palette_type);
    fprintf(fpw,"filesize =%ld\n",size);

    fclose(fpw);
}


