unit Main;

interface
// {$R Image.Res}

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   StdCtrls, ExtCtrls;

const
   MAX_X_LINE  = 640;
   MAX_Y_LINE  = 480;

   MAX_X_IMAGE = 64;
   MAX_Y_IMAGE = 79;

   MAX_FRAME   = 8;

type
   TBasic = class(TForm)
      Timer1 : TTimer;
      procedure FormCreate (Sender: TObject);
      procedure FormDestroy(Sender: TObject);
      procedure Timer1Timer(Sender: TObject);
      procedure FormKeyDown(Sender: TObject; var Key: Word;
                            Shift: TShiftState);
   private
      BackBuffer    : TBitmap;
      Tile          : array[0..MAX_FRAME] of TBitmap;
      Frame         : integer;
      PredImageAxis : TPoint;
      ImageAxis     : TPoint;
      DrawAxis      : TPoint;
      Move_Gap      : integer;

   public
     { Public declarations }
   end;

var
   Basic: TBasic;

implementation

{$R *.DFM}

procedure TBasic.FormCreate(Sender: TObject);
const
   IMAGE_DATA_RES   = 'Gals';
   BACK_GROUND_RES  = 'Moon';
var
   i : integer;
begin

   PredImageAxis := Point(200,150);
   ImageAxis     := PredImageAxis;
   Frame         := 0;
   Move_Gap      := 1;

   BackBuffer     := TBitmap.Create;
   BackBuffer.LoadFromResourceName(hInstance,IMAGE_DATA_RES);

   Tile[0]        := TBitmap.Create;
   Tile[0].Width  := MAX_X_IMAGE;
   Tile[0].Height := MAX_Y_IMAGE;

   for i := 1 to MAX_FRAME do begin
      Tile[i]                  := TBitmap.Create;
      Tile[i].Width            := MAX_X_IMAGE;
      Tile[i].Height           := MAX_Y_IMAGE;
      Tile[i].Canvas.CopyRect(Bounds(0,0,MAX_X_IMAGE,MAX_Y_IMAGE),BackBuffer.Canvas,Bounds(pred(i)*succ(MAX_X_IMAGE)+2,2,MAX_X_IMAGE,MAX_Y_IMAGE));
      Tile[i].Transparent      := TRUE;
      Tile[i].TransParentColor := RGB(0,255,0);
   end;

   BackBuffer.Free;

   BackBuffer    := TBitmap.Create;
   BackBuffer.LoadFromResourceName(hInstance,BACK_GROUND_RES);

   DrawAxis.X    := (Screen.Width  - BackBuffer.Width ) div 2;
   DrawAxis.Y    := (Screen.Height - BackBuffer.Height) div 2;

   Tile[0].Canvas.CopyRect(Bounds(0,0,MAX_X_IMAGE,MAX_Y_IMAGE),BackBuffer.Canvas,Bounds(ImageAxis.X,ImageAxis.Y,MAX_X_IMAGE,MAX_Y_IMAGE));

   Color         := clBlack;
   SetBounds(DrawAxis.X,DrawAxis.Y,BackBuffer.Width,BackBuffer.Height);

   Canvas.Draw(0,0,BackBuffer);
end;

procedure TBasic.FormDestroy(Sender: TObject);
var
   i : integer;
begin
   BackBuffer.Free;
   for i := 0 to MAX_FRAME do
      Tile[i].Free;
end;

procedure TBasic.Timer1Timer(Sender: TObject);
begin
   inc(Frame);
   if Frame > MAX_FRAME then Frame := 1;

   BackBuffer.Canvas.Draw(PredImageAxis.X,PredImageAxis.Y,Tile[0]);
   Tile[0].Canvas.CopyRect(Bounds(0,0,MAX_X_IMAGE,MAX_Y_IMAGE),BackBuffer.Canvas,Bounds(ImageAxis.X,ImageAxis.Y,MAX_X_IMAGE,MAX_Y_IMAGE));

   BackBuffer.Canvas.Draw(ImageAxis.X,ImageAxis.Y,tile[Frame]);
   Canvas.Draw(0,0,BackBuffer);

   PredImageAxis := ImageAxis;
end;

procedure TBasic.FormKeyDown(Sender: TObject; var Key: Word;
                             Shift: TShiftState);
begin
   case Key of
      VK_UP    : dec(ImageAxis.Y,Move_Gap);
      VK_DOWN  : inc(ImageAxis.Y,Move_Gap);
      VK_LEFT  : dec(ImageAxis.X,Move_Gap);
      VK_RIGHT : inc(ImageAxis.X,Move_Gap);
   end;
end;

end.

