unit MainUnt1;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   DDraw, DDUtils;

const
   MAX_IMAGE_SURFACE = 1;
   BitmapName        = 'Test';
   MAX_X_LINE        = 640;
   MAX_Y_LINE        = 480;

type
   TBasic = class(TForm)

      procedure FormCreate(Sender: TObject);
      procedure FormDestroy(Sender: TObject);
      procedure FormShow(Sender: TObject);

   private
      FPixelFormat   : (pfRGB, pfBGR);

      function  GetBitmapName(i : integer) : string;

   public
      DirectDraw     : IDirectDraw2;        // DirectDraw object  
      PrimarySurface : IDirectDrawSurface2; //  ȭ 
      BackBuffer     : IDirectDrawSurface2; // ĸ 
      Image          : array[1..MAX_IMAGE_SURFACE] of IDirectDrawSurface2;
                                            // ̹ 
   end;

var
   Basic: TBasic;

implementation

{$R *.DFM}

function TBasic.GetBitmapName(i : integer) : string;
begin
   GetBitmapName := ExtractFilePath(Application.ExeName)
                    + BitmapName + IntToStr(i) + '.BMP';
end;

procedure TBasic.FormCreate(Sender: TObject);
begin

  { DD COM ü  }
   if DirectDrawCreate2(nil,DirectDraw,nil) <> DD_OK then
      Raise Exception.Create('DirectDraw ü  ');

  {  ڵ鷯  }
//   Application.OnException := ExceptionHandler;
//   Application.OnMinimize  := FormMinimize;
//   Application.OnRestore   := FormOnRestore;

  {  ڸ ְ  , Ŀ  }
   Color       := clBlack;
   BorderStyle := bsNone;
   Cursor      := crNone;
end;

procedure TBasic.FormDestroy(Sender: TObject);
var
   i : integer;
begin
  {  ø  }
//   FlippingEnabled := FALSE;

  { ȭ   }
   if Assigned(PrimarySurface) then PrimarySurface.Release;
   for i := 1 to MAX_IMAGE_SURFACE do begin
      if Assigned(Image[i]) then Image[i].Release;
   end;

  { DirectDraw COM ü  }
   if Assigned(DirectDraw) then DirectDraw.Release;
   DirectDraw := nil;

  {  ڵ鷯  }
//   Application.OnException := nil;

end;

procedure TBasic.FormShow(Sender: TObject);
var
   i             : integer;
   DDSurfaceDesc : TDDSurfaceDesc;
   DDSCaps       : TDDSCaps;
   DDPixelFormat : TDDPixelFormat;
   ColorKey      : TDDColorKey;
begin
   if not Assigned(DirectDraw) then exit;

  { Ÿ Ǯũ Ȯ }
   if DirectDraw.SetCooperativeLevel(Handle,DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN or DDSCL_ALLOWREBOOT) <> DD_OK then
      Raise Exception.Create('Ÿ Ǯũ  ');

  { ȭ  ٲ }
   if DirectDraw.SetDisplayMode(MAX_X_LINE,MAX_Y_LINE,24,0,0) <> DD_OK then
      Raise Exception.Create('640 x 480 x 24bit  ');

  { DirectDrawSurface ũ  }
   FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
   with DDSurfaceDesc do begin
      dwSize            := SizeOf(DDSurfaceDesc);
      dwFlags           := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
      ddSCaps.dwCaps    := DDSCAPS_COMPLEX or DDSCAPS_FLIP or DDSCAPS_PRIMARYSURFACE;
      dwBackBufferCount := 1;
   end;

  {  ȭ   }
   if DirectDraw.CreateSurface(DDSurfaceDesc,PrimarySurface,nil) <> DD_OK then
      Raise Exception.Create(' ȭ   ');

  { ĸ  ü  }
   DDSCaps.dwCaps := DDSCAPS_BACKBUFFER;
   if PrimarySurface.GetAttachedSurface(DDSCaps,BackBuffer) <> DD_OK then
      Raise Exception.Create('ĸ   ');

  { 24Ʈ ÷ ȼ  ǵ }
   FillChar(DDPixelFormat,sizeof(DDPixelFormat),0);
   DDPixelFormat.dwSize := sizeof(DDPixelFormat);
   if PrimarySurface.GetPixelFormat(DDPixelFormat) <> DD_OK then
      Raise Exception.Create('ȼ  б ');

   if DDPixelFormat.dwRBitMask = $00FF0000 then
      FPixelFormat := pfRGB
   else if DDPixelFormat.dwRBitMask = $000000FF then
      FPixelFormat := pfBGR
   else
      Raise Exception.Create('ȼ  ǵ ');


  { Ʈ  & ε }
   for i := 1 to MAX_IMAGE_SURFACE do begin
      Image[i] := DDLoadBitmap(DirectDraw,GetBitmapName(i),0,0);
   end;

  {   }
   for i := 1 to MAX_IMAGE_SURFACE do begin
      ColorKey.dwColorSpaceLowValue := 0;
      ColorKey.dwColorSpaceHighValue := 0;
      if Image[i].SetColorKey(DDCKEY_SRCBLT,ColorKey) <> DD_OK then
         Raise Exception.Create('  ');
   end;

  {  Ÿ ʱȭ }
//   InitializeGame;

  { ø  · }
//   FlippingEnabled := TRUE;

end;

end.
