unit MainUnt2;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   DDraw, DDUtils;

const
   MAX_IMAGE_SURFACE = 1;
   BitmapName        = 'Test';
   MAX_X_LINE        = 640;
   MAX_Y_LINE        = 480;

type
   TBasic = class(TForm)

      procedure FormCreate(Sender: TObject);
      procedure FormDestroy(Sender: TObject);
      procedure FormMinimize(Sender: TObject);
      procedure FormOnRestore(Sender: TObject);
      procedure FormShow(Sender: TObject);
      procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);

   private
      FPixelFormat      : (pfRGB, pfBGR);
      FPreviousFlipping : boolean;
      FFlippingEnabled  : boolean;

      procedure ExceptionHandler(Sender : TObject; Error : Exception);
      procedure HandleMessage(var Msg : TMsg; var Handled : boolean);
      procedure IdleHandler(Sender : TObject; var Done : boolean);
      function  GetBitmapName(i : integer) : string;
      procedure SetFlippingEnabled(Value : boolean);

   public
      DirectDraw     : IDirectDraw2;        // DirectDraw object  
      PrimarySurface : IDirectDrawSurface2; //  ȭ 
      BackBuffer     : IDirectDrawSurface2; // ĸ 
      Image          : array[1..MAX_IMAGE_SURFACE] of IDirectDrawSurface2;
                                            // ̹ 

      procedure UpdateDisplay(is_commandable : boolean);
      property  FlippingEnabled : boolean read FFlippingEnabled
                                          write SetFlippingEnabled;
   end;

var
   Basic: TBasic;

implementation

{$R *.DFM}

procedure TBasic.ExceptionHandler(Sender : TObject; Error : Exception);
var
   WasEnabled : boolean;
//   WasLocked  : boolean;
begin
  {  ޼ ̱  GDI ȯ }
   MessageBeep(0);

   WasEnabled      := FlippingEnabled;
   FlippingEnabled := FALSE;
(*
   WasLocked       := FIsLocked;
   if WasLocked then begin
      UnlockBackGround;
   end;
*)
   if Assigned(DirectDraw) then DirectDraw.FlipToGDISurface;

   MessageDlg(Error.Message,mtError,[mbOK],0);
(*
   if WasLocked then begin
      LockBackGround;
   end;
*)
   FlippingEnabled := WasEnabled;

end;

procedure TBasic.HandleMessage(var Msg : TMsg; var Handled : boolean);
begin
   UpdateDisplay(TRUE);
end;

procedure TBasic.IdleHandler(Sender : TObject; var Done : boolean);
begin
   UpdateDisplay(TRUE);
   Done := FALSE;
end;

procedure TBasic.SetFlippingEnabled(Value : boolean);
begin
   if Value <> FFlippingEnabled then begin
      FFlippingEnabled := Value;
      if FFlippingEnabled then begin
        {  ̺Ʈ ڵ鷯 ġ }
         Application.OnMessage := HandleMessage;
         Application.OnIdle := IdleHandler;
      end else begin
        {  ̺Ʈ ڵ鷯  }
         Application.OnMessage := nil;
         Application.OnIdle := nil;
      end;
   end;
end;

procedure TBasic.FormMinimize(Sender: TObject);
begin
   FPreviousFlipping := FlippingEnabled;
   FlippingEnabled   := FALSE;
end;

procedure TBasic.FormOnRestore(Sender: TObject);
begin
   FlippingEnabled   := FPreviousFlipping;
end;

procedure TBasic.UpdateDisplay(is_commandable : boolean);
begin
(*
   DrawScroll;
   repeat
   until MakeItSo(PrimarySurface.Flip(nil,DDFLIP_WAIT));
*)
   PrimarySurface.Flip(nil,DDFLIP_WAIT);
end;

function TBasic.GetBitmapName(i : integer) : string;
begin
   Result := ExtractFilePath(Application.ExeName) + BitmapName + IntToStr(i) + '.BMP';
end;

procedure TBasic.FormCreate(Sender: TObject);
begin

  { DD COM ü  }
   if DirectDrawCreate2(nil,DirectDraw,nil) <> DD_OK then
      Raise Exception.Create('DirectDraw ü  ');

  {  ڵ鷯  }
   Application.OnException := ExceptionHandler;
   Application.OnMinimize  := FormMinimize;
   Application.OnRestore   := FormOnRestore;

  {  ڸ ְ  , Ŀ  }
   Color       := clBlack;
   BorderStyle := bsNone;
   Cursor      := crNone;
end;

procedure TBasic.FormDestroy(Sender: TObject);
var
   i : integer;
begin
  {  ø  }
   FlippingEnabled := FALSE;

  { ȭ   }
   if Assigned(PrimarySurface) then PrimarySurface.Release;
   for i := 1 to MAX_IMAGE_SURFACE do begin
      if Assigned(Image[i]) then Image[i].Release;
   end;

  { DirectDraw COM ü  }
   if Assigned(DirectDraw) then DirectDraw.Release;
   DirectDraw := nil;

  {  ڵ鷯  }
   Application.OnException := nil;

end;

procedure TBasic.FormShow(Sender: TObject);
var
   i             : integer;
   DDSurfaceDesc : TDDSurfaceDesc;
   DDSCaps       : TDDSCaps;
   DDPixelFormat : TDDPixelFormat;
   ColorKey      : TDDColorKey;
begin
   if not Assigned(DirectDraw) then exit;

  { Ÿ Ǯũ Ȯ }
   if DirectDraw.SetCooperativeLevel(Handle,DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN or DDSCL_ALLOWREBOOT) <> DD_OK then
      Raise Exception.Create('Ÿ Ǯũ  ');

  { ȭ  ٲ }
   if DirectDraw.SetDisplayMode(MAX_X_LINE,MAX_Y_LINE,24,0,0) <> DD_OK then
      Raise Exception.Create('640 x 480 x 24bit  ');

  { DirectDrawSurface ũ  }
   FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
   with DDSurfaceDesc do begin
      dwSize            := SizeOf(DDSurfaceDesc);
      dwFlags           := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
      ddSCaps.dwCaps    := DDSCAPS_COMPLEX or DDSCAPS_FLIP or DDSCAPS_PRIMARYSURFACE;
      dwBackBufferCount := 1;
   end;

  {  ȭ   }
   if DirectDraw.CreateSurface(DDSurfaceDesc,PrimarySurface,nil) <> DD_OK then
      Raise Exception.Create(' ȭ   ');

  { ĸ  ü  }
   DDSCaps.dwCaps := DDSCAPS_BACKBUFFER;
   if PrimarySurface.GetAttachedSurface(DDSCaps,BackBuffer) <> DD_OK then
      Raise Exception.Create('ĸ   ');

  { 24Ʈ ÷ ȼ  ǵ }
   FillChar(DDPixelFormat,sizeof(DDPixelFormat),0);
   DDPixelFormat.dwSize := sizeof(DDPixelFormat);
   if PrimarySurface.GetPixelFormat(DDPixelFormat) <> DD_OK then
      Raise Exception.Create('ȼ  б ');

   if DDPixelFormat.dwRBitMask = $00FF0000 then
      FPixelFormat := pfRGB
   else if DDPixelFormat.dwRBitMask = $000000FF then
      FPixelFormat := pfBGR
   else
      Raise Exception.Create('ȼ  ǵ ');


  { Ʈ  & ε }
   for i := 1 to MAX_IMAGE_SURFACE do begin
      Image[i] := DDLoadBitmap(DirectDraw,GetBitmapName(i),0,0);
   end;

  {   }
   for i := 1 to MAX_IMAGE_SURFACE do begin
      ColorKey.dwColorSpaceLowValue := 0;
      ColorKey.dwColorSpaceHighValue := 0;
      if Image[i].SetColorKey(DDCKEY_SRCBLT,ColorKey) <> DD_OK then
         Raise Exception.Create('  ');
   end;

  {  Ÿ ʱȭ }
//   InitializeGame;

  { ø  · }
   FlippingEnabled := TRUE;

end;

procedure TBasic.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if ssAlt in Shift then Key := 0;
   if key = VK_ESCAPE then Close;
//   if KeyBuffer.is_installed then KeyBuffer.Key := key;
end;

end.
