unit Subunit5;

interface

uses
   Windows, DDraw;

type
   TTileInfo = (tiFireBall, tiFlame, tiEnergyBall, tiNeTo1, tiNeTo2, tiDemon);

const
   TileInfo : array[TTileInfo] of TRect = (
      (Left :   0; Top :   0; Right :  27; Bottom :  11),
      (Left :  30; Top :   0; Right :  70; Bottom :  22),
      (Left :  73; Top :   0; Right :  84; Bottom :  11),
      (Left :   0; Top :  26; Right :  52; Bottom :  95),
      (Left :  56; Top :  26; Right : 108; Bottom :  95),
      (Left :   7; Top :  99; Right : 257; Bottom : 369)
   );

type

   PCharacter = ^TCharacter;
   TCharacter = object

      constructor create(number : TTileInfo; x, y, HP : integer);
      destructor  destroy;
      procedure   DisplaySelf; virtual;
      function    DoAction : boolean; virtual;

   private
      m_number   : TTileInfo;
      m_x_size   : integer;
      m_y_size   : integer;
      m_x, m_y   : integer;
      m_sx, m_sy : real;
      m_HP       : integer;
      m_Tile     : TRect;
      procedure setmX (x : integer);
      procedure setmY (y : integer);
      procedure setmSX(x : real);
      procedure setmSY(y : real);

   public
      property  mNumber : TTileInfo  read m_number write m_number;
      property  mXSize  : integer    read m_x_size write m_x_size;
      property  mYSize  : integer    read m_y_size write m_y_size;
      property  mX      : integer    read m_x      write setmX;
      property  mY      : integer    read m_y      write setmY;
      property  mSX     : real       read m_sx     write setmSX;
      property  mSY     : real       read m_sy     write setmSY;
      property  mHP     : integer    read m_HP     write m_HP;
      property  mTile   : TRect      read m_Tile   write m_Tile;

   end;

   PObjects = ^TObjects;
   TObjects = object(TCharacter)

      constructor create(number : TTileInfo; x, y, HP : integer; vx, vy, ax, ay : real);
      destructor  destroy;
      function    DoAction : boolean;  virtual;

   private
      m_vx, m_vy : real;
      m_ax, m_ay : real;

   public
      property  mVX : real  read m_vx  write m_vx;
      property  mVY : real  read m_vy  write m_vy;
      property  mAX : real  read m_ax  write m_ax;
      property  mAY : real  read m_ay  write m_ay;

   end;

   PEnemy = ^TEnemy;
   TEnemy = object(TObjects)

      constructor create(number : TTileInfo; x, y, HP : integer);
      destructor  destroy;
      function    DoAction : boolean; virtual;

   end;

   PFriend = ^TFriend;
   TFriend = object(TObjects)

      constructor create(number : TTileInfo; x, y, HP : integer);
      destructor  destroy;
      procedure   DisplaySelf; virtual;
      function    DoAction : boolean; virtual;

   private
      FShapeCount : integer;
      FShapeDelay : integer;

   end;

const
   MAX_CHARACTER = 50;
var
   Objects : array[1..MAX_CHARACTER] of PCharacter;

implementation

uses
   MainUnt5;


function GetFreeObjects(var number : integer) : boolean;
var
   i : integer;
begin
   for i := 1 to MAX_CHARACTER do begin
       if objects[i] = nil then begin
          number := i;
          getFreeObjects := TRUE;
          exit;
       end;
   end;
   getFreeObjects := FALSE;
end;

(******************************************************************************)

constructor TCharacter.create(number : TTileInfo; x, y, HP : integer);
begin
   mNumber  := number;
   m_Tile   := TileInfo[number];
   m_x_size := TileInfo[number].Right-TileInfo[number].Left;
   m_y_size := TileInfo[number].Bottom-TileInfo[number].Top;
   mX       := x;
   mY       := y;
   mHP      := HP;
   m_sx     := x;
   m_sy     := y;
end;

destructor  TCharacter.destroy;
begin
end;

procedure   TCharacter.setmX(x : integer);
begin
   if (x >= 0) and (x + mXSize < MAX_X_LINE) then begin
      m_x  := x;
      m_sx := x;
   end;
end;

procedure   TCharacter.setmY(y : integer);
begin
   if (y >= 0) and (y + mYSize < MAX_Y_LINE) then begin
      m_y  := y;
      m_sy := y;
   end;
end;

procedure   TCharacter.setmSX(x : real);
begin
   if x < 0 then x := 0;
   if x >= MAX_X_LINE - mXSize then x := MAX_X_LINE - mXSize - 1;
   m_sx := x;
   m_x  := Trunc(x+0.5);
end;

procedure   TCharacter.setmSY(y : real);
begin
   if y < 0 then y := 0;
   if y >= MAX_Y_LINE - mYSize then y := MAX_Y_LINE - mYSize - 1;
   m_sy := y;
   m_y  := Trunc(y+0.5);
end;

procedure   TCharacter.DisplaySelf;
begin
   with Basic do repeat
   until MakeItSo(BackBuffer.BltFast(mX,mY,Image[1],mTile,DDBLTFAST_SRCCOLORKEY));
end;

function    TCharacter.DoAction;
begin
   DoAction := TRUE;
end;

(******************************************************************************)

constructor TObjects.create(number : TTileInfo; x, y, HP : integer; vx, vy, ax, ay : real);
begin
   inherited create(number,x,y,HP);
   mVX := vx;  mVY := vy;
   mAX := ax;  mAY := ay;
end;

destructor  TObjects.destroy;
begin
end;

function    TObjects.DoAction;
begin
   DoAction := TRUE;

   if ((mX + mVX) < 0) or ((mX + mVX) >= MAX_X_LINE-mXSize) or
      ((mY + mVY) < 0) or ((mY + mVY) >= MAX_Y_LINE-mYSize) then begin
      DoAction := FALSE;
   end else begin
      mSX := mSX  + mVX;
      mSY := mSY  + mVY;
      mVX := mVX + mAX;
      mVY := mVY + mAY;
   end;
end;

(******************************************************************************)

constructor TEnemy.create(number : TTileInfo; x, y, HP : integer);
begin
   inherited create(number,x,y,HP,2,2,0,0);
end;

destructor  TEnemy.destroy;
begin
end;

function    TEnemy.DoAction;
var
   i : integer;
begin
   DoAction := TRUE;

   mX := mX + (random(3)-1);
   mY := mY + (random(3)-1);

   if random(10) = 0 then begin
      if GetFreeObjects(i) then begin
         Objects[i] := new(PObjects,Create(tiEnergyBall,mX,mY+100,10,-10,random(5)-3,0,0));
      end;
   end;
end;

(******************************************************************************)

constructor TFriend.create(number : TTileInfo; x, y, HP : integer);
begin
   inherited create(number,x,y,HP,2,2,0,0);
   FShapeCount := 0;
   FShapeDelay := 0;
end;

destructor  TFriend.destroy;
begin
end;

procedure   TFriend.DisplaySelf;
begin

   inc(FShapeDelay);
   if FShapeDelay = 5 then begin
      FShapeCount := FShapeCount xor 1;
      FShapeDelay := 0;
   end;

   with Basic do repeat
   until MakeItSo(BackBuffer.BltFast(mX,mY,Image[1],TileInfo[TTileInfo(ord(mNumber)+FShapeCount)],
                  DDBLTFAST_SRCCOLORKEY));
end;

function    TFriend.DoAction;
var
   i : integer;
begin
   DoAction := TRUE;

   if GetAsyncKeyState(VK_LEFT) <> 0 then mSX := mSX - mVX;
   if GetAsyncKeyState(VK_RIGHT)<> 0 then mSX := mSX + mVX;
   if GetAsyncKeyState(VK_UP)   <> 0 then mSY := mSY - mVY;
   if GetAsyncKeyState(VK_DOWN) <> 0 then mSY := mSY + mVY;

   if GetAsyncKeyState(VK_CONTROL) <> 0 then begin
      if GetFreeObjects(i) then begin
         Objects[i] := new(PObjects,Create(tiFireBall,mX+15,mY+25,10,16,0,0,0));
      end;
   end;

   if GetAsyncKeyState(VK_MENU) <> 0 then begin
      if GetFreeObjects(i) then begin
         Objects[i] := new(PObjects,Create(tiFlame,mX,mY,10,16,0,0,0));
      end;
   end;
end;

(******************************************************************************)

var
   i : integer;
begin
   for i := 1 to MAX_CHARACTER do begin
      Objects[i] := nil;
   end;
end.
