unit Subunit7;

interface

uses
   Windows, Classes, DDraw;

type
   TColorInfo = (ciRed, ciGreen, ciBlue);
   TTileInfo  = (tiFireBall, tiFlame, tiEnergyBall, tiNeTo1, tiNeTo2, tiDemon);
   STileInfo  = set of TTileInfo;

const
   TileInfo : array[TTileInfo] of TRect = (
      (Left :   0; Top :   0; Right :  27; Bottom :  11),
      (Left :  30; Top :   0; Right :  70; Bottom :  22),
      (Left :  73; Top :   0; Right :  84; Bottom :  11),
      (Left :   0; Top :  26; Right :  52; Bottom :  95),
      (Left :  56; Top :  26; Right : 108; Bottom :  95),
      (Left :   7; Top :  99; Right : 257; Bottom : 369)
   );

type

   PCharacter = ^TCharacter;
   TCharacter = object

      constructor create(number : TTileInfo; x, y, HP : integer);
      destructor  destroy;
      procedure   DisplaySelf; virtual;
      function    DoAction : boolean; virtual;

   private
      m_number   : TTileInfo;
      m_x_size   : integer;
      m_y_size   : integer;
      m_x, m_y   : integer;
      m_sx, m_sy : real;
      m_HP       : integer;
      m_Tile     : TRect;

      procedure setmX (x : integer);
      procedure setmY (y : integer);
      procedure setmSX(x : real);
      procedure setmSY(y : real);

   public
      property  mNumber : TTileInfo  read m_number write m_number;
      property  mXSize  : integer    read m_x_size write m_x_size;
      property  mYSize  : integer    read m_y_size write m_y_size;
      property  mX      : integer    read m_x      write setmX;
      property  mY      : integer    read m_y      write setmY;
      property  mSX     : real       read m_sx     write setmSX;
      property  mSY     : real       read m_sy     write setmSY;
      property  mHP     : integer    read m_HP     write m_HP;
      property  mTile   : TRect      read m_Tile   write m_Tile;

   end;

   PObjects = ^TObjects;
   TObjects = object(TCharacter)

      constructor create(number : TTileInfo; x, y, HP : integer; vx, vy, ax, ay : real);
      function    CheckCrash : boolean;
      function    DoAction   : boolean;  virtual;

   private
      m_vx, m_vy : real;
      m_ax, m_ay : real;

   public
      property  mVX : real  read m_vx  write m_vx;
      property  mVY : real  read m_vy  write m_vy;
      property  mAX : real  read m_ax  write m_ax;
      property  mAY : real  read m_ay  write m_ay;

   end;

   PTransparency = ^TTransparency;
   TTransparency = object(TObjects)

      procedure   DisplaySelf; virtual;

   end;

   PMotionBlur = ^TMotionBlur;
   TMotionBlur = object(TObjects)

      procedure   DisplaySelf; virtual;
      function    DoAction : boolean;  virtual;

   end;

   PEnemy = ^TEnemy;
   TEnemy = object(TObjects)

      constructor create(number : TTileInfo; x, y, HP : integer);
      function    DoAction : boolean; virtual;

   end;

   PFriend = ^TFriend;
   TFriend = object(TObjects)

      constructor create(number : TTileInfo; x, y, HP : integer);
      procedure   DisplaySelf; virtual;
      function    DoAction : boolean; virtual;

   private
      FShapeCount : DWORD;
      FShapeDelay : DWORD;
      FShootDelay : integer;

   end;

const
   MAX_CHARACTER = 100;
var
   Objects     : array[1..MAX_CHARACTER] of PCharacter;
   flame_image : PDWORD;

implementation

uses
   MainUnt7;


function GetFreeObjects(var number : integer) : boolean;
var
   i : integer;
begin
   for i := 1 to MAX_CHARACTER do begin
       if objects[i] = nil then begin
          number := i;
          getFreeObjects := TRUE;
          exit;
       end;
   end;
   getFreeObjects := FALSE;
end;

procedure DisplayEffect(ColorInfo : TColorInfo; x, y : integer; var bitmap_data; ratio : integer);
var
   r, g, b       : word;
   _x, _y, x_len, y_len, x_len_half, y_len_half : word;
   data          : longint;
   pSour, pDest  : PDWORD;
   temp          : DWORD;
   tr1, tr2      : longint;
   tr3, division : word;
begin
   if (x < 0) or (y < 0) then exit;
   if addr(bitmap_data) = nil then exit;
   pSour := PDWORD(@bitmap_data);
   x_len := LoWord(pSour^);
   y_len := HiWord(pSour^);
   inc(pSour);
   x_len_half := x_len div 2;
   y_len_half := y_len div 2;

   if (x_len = 0) or (y_len = 0) then exit;

   if Basic.FPixelFormat = pfBGR then begin
      if ColorInfo = ciRed then ColorInfo := ciBlue
      else if ColorInfo = ciBlue then ColorInfo := ciRed;
   end;

   division := x_len * y_len div ratio div 2;
   for _y := 0 to pred(y_len) do begin
      with Basic.LockDesc do
         pDest := PDWORD(longint(lpSurface)+y*lPitch+x*BPP);
      for _x := 0 to pred(x_len) do begin
         data := pSour^; inc(pSour);
         if data <> longint($0) then begin
            temp   := pDest^;
            r      := Byte(temp shr 16);
            g      := Byte(temp shr  8);
            b      := Byte(temp);
            tr1    := (x_len_half - abs(integer(_x)- x_len_half));
            tr2    := (y_len_half - abs(integer(_y)- y_len_half));
            tr3    := (tr1 * tr2 div division) shl 2;
            case ColorInfo of
               ciRed   :
               begin
                  inc(r,DWORD($FF) * ratio div 64);
                  inc(g,tr3);
                  inc(b,tr3);
               end;
               ciGreen :
               begin
                  inc(r,tr3);
                  inc(g,DWORD($FF) * ratio div 64);
                  inc(b,tr3);
               end;
               ciBlue  :
               begin
                  inc(r,tr3);
                  inc(g,tr3);
                  inc(b,DWORD($FF) * ratio div 64);
               end;
            end;
            if r > $FF then r := $FF;
            if g > $FF then g := $FF;
            if b > $FF then b := $FF;
            data   := (temp and $FF000000) or (longint(r) shl 16) or (longint(g) shl 8) or longint(b);
            pDest^ := data;
         end;
         inc(longint(pDest),BPP);
      end;
      inc(y);
   end;
end;

(******************************************************************************)

constructor TCharacter.create(number : TTileInfo; x, y, HP : integer);
begin
   mNumber  := number;
   m_Tile   := TileInfo[number];
   m_x_size := TileInfo[number].Right-TileInfo[number].Left;
   m_y_size := TileInfo[number].Bottom-TileInfo[number].Top;
   mX       := x;
   mY       := y;
   mHP      := HP;
   m_sx     := x;
   m_sy     := y;
end;

destructor  TCharacter.destroy;
begin
end;

procedure   TCharacter.setmX(x : integer);
begin
   if (x >= 0) and (x + mXSize < MAX_X_LINE) then begin
      m_x  := x;
      m_sx := x;
   end;
end;

procedure   TCharacter.setmY(y : integer);
begin
   if (y >= 0) and (y + mYSize < MAX_Y_LINE) then begin
      m_y  := y;
      m_sy := y;
   end;
end;

procedure   TCharacter.setmSX(x : real);
begin
   if x < 0 then x := 0;
   if x >= MAX_X_LINE - mXSize then x := MAX_X_LINE - mXSize - 1;
   m_sx := x;
   m_x  := Trunc(x+0.5);
end;

procedure   TCharacter.setmSY(y : real);
begin
   if y < 0 then y := 0;
   if y >= MAX_Y_LINE - mYSize then y := MAX_Y_LINE - mYSize - 1;
   m_sy := y;
   m_y  := Trunc(y+0.5);
end;

procedure   TCharacter.DisplaySelf;
begin
   with Basic do repeat
   until MakeItSo(BackBuffer.BltFast(mX,mY,Image[1],mTile,DDBLTFAST_SRCCOLORKEY));
end;

function    TCharacter.DoAction;
begin
   DoAction := mHP > 0;
end;

(******************************************************************************)

constructor TObjects.create(number : TTileInfo; x, y, HP : integer; vx, vy, ax, ay : real);
begin
   inherited create(number,x,y,HP);
   mVX := vx;  mVY := vy;
   mAX := ax;  mAY := ay;
end;

function    TObjects.DoAction;
begin
   Result := inherited DoAction;
   if Result then Result := CheckCrash;

   if ((mX + mVX) < 0) or ((mX + mVX) >= MAX_X_LINE-mXSize) or
      ((mY + mVY) < 0) or ((mY + mVY) >= MAX_Y_LINE-mYSize) then begin
      Result := FALSE;
   end else begin
      mSX := mSX  + mVX;
      mSY := mSY  + mVY;
      mVX := mVX + mAX;
      mVY := mVY + mAY;
   end;
end;

function    TObjects.CheckCrash : boolean;

 function DetectCrash(dest : STileInfo) : boolean;
 var
    i      : integer;
    return : boolean;
 begin
    DetectCrash := TRUE;
    for i := 1 to MAX_CHARACTER do begin
       if Assigned(Objects[i]) then begin
          if Objects[i].mNumber in dest then begin
             return := ((Objects[i].mX <= mX) and (Objects[i].mX+Objects[i].mXSize > mX) and
                        (Objects[i].mY <= mY) and (Objects[i].mY+Objects[i].mYSize > mY)) or
                       ((Objects[i].mX <= mX+mXSize) and (Objects[i].mX+Objects[i].mXSize > mX+mXSize) and
                        (Objects[i].mY <= mY+mYSize) and (Objects[i].mY+Objects[i].mYSize > mY+mYSize));
             if return then begin
                DetectCrash := FALSE;
                Objects[i].mHP := Objects[i].mHP - mHP;
                exit;
             end;
          end;
       end;
    end;
 end;

begin
   CheckCrash := TRUE;
   if mNumber in [tiFireBall, tiFlame, tiEnergyBall] then begin
      case mNumber of
         tiFireBall, tiFlame : CheckCrash := DetectCrash([tiDemon]);
         tiEnergyBall        : CheckCrash := DetectCrash([tiNeTo1, tiNeTo2, tiFlame]);
      end;
   end;
end;

(******************************************************************************)

procedure   TTransparency.DisplaySelf;
begin
   Basic.LockBackGround;
   DisplayEffect(ciRed,mX,mY,flame_image^,mHP);
   mHP := mHP - 8;
   Basic.UnlockBackGround;
end;

(******************************************************************************)

procedure   TMotionBlur.DisplaySelf;
begin
   Basic.LockBackGround;
   DisplayEffect(ciBlue,mX,mY,flame_image^,mHP);
   mHP := mHP - 15;
   Basic.UnlockBackGround;
end;

function    TMotionBlur.DoAction : boolean;
var
   i : integer;
begin
   if (mHP <= 0) or (mX < 0) or (mX >= MAX_X_LINE-mXSize) or
                    (mY < 0) or (mY >= MAX_Y_LINE-mYSize) then begin
      DoAction := FALSE;
      exit;
   end;
   if CheckCrash then begin;
      if mHP = 100 then begin
         if ((mX + mVX) > 0) and ((mX + mVX) < MAX_X_LINE-mXSize) and
            ((mY + mVY) > 0) and ((mY + mVY) < MAX_Y_LINE-mYSize) then begin
            if GetFreeObjects(i) then begin
               Objects[i] := new(PMotionBlur,Create(tiFlame,Trunc(mSX+mVX+0.5),Trunc(mSY+mVY+0.5),100,mVX,mVY,0,0));
            end;
         end;
      end;
      DoAction := TRUE;
   end else begin
      DoAction := FALSE;
   end;

end;

(******************************************************************************)

constructor TEnemy.create(number : TTileInfo; x, y, HP : integer);
begin
   inherited create(number,x,y,HP,2,2,0,0);
end;

function    TEnemy.DoAction;
var
   i, x, y : integer;
   divide  : real;
begin
   DoAction := mHP > 0;

   mX := mX + (random(3)-1);
   mY := mY + (random(3)-1);

   if random(2) = 0 then begin
      if Assigned(Objects[1]) then begin
         x := Objects[1].mX+(Objects[1].mXSize div 2) - mX;
         y := Objects[1].mY+(Objects[1].mYSize div 2) - (mY+100);
         divide := sqrt(x*x+y*y) / 16;
         x := Trunc(x / divide + 0.5) + random(5) - 2;
         y := Trunc(y / divide + 0.5) + random(5) - 2;
         if GetFreeObjects(i) then begin
            Objects[i] := new(PObjects,Create(tiEnergyBall,mX,mY+100,50,x,y,random(3)-1,random(3)-1));
         end;
      end;
   end;
end;

(******************************************************************************)

constructor TFriend.create(number : TTileInfo; x, y, HP : integer);
begin
   inherited create(number,x,y,HP,2,2,0,0);
   FShapeCount := 0;
   FShapeDelay := GetTickCount;
   FShootDelay := 0;
end;

procedure   TFriend.DisplaySelf;
begin

   if abs(FShapeDelay - GetTickCount) > 50 then begin
      FShapeCount := FShapeCount xor 1;
      FShapeDelay := GetTickCount;
   end;

   with Basic do repeat
   until MakeItSo(BackBuffer.BltFast(mX,mY,Image[1],TileInfo[TTileInfo(ord(mNumber)+FShapeCount)],
                  DDBLTFAST_SRCCOLORKEY));
end;

function    TFriend.DoAction;
var
   i, j : integer;
begin
   DoAction := mHP > 0;
   if FShootDelay > 0 then dec(FShootDelay);

   if GetAsyncKeyState(VK_LEFT) <> 0 then mSX := mSX - mVX;
   if GetAsyncKeyState(VK_RIGHT)<> 0 then mSX := mSX + mVX;
   if GetAsyncKeyState(VK_UP)   <> 0 then mSY := mSY - mVY;
   if GetAsyncKeyState(VK_DOWN) <> 0 then mSY := mSY + mVY;

   if GetAsyncKeyState(VK_CONTROL) <> 0 then begin
      if GetFreeObjects(i) then begin
         Objects[i] := new(PObjects,Create(tiFireBall,mX+15,mY+30,20,16,0,0,0));
      end;
   end;

   if GetAsyncKeyState(VK_MENU) <> 0 then begin
      if GetFreeObjects(i) then begin
         Objects[i] := new(PTransparency,Create(tiFlame,mX+40,mY+25,100,16+random(10),random(9)-4,0,0));
      end;
   end;

   if GetAsyncKeyState(VK_SHIFT) <> 0 then begin
      if FShootDelay = 0 then begin
         for j := 1 to 5 do begin
            if GetFreeObjects(i) then begin
               Objects[i] := new(PMotionBlur,Create(tiFlame,mX+40,mY+25,100,16+random(10),random(9)-4,0,0));
            end;
         end;
         FShootDelay := 10;
      end;
   end;
end;

(******************************************************************************)

var
   i : integer;
begin
   for i := 1 to MAX_CHARACTER do begin
      Objects[i] := nil;
   end;
end.
