#include<dos.h>

#define _ESC    0x01
#define _1      0x02
#define _2      0x03
#define _3      0x04
#define _4      0x05
#define _5      0x06
#define _6      0x07
#define _7      0x08
#define _8      0x09
#define _9      0x0A
#define _0      0x0B
#define _A      0x1E
#define _S      0x1F
#define _D      0x20
#define _F      0x21
#define _G      0x22
#define _H      0x23
#define _J      0x24
#define _K      0x25
#define _L      0x26
#define _Q      0x10
#define _W      0x11
#define _E      0x12
#define _R      0x13
#define _T      0x14
#define _Y      0x15
#define _U      0x16
#define _I      0x17
#define _O      0x18
#define _P      0x19
#define _Z      0x2C
#define _X      0x2D
#define _C      0x2E
#define _V      0x2F
#define _B      0x30
#define _N      0x31
#define _M      0x32
#define _MINUS  0x0C
#define _EQUAL  0x0D
#define _BACKSP 0x0E
#define _SEMI   0x27
#define _QUATO  0x28
#define _RSLASH 0x2B
#define _COMMA  0x33
#define _DOT    0x34
#define _SLASH  0x35

#define _F1  	0x3B
#define _F2  	0x3C
#define _F3  	0x3D
#define _F4  	0x3E
#define _F5  	0x3F
#define _F6  	0x40
#define _F7  	0x41
#define _F8  	0x42
#define _F9  	0x43
#define _F10 	0x44
#define _F11	0xD9
#define _F12    0xDA

#define _SHR 	0x2A
#define _SHL 	0x36
#define _CTRL	0x1D
#define _ALT	0x38

#define _UPKEY 	0x48
#define _LTKEY 	0x4B
#define _RTKEY	0x4D
#define _DNKEY 	0x50

#define _TAB    0x0F
#define _HOME 	0x47
#define _PGUP 	0x49
#define _END  	0x4F
#define _PGDN 	0x51
#define _INS  	0x52
#define _DEL  	0x53
#define _NUM	0x45
#define _CAP	0x3A
#define _SCR	0x46
#define _SPACE  0x39
#define _ENTER  0x1C

unsigned char Key[128];
unsigned char Key_[128];
void interrupt(*Org_9)(...);

#define KbData 60h
#define KbCtrl 61h
#define IntCtrl 20h
#define RELEASE 80h
#define EOI	20h

void KbReset()
{asm in al,KbCtrl;
 asm mov ah,al;
 asm or al,RELEASE;
 asm out KbCtrl,al;
 asm mov al,ah;
 asm out KbCtrl,al;
 }

void Keyclear()
{ int i;
  for(i=0;i<128;i++)
	if (Key_[i])Key[i]=0;
  }

void interrupt KeyFunc(...)
 {register  po;
  asm cli;
  asm in al,KbData;
  asm xor ah,al;
  po=_AX;
  if(po>127)
	Key_[po-128]=1;
  else {
	Key_[po]=0;
	Key[po]=1;
  }
  KbReset();
  asm sti;
  asm mov al,EOI;
  asm out IntCtrl,al;
}

void SetNewInt_9()
{
 int i;
 for(i=0;i<128;i++){
	Key[i]=0;
	Key_[i]=0;
	}
 Org_9=getvect(9);
 setvect(9,KeyFunc);
}

void SetOrgInt_9()
{
	setvect(9,Org_9);
}

void SYSTEM()
{
	SetNewInt_9();
}

void SYSTEM_OFF()
{
	SetOrgInt_9();
}
