//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDX Class Library - CDX.lib ]
// Source File:  [ CDXSound Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.5 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDX.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXSound Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXSound::CDXSound()
{
	m_lpDS = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSound Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXSound::~CDXSound()
{
	if(m_lpDS) m_lpDS->Release();
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSound Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSound::Create(void *hWnd)
{
	HRESULT rval;

	rval = DirectSoundCreate(NULL, &m_lpDS, NULL);
	if(rval != DS_OK) DSError(rval, hWnd);

	rval = m_lpDS->SetCooperativeLevel(hWnd, DSSCL_NORMAL);
	if(rval != DS_OK) DSError(rval, hWnd);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXSound GetCaps
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSound::GetCaps(void)
{
	HRESULT rval;

	rval = m_lpDS->GetCaps(&m_DSCaps);
	if(rval != DS_OK) return FALSE;

	return TRUE;
}
