//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDXRM Class Library - CDXRM.lib ]
// Source File:  [ CDXRMCamera Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.0 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDXRM.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXRMCamera Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMCamera::CDXRMCamera(CDXRMEngine* pEngine)
{
	m_Engine = pEngine;
	m_Frame = NULL;
	m_View = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMCamera Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMCamera::~CDXRMCamera(void)
{
	RELEASE(m_View);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMCamera Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMCamera::Create(CDXRMScene* pScene)
{
	m_Engine->CreateFrame(pScene->m_Frame, &m_Frame);
	m_Frame->SetPosition(pScene->m_Frame, D3DVAL(0.0), D3DVAL(0.0), D3DVAL(-10.0));

	m_Engine->m_D3DRM->CreateViewport(m_Engine->m_Device, m_Frame, 0, 0,
																		m_Engine->m_Screen->m_dwPixelWidth,
																		m_Engine->m_Screen->m_dwPixelHeight, &m_View);

	m_View->SetBack(D3DVAL(5000.0));

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMCamera Clear
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXRMCamera::Clear(void)
{
	return m_View->Clear();
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMCamera Render
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXRMCamera::Render(CDXRMScene* pScene)
{
	return m_View->Render(pScene->m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMCamera ForceUpdate
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXRMCamera::ForceUpdate(DWORD X1, DWORD Y1, DWORD X2, DWORD Y2)
{
	return m_View->ForceUpdate(X1, Y1, X2, Y2);
}
