//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDXRM Class Library - CDXRM.lib ]
// Source File:  [ CDXRMFrame Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.0 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDXRM.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMFrame::CDXRMFrame(void)
{
	m_Frame = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMFrame::CDXRMFrame(CDXRMEngine* pEngine)
{
	m_Frame = NULL;
	m_Engine = pEngine;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMFrame::~CDXRMFrame(void)
{
	RELEASE(m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMFrame::Create(CDXRMFrame* Parent)
{
	return m_Engine->CreateFrame(GetRef(Parent), &m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame AddChild
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::AddChild(CDXRMFrame* pChild)
{
	m_Frame->AddChild(pChild->m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame AddLight
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::AddLight(CDXRMLight* pLight)
{
	m_Frame->AddLight(pLight->m_Light);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame GetRef
//////////////////////////////////////////////////////////////////////////////////
LPDIRECT3DRMFRAME CDXRMFrame::GetRef(CDXRMFrame* pRef)
{
	if(pRef) return pRef->m_Frame;
	else
	{
		if(!m_Frame) return NULL;

		LPDIRECT3DRMFRAME pParent = NULL;
		m_Frame->GetParent(&pParent);

		return pParent;
	}
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame Move
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXRMFrame::Move(double delta)
{
	return m_Frame->Move(delta);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame SetDirection
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::SetDirection(double dx, double dy, double dz,
															double ux, double uy, double uz, CDXRMFrame* pRef)
{
	m_Frame->SetOrientation(GetRef(pRef), D3DVAL(dx), D3DVAL(dy), D3DVAL(dz),
																				D3DVAL(ux), D3DVAL(uy), D3DVAL(uz));
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame SetDirection
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::GetDirection(double &dx, double &dy, double &dz,
															double &ux, double &uy, double &uz, CDXRMFrame* pRef)
{
	D3DVECTOR dir;
	D3DVECTOR up;

	m_Frame->GetOrientation(GetRef(pRef), &dir, &up);

	dx = dir.x;
	dy = dir.y;
	dz = dir.z;
	ux = up.x;
	uy = up.y;
	uz = up.z;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame SetPosition
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::SetPosition(double x, double y, double z, CDXRMFrame* pRef)
{
	m_Frame->SetPosition(GetRef(pRef), D3DVAL(x), D3DVAL(y), D3DVAL(z));
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame GetPosition
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::GetPosition(double &x, double &y, double &z, CDXRMFrame* pRef)
{
	D3DVECTOR v;

	m_Frame->GetPosition(GetRef(pRef), &v);

	x = v.x;
	y = v.y;
	z = v.z;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame SetRotation
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::SetRotation(double x, double y, double z, double t, CDXRMFrame* pRef)
{
	m_Frame->SetRotation(GetRef(pRef), D3DVAL(x), D3DVAL(y), D3DVAL(z), D3DVAL(t));
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame GetRotation
//////////////////////////////////////////////////////////////////////////////////
void CDXRMFrame::GetRotation(double &x, double &y, double &z, float t, CDXRMFrame* pRef)
{
	D3DVECTOR v;

	m_Frame->GetRotation(GetRef(pRef), &v, &t);

	x = v.x;
	y = v.y;
	z = v.z;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame AddTransform
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXRMFrame::AddTransform(CDXRMMatrix& m, D3DRMCOMBINETYPE ct)
{
  D3DRMMATRIX4D rlm;
	m.Create(rlm);
	return m_Frame->AddTransform(ct, rlm);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMFrame AddRotation
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXRMFrame::AddRotation(double x, double y, double z, double t, D3DRMCOMBINETYPE ct)
{
	return m_Frame->AddRotation(ct, D3DVAL(x), D3DVAL(y), D3DVAL(z), D3DVAL(t));
}
