//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDXRM Class Library - CDXRM.lib ]
// Source File:  [ CDXRMLight Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.0 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDXRM.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMLight::CDXRMLight(CDXRMEngine* pEngine)
{
	m_Light = NULL;
	m_Engine = pEngine;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMLight::~CDXRMLight(void)
{
	RELEASE(m_Light);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMLight::Create(D3DRMLIGHTTYPE type, double r, double g, double b)
{
	HRESULT rval;

	m_Engine->CreateFrame(NULL, &m_Frame);

	m_Engine->CreateLight(type, r, g, b, &m_Light);

	rval = m_Frame->AddLight(m_Light);
	if(rval != D3DRM_OK) return FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight CreateAmbient
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMLight::CreateAmbient(double r, double g, double b)
{
	return Create(D3DRMLIGHT_AMBIENT, r, g, b);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight CreateDirectional
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMLight::CreateDirectional(double r, double g, double b)
{
	return Create(D3DRMLIGHT_DIRECTIONAL, r, g, b);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight CreatePoint
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMLight::CreatePoint(double r, double g, double b)
{
	return Create(D3DRMLIGHT_POINT, r, g, b);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight CreateParallelPoint
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMLight::CreateParallelPoint(double r, double g, double b)
{
	return Create(D3DRMLIGHT_PARALLELPOINT, r, g, b);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight CreateSpotlight
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMLight::CreateSpot(double r, double g, double b)
{
	return Create(D3DRMLIGHT_SPOT, r, g, b);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMLight SetColor
//////////////////////////////////////////////////////////////////////////////////
void CDXRMLight::SetColor(double r, double g, double b)
{
	m_Light->SetColorRGB(r, g, b);
}
