//////////////////////////////////////////////////////////////////////////////////
// Project Name: [ CDXRM Class Library - CDXRM.lib ]
// Source File:  [ CDXRMScene Implementation ]
// Author:       [ Danny Farley - danny@jags.co.uk ]
// Revision:     [ 1.0 ]
//////////////////////////////////////////////////////////////////////////////////
#include "CDXRM.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXRMScene Constructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMScene::CDXRMScene(CDXRMEngine* pEngine)
{
	m_Engine = pEngine;
	m_Light = NULL;
	m_Frame = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMScene Destructor
//////////////////////////////////////////////////////////////////////////////////
CDXRMScene::~CDXRMScene(void)
{
	RELEASE(m_Light);
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMScene Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXRMScene::Create(void)
{
	m_Engine->CreateFrame(NULL, &m_Frame);

	m_Engine->m_D3DRM->CreateLightRGB(D3DRMLIGHT_AMBIENT, D3DVAL(0.3), D3DVAL(0.3), D3DVAL(0.3), &m_Light);
	m_Frame->AddLight(m_Light);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CDXRMScene SetAmbientLight
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXRMScene::SetAmbientLight(double r, double g, double b)
{
	return m_Light->SetColorRGB(r, g, b);
}
