/////////////////////////////////////////////////////////////////////////////////////////////
// CDX example 4 - Fullscreen scrolling & keyboard input
// You must link to cdx.lib, ddraw.lib, dinput and dxguid
/////////////////////////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <CDX.h>

CDXScreen* Screen;  // The screen object, every program must have one
CDXTile* Tiles;     // The background tiles
CDXMap* Map;        // The scrolling map object
CDXInput Input;     // The input object

BOOL bActive = TRUE;  // Is the program running?
char Bitmap[] = "TILES";
RECT Window = { 0, 0, 640, 480 };

/////////////////////////////////////////////////////////////////////////////////////////////
// FiniApp - Destroy the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
void FiniApp(void)
{
	delete Map;
	delete Tiles;
	delete Screen;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinProc
/////////////////////////////////////////////////////////////////////////////////////////////
long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_ACTIVATEAPP:
      bActive = wParam;
			break;

		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_ESCAPE:
					PostMessage(hWnd, WM_CLOSE, 0, 0);
				break;
			}
		break;

		case WM_DESTROY:
			PostQuitMessage(0);
		break;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////////////////////
// InitApp - Create the window and the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass;

	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(0, IDI_APPLICATION);
	WndClass.hCursor = LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground = GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName = 0;
	WndClass.lpszClassName = "Example 4";
	RegisterClass(&WndClass);

	hWnd = CreateWindowEx(
		WS_EX_TOPMOST,
		"Example 4",
		"Example 4",
		WS_POPUP,
		0,0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN),
		NULL,
		NULL,
		hInst,
		NULL);

	if(!hWnd) return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// Create the CDXSreen object
	Screen = new CDXScreen();
	Screen->CreateFullScreen(hWnd, 640, 480, 16);

	// Load the tiles
	Tiles = new CDXTile(Screen, Bitmap, 64, 64, 1);

	// Create and load the map
	Map = new CDXMap(Tiles, Screen);
	Map->Create(64, 64, 1);
	Map->MoveTo(0,0);

	// Create input devices
	if(!Input.Create(hInst, hWnd));

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinMain
/////////////////////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	if(!InitApp(hInst, nCmdShow)) return FALSE;

	while(1)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if(bActive)
		{
			Input.Update();  // Refresh the input devices

			if(Input.Joystick.y < 0 | Input.Keys[DIK_UP]) Map->WrapScrollUp(1);
			if(Input.Joystick.y > 0 | Input.Keys[DIK_DOWN]) Map->WrapScrollDown(1);
			if(Input.Joystick.x < 0 | Input.Keys[DIK_LEFT]) Map->WrapScrollLeft(1);
			if(Input.Joystick.x > 0 | Input.Keys[DIK_RIGHT]) Map->WrapScrollRight(1);

			Map->DrawClipped(Screen->GetBack(), &Window);  // Draw the map to the back buffer
			Screen->Flip();  // Then display it
		}
		else WaitMessage();
	}
}
