/////////////////////////////////////////////////////////////////////////////////////////////
// CDX example 3 - Windowed scrolling
// You must link to cdx.lib, ddraw.lib and dxguid.lib
/////////////////////////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <CDX.h>

CDXScreen* Screen;  // The screen object, every program must have one
CDXTile* Tiles;     // The background tiles
CDXMap* Map;        // The scrolling map object

BOOL bActive = TRUE;  // Is the program running?

/////////////////////////////////////////////////////////////////////////////////////////////
// WinProc
/////////////////////////////////////////////////////////////////////////////////////////////
long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_ACTIVATEAPP:
      bActive = wParam;
			break;

		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_ESCAPE:
					PostMessage(hWnd, WM_CLOSE, 0, 0);
				break;
			}
		break;

		case WM_DESTROY:
			PostQuitMessage(0);
		break;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////////////////////
// InitApp - Create the window and the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass;

	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(0, IDI_APPLICATION);
	WndClass.hCursor = LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground = GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName = 0;
	WndClass.lpszClassName = "Example 3";
	RegisterClass(&WndClass);

	hWnd = CreateWindowEx(
		WS_EX_WINDOWEDGE,
		"Example 3",
		"Example 3",
		WS_VISIBLE|WS_SYSMENU,
		0,0,
		448,
		320,
		NULL,
		NULL,
		hInst,
		NULL);
	if(!hWnd) return FALSE;

	RECT rc;
	DWORD dwStyle;

	dwStyle = GetWindowStyle(hWnd);
	dwStyle &= ~WS_POPUP;
	dwStyle |= WS_OVERLAPPED | WS_CAPTION | WS_THICKFRAME | WS_MINIMIZEBOX;
	SetWindowLong(hWnd, GWL_STYLE, dwStyle);

	SetRect(&rc, 0, 0, 448, 320);

	AdjustWindowRectEx(&rc,
		GetWindowStyle(hWnd),
		GetMenu(hWnd) != NULL,
		GetWindowExStyle(hWnd));

	SetWindowPos(hWnd, NULL, 0, 0, rc.right-rc.left, rc.bottom-rc.top,
		SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);

	SetWindowPos(hWnd, HWND_NOTOPMOST, 0, 0, 0, 0,
		SWP_NOSIZE | SWP_NOMOVE | SWP_NOACTIVATE);

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// Create the CDXSreen object
	Screen = new CDXScreen();
	Screen->CreateWindowed(hWnd, 448, 320);

	// Load the tiles
	Tiles = new CDXTile(Screen, "TILES.BMP", 64, 64, 1);

	// Create and load the map
	Map = new CDXMap(Tiles, Screen);
	Map->Create(64, 64, 1);
	Map->MoveTo(0,0);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinMain
/////////////////////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	if(!InitApp(hInst, nCmdShow)) return FALSE;

	while(1)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if(bActive)
		{
			if(GetAsyncKeyState(VK_UP)) Map->WrapScrollUp(2);
			if(GetAsyncKeyState(VK_DOWN)) Map->WrapScrollDown(2);
			if(GetAsyncKeyState(VK_LEFT))	Map->WrapScrollLeft(2);
			if(GetAsyncKeyState(VK_RIGHT)) Map->WrapScrollRight(2);

			Map->Draw(Screen->GetBack());  // Draw the map to the back buffer
			Screen->Flip();  // Then display it
		}
		else WaitMessage();
	}
}
