/////////////////////////////////////////////////////////////////////////////////////////////
// CDX example 1 - Fullscreen applications
// You must link to cdx.lib, ddraw.lib and dxguid.lib
/////////////////////////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <CDX.h>

CDXScreen* Screen;	// The CDXScreen object, every program must have one
int Toggle = 0;			// Toggle the fill colour

/////////////////////////////////////////////////////////////////////////////////////////////
// FiniApp - Destroy the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
void FiniApp(void)
{
	delete Screen;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinProc
/////////////////////////////////////////////////////////////////////////////////////////////
long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_TIMER:
		{
			if(Toggle)
			{
				Screen->Fill(4);	// Fill the back buffer red
				Toggle = 0;
			}
			else
			{
				Screen->Fill(1);	// Fill the back buffer blue
				Toggle = 1;
			}

			Screen->Flip();	 // Flip the back buffer to the front
		}
		break;

		case WM_SETCURSOR:
			SetCursor(NULL);	// Hide the mouse cursor
		return TRUE;

		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_ESCAPE:
					PostMessage(hWnd, WM_CLOSE, 0, 0);
				break;
			}
		break;

		case WM_DESTROY:
			FiniApp();
			PostQuitMessage(0);
		break;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}

/////////////////////////////////////////////////////////////////////////////////////////////
// InitApp - Create the window and the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass;

	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(hInst, IDI_APPLICATION);
	WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	WndClass.hbrBackground = NULL;
	WndClass.lpszMenuName = "Example 1";
	WndClass.lpszClassName = "Example 1";
	RegisterClass(&WndClass);

	hWnd = CreateWindowEx(
		WS_EX_TOPMOST,
		"Example 1",
		"Example 1",
		WS_POPUP,
		0,0,
		GetSystemMetrics(SM_CXSCREEN),
		GetSystemMetrics(SM_CYSCREEN),
		NULL,
		NULL,
		hInst,
		NULL);

	if(!hWnd) return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// Create the CDXSreen object and set the resoultion
	Screen = new CDXScreen();
	Screen->CreateFullScreen(hWnd, 640, 480, 8);

	// Setup a timer for the screen flip
	SetTimer(hWnd, 1, 500, NULL);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinMain
/////////////////////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	if(!InitApp(hInst, nCmdShow)) return FALSE;

	while(1)
	{
		if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if(!GetMessage(&msg, NULL, 0, 0 )) return msg.wParam;
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else WaitMessage();
	}
}
