/////////////////////////////////////////////////////////////////////////////////////////////
// CDX example 2 - Windowed applications
// You must link to cdx.lib, ddraw.lib and dxguid.lib
/////////////////////////////////////////////////////////////////////////////////////////////
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <CDX.h>

CDXScreen* Screen;	// The CDXScreen object, every program must have one
int Toggle = 0;			// Toggle the fill colour

/////////////////////////////////////////////////////////////////////////////////////////////
// WinProc
/////////////////////////////////////////////////////////////////////////////////////////////
long PASCAL WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
		case WM_TIMER:
		{
			if(Toggle)
			{
				Screen->Fill(0);	// Fill the back buffer black
				Toggle = 0;
			}
			else
			{
				Screen->Fill(255);	// Fill the back buffer blue
				Toggle = 1;
			}

			Screen->Flip();	 // Flip the back buffer to the front
		}
		return 0;

		case WM_KEYDOWN:
			switch(wParam)
			{
				case VK_ESCAPE:
					PostMessage(hWnd, WM_CLOSE, 0, 0);
				return 0;
			}
		return 0;

		case WM_DESTROY:
			PostQuitMessage(0);
		return 0;

		default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////
// InitApp - Create the window and the CDX objects
/////////////////////////////////////////////////////////////////////////////////////////////
BOOL InitApp(HINSTANCE hInst, int nCmdShow)
{
	HWND hWnd;
	WNDCLASS WndClass;

	WndClass.style = CS_HREDRAW | CS_VREDRAW;
	WndClass.lpfnWndProc = WinProc;
	WndClass.cbClsExtra = 0;
	WndClass.cbWndExtra = 0;
	WndClass.hInstance = hInst;
	WndClass.hIcon = LoadIcon(0, IDI_APPLICATION);
	WndClass.hCursor = LoadCursor(0, IDC_ARROW);
	WndClass.hbrBackground = GetStockObject(BLACK_BRUSH);
	WndClass.lpszMenuName = 0;
	WndClass.lpszClassName = "Example 2";
	RegisterClass(&WndClass);

	hWnd = CreateWindow(
		"Example 2",
		"Example 2",
 		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		NULL,
		hInst,
		NULL);

	if(!hWnd) return FALSE;

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	// Create the CDXSreen object
	Screen = new CDXScreen();
	Screen->CreateWindowed(hWnd, 320, 200);

	// Setup a timer for the screen flip
	SetTimer(hWnd, 1, 500, NULL);

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// WinMain
/////////////////////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	if(!InitApp(hInst, nCmdShow)) return FALSE;

	while(GetMessage(&msg, 0, 0, 0) == TRUE)
	{
		TranslateMessage(&msg); 
		DispatchMessage(&msg);
	}

	return msg.wParam;
}
