/**************************************************************************
  main.cpp

  Description:
    Sample code to use ReadASE.cpp and write out into a new, simpler file
    format (SMF = Simple Model Format)

  --------- Copyright (c) 1998 Daniel Dunham | crow@tconl.com ---------

**************************************************************************/

// ################################################### Includes
#include <stdio.h>    // for FILE
#include <stdlib.h>   // for free()
#include "Generic3d.h"
#include "ReadASE.h"

bool OutputSMF(char *filename,GenObject3d *obj)
{
  FILE *out;

    // Open output file
    out = NULL;
    out = fopen(filename,"wb");

    if(out == NULL) // If file could not be opened
      return false;

    // Write header comment
    fprintf(out,"; -- Simple Model Format v1.5 [.SMF] --\n");
    fprintf(out,";\n");

    // Write Object information
    fprintf(out,"; [# of Vertices] [# of Faces]\n");
    fprintf(out,"%d %d\n",obj->NumVertices,obj->NumFaces);

    // Write Vertex List
    fprintf(out,"; Vertex List [X Y Z]\n");
    for(int i=0;i<obj->NumVertices;i++) {
      fprintf(out,"%f %f %f\n",obj->VertexList[i].x,obj->VertexList[i].y,
        obj->VertexList[i].z);
    }

    // Write Face List
    fprintf(out,"; Does face section contain normal information?\n");
    fprintf(out,"1\n");
    fprintf(out,"; Does face section contain texture coordinates?\n");
    fprintf(out,"1\n");
    fprintf(out,"; Face List [Pt1 S1 T1 Pt2 S2 T2 Pt3 S3 T3 N1 N2 N3]\n");
    for(i=0;i<obj->NumFaces;i++) {
      fprintf(out,"%d %f %f %d %f %f %d %f %f %d %d %d\n",
          obj->FaceList[i].f1,obj->FaceList[i].s1,obj->FaceList[i].t1,
          obj->FaceList[i].f2,obj->FaceList[i].s2,obj->FaceList[i].t2,
          obj->FaceList[i].f3,obj->FaceList[i].s3,obj->FaceList[i].t3,
          obj->FaceList[i].n1,obj->FaceList[i].n2,obj->FaceList[i].n3);
    }

    // Write final line
    fprintf(out,"; End of .SMF Simple Model Format");

    // Close file
    fclose(out);

    printf(".SMF File Format Write Complete\n");
    return true;
}

int main(int argc,char *args[])
{
  GenObject3d obj;

    printf("%s v%d.%d | Original Code Copyright (c) 1998 Daniel Dunham\n",
            ID_RA_NAME,ID_RA_MAJORVERSION,ID_RA_MINORVERSION);
  
    // If we have improper # of arguments
    if( (argc < 3) || (argc > 4)) { 
      printf("Usage: readase [infile.ase] [outfile.smf]\n"); // Output usage information
      return 0;
    }

    if(ReadASE(args[1],&obj) == 0) {
      printf("** Could not read %s **\n",args[1]);
      return (-1);
    }

    if(OutputSMF(args[2],&obj) == 0) {
      printf("** Could not write %s **\n",args[2]);
      return (-1);
    }

    free(obj.FaceList);
    free(obj.VertexList);

    printf("%s successfully converted to %s\n",args[1],args[2]);
    return 0;
}

