/**************************************************************************
  ReadASE.h

  Description:
    Interface file for ReadASE.cpp, for reading 3D Studio ASCII Export

  Types Declared:
    Point3d    Vertex information
    Face3d     Face (triangle) information  
    Object3d   Complete mesh information

  --------- Copyright (c) 1998 Daniel Dunham | crow@tconl.com ---------
  | This source may not be distributed except by the copyright holder |
  ---------------------------------------------------------------------

**************************************************************************/

#ifndef READASE_H
#define READASE_H

#include "Generic3d.h"

// ################################################### Defines
// Version information
#define ID_RA_NAME "ReadASE"
#define ID_RA_MAJORVERSION 1
#define ID_RA_MINORVERSION 5

// Debugging options
#define READASE_PRINTINFO   1
#define READASE_PRINTSTATUS 1

// ################################################### Function Prototypes
bool ReadASE(char *filename,GenObject3d *obj);

#endif // #ifndef READASE_H