// +----------------------------------------------------------------------+
// | NUKE 2 Simple QuickStart Template  (C)1998 Odin Jensen/NUKE Software |
// +----------------------------------------------------------------------+
// | Template Part : Main source + all init/destroy parts                 |
// +----------------------------------------------------------------------+

// Include files here. 

#include <windows.h>
#include <windowsx.h>
#include <nuke2.h> // Include NUKE2 header
#include "project\\resource.h"

// Global variables

HWND hwnd;              // Window handle. Easier as global.
HINSTANCE hInst;        // The same here.
BOOL NotPaused=TRUE;    // Used to pause game when user changes app. Remove this in netplay
                        // so users who change app. wont pause the entire game.

char GameName[]="Nuke2 Demo. Try ALT+ENTER :)"; // Name of your game.

// Function prototypes.

// !!!! TUTORIAL OBJECTS HERE !!!!

// Number of balls
#define MAXBALLS 3

// Number of stars
#define NUMSTARS 60

// Ball speed
#define SPEED 2

// Width and height of window/full screen
#define Width 640
#define Height 480

// Screen object
N2_Screen *Screen; // Requires. DDRAW.LIB, DXGUID.LIB

// Music object
N2_MIDI *Mus; // Requires WINMM.LIB

// N_2Surfaces for :
N2_Surface *Ball, *Star, * Logo;

// N2 WAD File
N2_File * WAD;

// Frame count object
N2_FPS  FPS;

// Ball X,Y start coords
int X[MAXBALLS]={0,500,100};
int Y[MAXBALLS]={0,300,400};

// Scroll position
int ScrollX=640;

// Ball X,Y start offsets
int XOffs[MAXBALLS]={0,-2,-2};
int YOffs[MAXBALLS]={0,-2,-2};


// Star x,y coords
POINT star[NUMSTARS];

// Are we in windowed mode?
BOOL window;
 
// !!!! TUTORIAL OBJECTS HERE !!!!

// Windows main entry point and game loop launcher.
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow);

// Windows message loop. Only used for initialization, quit key and de-initializiation
LRESULT CALLBACK WndProc(HWND hwnd,UINT Message, WPARAM wParam,LPARAM lParam);

// This is called during IDLE time for maximum game perfomance!
void Update_Game(); 

// Called on window initialization. All your setup code goes here.
BOOL Init_Game();

// Called when window is destroyed. All de-allocation goes here.
void Destroy_Phase(HWND hwnd);

// Implementation

// +--------------------------------------------------+
// | Windows main entry point and game loop launcher. |
// +--------------------------------------------------+

int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
 MSG msg;     // Message structure
 WNDCLASS wc; // Window class
 // Create window and register it.
 wc.style=CS_HREDRAW|CS_VREDRAW;
 wc.lpfnWndProc=WndProc;
 wc.cbClsExtra=0;
 wc.cbWndExtra=0;
 wc.hInstance=hInst;
 // Possibility of loading own icon and cursor.
 // Replace NULL with hInst and IDI_? with MAKEINTRESOURCE(Name of your icon. I.e IDI_MYICON)
 wc.hIcon=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON1));
 wc.hCursor=LoadCursor(NULL,IDC_ARROW);
 wc.hbrBackground=GetStockObject(BLACK_BRUSH);
 wc.lpszMenuName=NULL;
 wc.lpszClassName=GameName;
 // Can we register? Else abort appliciation.
 if (RegisterClass(&wc)==0) return FALSE;
 // Now, try to create window
 hwnd=CreateWindow(GameName,GameName,WS_POPUP,GetSystemMetrics(SM_CXSCREEN)/2-Width/2,GetSystemMetrics(SM_CYSCREEN)/2-Height/2,Width,Height,NULL,NULL,hInst,NULL);
 // If failed, abort!
 if (hwnd==NULL) return FALSE;
 // Now show and update window. Before init window. It sucks!!! 
 ShowWindow(hwnd,nCmdShow);
 UpdateWindow(hwnd);
	
 // Init game
 if (!Init_Game()) return FALSE;
 // And finally. Hide the cursor. We usually make our own. 
 ShowCursor(FALSE);
 // Loop for eternity (or quit)
 while( 1 )
  {
   if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
    {
     if(!GetMessage( &msg, NULL, 0, 0 ))
      return msg.wParam;
     TranslateMessage(&msg); 
     DispatchMessage(&msg);
    }
  else
   Update_Game();
   }
}

// Handler to force window to size when switching from fullscreen

void OnMinMax(HWND hwnd, MINMAXINFO FAR* lpMinMaxInfo)
{
  lpMinMaxInfo->ptMaxSize.x=Width;
  lpMinMaxInfo->ptMaxSize.y=Height;
  lpMinMaxInfo->ptMaxPosition.x=320;
  lpMinMaxInfo->ptMaxPosition.y=240;
  lpMinMaxInfo->ptMinTrackSize.x=Width;
  lpMinMaxInfo->ptMinTrackSize.y=Height;
  lpMinMaxInfo->ptMaxTrackSize.x=Width;
  lpMinMaxInfo->ptMaxTrackSize.y=Height;
}

// Called to init screen and graphics upon mode change

void RenderInit()
{
 // Temp error value
 N2_ERR error;
 
 // Erase and recreate screen object if not firsttime
 if (Screen!=NULL)
 {
 delete Screen;
 Screen=new N2_Screen();
 }
 
 // Are we in window
 if (window)
 {	   
 
  // Try to create fullscreen	 
  error=Screen->CreateFull(hwnd,Width,Height,N2_BitDepth,TRUE);
 
 // Bail out if failed
 if (error!=N2_SUCCESS)
 {
  MessageBox(hwnd,N2_Err2Str(error),"Error!",MB_OK);
  PostQuitMessage(0);
 } 
 
 // Not in a window anymore
 window=FALSE; 
 }
 else
 {
 
 // Try to create windowed
 error=Screen->CreateWindowed(hwnd,Width,Height);			   
 
 // Bail out if failed
 if (error!=N2_SUCCESS)
 {
  MessageBox(hwnd,N2_Err2Str(error),"Error!",MB_OK);
  PostQuitMessage(0);
 }
 
  // Yes we are in a window now
  window=TRUE;
  
  // Center window
  SetWindowPos(hwnd,0,GetSystemMetrics(SM_CXSCREEN)/2-Width/2,GetSystemMetrics(SM_CYSCREEN)/2-Height/2,Width,Height,0); 
 }

 // Create GFX objects again  
 Ball->Load(WAD->Seek("ball.bmp")); 
 Ball->Create(N2_SYSMEM);
 Ball->ColorKey(0);
 Ball->Data2Surface(0,0);
 Star->Load(WAD->Seek("star.bmp"));
 Star->Create(N2_SYSMEM);
 Star->ColorKey(0);
 Star->Data2Surface(0,0); 
 Logo->Load(WAD->Seek("logo.bmp"));
 Logo->Create(N2_SYSMEM);
 Logo->ColorKey(0);
 Logo->Data2Surface(0,0); 

}
// +------------------------------------------------------------------+
// | Windows message loop. Normal windows key messages are sent here! |
// +------------------------------------------------------------------+

LRESULT CALLBACK WndProc(HWND hwnd,UINT Message, WPARAM wParam,LPARAM lParam)
{
 switch(Message)
  {
   // Handle create/destroy
   HANDLE_MSG(hwnd,WM_DESTROY,Destroy_Phase);
   HANDLE_MSG(hwnd,WM_GETMINMAXINFO,OnMinMax);

   // If MIDI playStar stopped 
 case MM_MCINOTIFY:
	 // Restart MIDI music here if you want repeated music
	 Mus->Play();
	 break;
   // If user switches app. Pause game. 
   case WM_ACTIVATEAPP:
        NotPaused = wParam;
        break;   
   // Check for keypress
   case WM_SYSKEYUP:
	   switch(wParam)
	   {
	   case VK_RETURN:
		   {
		    RenderInit();
		   }

	   }break;
   case WM_KEYDOWN:
    switch(wParam)
     {
       case VK_ESCAPE: // Quit game key
       PostMessage(hwnd, WM_CLOSE, 0, 0);
      break; 
      }
   break;
  }
 // If not a message we want to handle, pass it along to the default handler
 return DefWindowProc(hwnd, Message, wParam, lParam);

}

// +------------------------------------------------------------------+
// | Called on program initialization. All your setup code goes here. |
// +------------------------------------------------------------------+

BOOL Init_Game()
{
 // Temp error value
 N2_ERR err;
 
 // Create screen
 Screen=new N2_Screen();
 
 // Create music object
 Mus=new N2_MIDI();
 
 // Trick RenderInit() to create windowed mode
 window=FALSE;
 
 // Setup music object
 Mus->Create(hwnd);
 
 // Create WAD file
 WAD=new N2_File();
 
 // Open WAD file
 err=WAD->Open("Tutor1.WAD");
 if (err!=N2_SUCCESS) 
 {
  MessageBox(hwnd,N2_Err2Str(err),"Error!",MB_OK);
  return FALSE;
 }
 
 // Load music
 err=Mus->Load("Nuked.mid",WAD->Seek("Nuked.mid"),WAD->GetSize("Nuked.mid"));
 if (err!=N2_SUCCESS) 
 {
  MessageBox(hwnd,N2_Err2Str(err),"Error!",MB_OK);
  return FALSE;
 }
 
 // Play music
 err=Mus->Play();
 if (err!=N2_SUCCESS) 
 {
  MessageBox(hwnd,N2_Err2Str(err),"Error!",MB_OK);
  return FALSE;
 }
 
 // Create GFX objects
 Ball=new N2_Surface();
 Star=new N2_Surface();
 Logo=new N2_Surface();
 
 // Setup graphics and screen
 RenderInit();
 
 // Setup star random start coords
 for (int c=0;c<NUMSTARS;c++)
 {
  star[c].x=rand()%Width;
  star[c].y=rand()%Height;
 }
 
 // If init phase was ok!
 return TRUE;
}

// +---------------------------------------------------------------+
// | Called when window is destroyed. All de-allocation goes here. |
// +---------------------------------------------------------------+

void Destroy_Phase(HWND hwnd)
{
 // Destroy all DirectX objects here
 // Post a quit message
 PostQuitMessage(0);
}

// +--------------------------------------------------------------+
// | This is called during IDLE time for maximum game perfomance! |
// +--------------------------------------------------------------+

void Update_Game()
{ 
 
 // Erase background
 Screen->GetBack()->Erase(0); 
 
 // Update coordinates according to offset
 for (int c=0;c<MAXBALLS;c++)
 {
 
 // Move balls
 X[c]+=XOffs[c];
 Y[c]+=YOffs[c];
 
 // Check for boundaries on X axis. Play sample when hit border
 if (X[c]>(Width-SPEED)-Ball->GetWidth()) {XOffs[c]=-SPEED;}; // If BallX > screen size revert direction
 if (X[c]<SPEED) {XOffs[c]=+SPEED;}; // Same if < than 0. 
 
 // Now it's the Y axis turn
 if (Y[c]>(Height-SPEED)-Ball->GetWidth()) {YOffs[c]=-SPEED;}; 
 if (Y[c]<SPEED) {YOffs[c]=+SPEED;};   
 }
 
 // Move stars
 for (c=0;c<NUMSTARS;c++)
 {
  // Move stars
  star[c].y+=3;
 
  // Reset stars over the edge
  if (star[c].y>Height) star[c].y=0;
  
  // Draw stars
  Star->DrawClip(star[c].x,star[c].y,TRUE,Screen->GetBack());
 }
 
 // Update frame rate
 FPS.Update();
 
 // Draw Balls and logo
 for (c=0;c<MAXBALLS;c++)
 Ball->DrawClip(X[c],Y[c],TRUE,Screen->GetBack());
  
 // Draw logo
 Logo->DrawClip(ScrollX,480/2-(Logo->GetHeight()/2),TRUE,Screen->GetBack());
 
 // Move scrolltext
 ScrollX--;
 
 // Reset scroll if over the egde
 if (ScrollX<-Logo->GetWidth()) ScrollX=640;
 
 // Show frameRate
 FPS.Show(0,0,RGB(255,255,255),Screen->GetBack());
 
 // Update screen
 Screen->Flip(TRUE);
}

