// +----------------------------------------------------------------------+
// | NUKE 2 Simple QuickStart Template  (C)1998 Odin Jensen/NUKE Software |
// +----------------------------------------------------------------------+
// | Template Part : Main source + all init/destroy parts                 |
// +----------------------------------------------------------------------+

// Include files here. 

#include <windows.h>
#include <windowsx.h>
#include <nuke2.h> // Include NUKE2 header
#include "project\resource.h"

// Global variables

HWND hwnd;              // Window handle. Easier as global.
HINSTANCE hInst;        // The same here.
BOOL NotPaused=TRUE;    // Used to pause game when user changes app. Remove this in netplay
                        // so users who change app. wont pause the entire game.

char GameName[]="Nuke2 Tutorial 2 - 256 color action!"; // Name of your game.

// !!! TUTORIAL STUFF !!!

// Screen
N2_Screen Screen;

// Image
N2_Surface Image; 

// !!! TUTORIAL STUFF !!!

// Function prototypes.

// Windows main entry point and game loop launcher.
int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow);

// Windows message loop. Only used for initialization, quit key and de-initializiation
LRESULT CALLBACK WndProc(HWND hwnd,UINT Message, WPARAM wParam,LPARAM lParam);

// This is called during IDLE time for maximum game perfomance!
void Update_Game(); 

// Called on window initialization. All your setup code goes here.
BOOL Init_Game();

// Called when window is destroyed. All de-allocation goes here.
void Destroy_Phase(HWND hwnd);

// Implementation

// +--------------------------------------------------+
// | Windows main entry point and game loop launcher. |
// +--------------------------------------------------+

int WINAPI WinMain(HINSTANCE hInst,HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
 MSG msg;     // Message structure
 WNDCLASS wc; // Window class
 // Create window and register it.
 wc.style=CS_HREDRAW|CS_VREDRAW;
 wc.lpfnWndProc=WndProc;
 wc.cbClsExtra=0;
 wc.cbWndExtra=0;
 wc.hInstance=hInst;
 // Possibility of loading own icon and cursor.
 // Replace NULL with hInst and IDI_? with MAKEINTRESOURCE(Name of your icon. I.e IDI_MYICON)
 wc.hIcon=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON1));
 wc.hCursor=LoadCursor(NULL,IDC_ARROW);
 wc.hbrBackground=GetStockObject(BLACK_BRUSH);
 wc.lpszMenuName=NULL;
 wc.lpszClassName=GameName;
 // Can we register? Else abort appliciation.
 if (RegisterClass(&wc)==0) return FALSE;
 // Now, try to create window
 hwnd=CreateWindow(GameName,GameName,WS_POPUP,0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),NULL,NULL,hInst,NULL);
 // If failed, abort!
 if (hwnd==NULL) return FALSE;
 // Now show and update window. Before init window. It sucks!!! 
 ShowWindow(hwnd,nCmdShow);
 UpdateWindow(hwnd);
 // Init game
 if (!Init_Game()) return FALSE;
 // And finally. Hide the cursor. We usually make our own. 
 ShowCursor(FALSE);
 // Loop for eternity (or quit)
 while( 1 )
  {
   if(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
    {
     if(!GetMessage( &msg, NULL, 0, 0 ))
      return msg.wParam;
     TranslateMessage(&msg); 
     DispatchMessage(&msg);
    }
   else if (NotPaused)
    Update_Game();
   else
    WaitMessage();
  }
}


// +------------------------------------------------------------------+
// | Windows message loop. Normal windows key messages are sent here! |
// +------------------------------------------------------------------+

LRESULT CALLBACK WndProc(HWND hwnd,UINT Message, WPARAM wParam,LPARAM lParam)
{
 switch(Message)
  {
   // Handle create/destroy
   HANDLE_MSG(hwnd,WM_DESTROY,Destroy_Phase);
   // If MIDI playback stopped 
 case MM_MCINOTIFY:
	 // Restart MIDI music here if you want repeated music
	 break;
   // If user switches app. Pause game. 
   case WM_ACTIVATEAPP:
        NotPaused = wParam;
        break;   
   // Check for system keys
   case WM_SYSKEYUP:
	switch(wParam)
	{
     // Is this alt-return? (Switch full/window) 
	 case VK_RETURN: 
	 break; 
	}
	break;
   // Check for keypress
   case WM_KEYDOWN:
    switch(wParam)
     {
      // Quit game key   
	  case VK_ESCAPE: 
       PostMessage(hwnd, WM_CLOSE, 0, 0);
      break;
      }
   break;
  }
 // If not a message we want to handle, pass it along to the default handler
 return DefWindowProc(hwnd, Message, wParam, lParam);

}

// +------------------------------------------------------------------+
// | Called on program initialization. All your setup code goes here. |
// +------------------------------------------------------------------+

BOOL Init_Game()
{
 
 // Create fullscreen
 if (Screen.CreateFull(hwnd,640,480,8,TRUE)!=N2_SUCCESS);
 
 // Load palette and attach to front buffer
 if (Screen.GetFront()->LoadPalette("256col.bmp")!=N2_SUCCESS)
	 return FALSE;
 
 // Load test bitmap.
 if (Image.Load("256col.bmp")!=N2_SUCCESS)
	 return FALSE;
 
 // Create system memory surface
 if (Image.Create(N2_SYSMEM)!=N2_SUCCESS)
	 return FALSE;
 
 // Copy data to surface
 Image.Data2Surface(0,0);
 
 // If init phase was ok!
 return TRUE;
}

// +---------------------------------------------------------------+
// | Called when window is destroyed. All de-allocation goes here. |
// +---------------------------------------------------------------+

void Destroy_Phase(HWND hwnd)
{
 // Destroy all DirectX objects here
 // Post a quit message
 PostQuitMessage(0);
}

// +--------------------------------------------------------------+
// | This is called during IDLE time for maximum game perfomance! |
// +--------------------------------------------------------------+

void Update_Game()
{
 // Draw image to back buffer
 Image.Draw(0,0,FALSE,Screen.GetBack());
 
 // Update screen
 Screen.Flip(TRUE);
}

