// mfcDDex2.cpp : Defines the class behaviors for the CFullScreenApplication.
//

#include "stdafx.h"
#include "mfcDDex2.h"

#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CmfcDDex2App

BEGIN_MESSAGE_MAP(CmfcDDex2App, CWinApp)
	//{{AFX_MSG_MAP(CmfcDDex2App)
	//}}AFX_MSG_MAP
	// Standard file based document commands
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CmfcDDex2App construction

// Construct the direct draw object, the surface, and the palette.
CmfcDDex2App::CmfcDDex2App() :
	m_DD (),
	m_Surface (&m_DD, "ALL", RGB (0,0,0)),
	m_Palette (&m_DD, "ALL")
{
	m_lastTickCount [0] = 0;
	m_lastTickCount [1] = 0;
	m_lastTickCount [2] = 0;
	m_lastTickCount [3] = 0;
	m_currentFrame [0] = 0;
	m_currentFrame [1] = 0;
	m_currentFrame [2] = 0;
	m_xpos[0] = 288;
	m_xpos[1] = 190;
	m_xpos[2] = 416;
	m_ypos[0] = 128;
	m_ypos[1] = 300;
	m_ypos[2] = 256;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CmfcDDex2App object

CmfcDDex2App theApp;

/////////////////////////////////////////////////////////////////////////////
// CmfcDDex2App initialization

// Initialize the application.
// To do this, create the main window.  
// I do this by using the LoadFrame function.
// I override the LoadFrame function in the CMainFrame class.
BOOL CmfcDDex2App::InitInstance()
{
	// Create a simple frame window:
	ASSERT(IDR_MAINFRAME != 0); // must have a resource ID to load from

	CFrameWnd* pFrame = (CFrameWnd*)(RUNTIME_CLASS(CMainFrame))->CreateObject();
	if (pFrame == NULL)
	{
		TRACE1("Warning: Dynamic create of frame %hs failed.\n",
			RUNTIME_CLASS(CMainFrame)->m_lpszClassName);
		return NULL;
	}

	// create new from resource
	if (!pFrame->LoadFrame(IDR_MAINFRAME, WS_POPUP))
	{
		TRACE0("Warning: couldn't create a frame.\n");
		// frame will be deleted in PostNcDestroy cleanup
		return FALSE;
	}
	m_pMainWnd = pFrame;
	// Need to show the window before the SetExclusiveMode call.
	pFrame->ShowWindow (SW_NORMAL);
	
	// Now that the window exists, the direct draw object
	// can be created.  So, create the direct draw object,
	// then create the palette, create the bitmap surface,
	// and finally, mark the surfaces.

	// create the main DirectDraw object
	m_DD.Create (*m_pMainWnd, 640, 480, 8);

    // create and set the palette
	m_Palette.Create ();

	m_DD.SetPalette (m_Palette);


    // Create the offscreen surface, by loading our bitmap.
	m_Surface.Create();

    //
    // Mark the colors used in the torus frames
    //
    int i,x,y;

    // First, set all colors as unused
    for(i=0; i<256; i++)
    {
        m_torusColors[i] = 0;
    }

    // lock the surface and scan the lower part (the torus area)
    // and remember all the index's we find.
	CddSurfaceDesc       ddsd;
	CRect rc (0,0,0,0);
	m_Surface.Lock (rc, ddsd, DDLOCK_WAIT, NULL);

    // Now search through the torus frames and mark used colors
    for( y=480; y<480+384; y++ )
    {
        for( x=0; x<640; x++ )
        {
            m_torusColors[((BYTE *)ddsd.lpSurface)[y*ddsd.lPitch+x]] = 1;
        }
    }

	m_Surface.Unlock(ddsd);
	return TRUE;
}


/////////////////////////////////////////////////////////////////////////////
// CmfcDDex2App commands

BOOL CmfcDDex2App::OnIdle(LONG lCount) 
{
	CWinApp::OnIdle (lCount);
	return updateFrame ();
}

// This function is used to update the frame buffer.
BOOL CmfcDDex2App::updateFrame()
{
	if (!((CMainFrame*)m_pMainWnd)->m_bActive)
		return FALSE;

    DWORD               thisTickCount;
    RECT                rcRect;
    DWORD               delay[4] = {50, 78, 13, 93};
    int                 i;
    PALETTEENTRY        pe[256];
    HRESULT             ddrval;

    // Decide which frame will be blitted next
    thisTickCount = GetTickCount();
    for(i=0; i<3; i++)
    {
        if((thisTickCount - m_lastTickCount[i]) > delay[i])
        {
            // Move to next frame;
            m_lastTickCount[i] = thisTickCount;
            m_currentFrame[i]++;
            if(m_currentFrame[i] > 59)
                m_currentFrame[i] = 0;
			// Added to move the sprites.
			if (++m_xpos[i] > (640-64))
				m_xpos[i] = 0;
			if (++m_ypos[i] > (480-64))
				m_ypos[i] = 0;
        }
    }

    // Blit the stuff for the next frame
    rcRect.left = 0;
    rcRect.top = 0;
    rcRect.right = 640;
    rcRect.bottom = 480;
    while( 1 )
    {
        ddrval = m_DD.BackBuffer().BltFast (0, 0, m_Surface, rcRect, DDBLTFAST_NOCOLORKEY );

        if( ddrval == DD_OK )
        {
            break;
        }
        if( ddrval == DDERR_SURFACELOST )
        {
            restoreAll();
        }
        if( ddrval != DDERR_WASSTILLDRAWING )
        {
            return TRUE;
        }
    }
    if(ddrval != DD_OK)
    {
        return TRUE;
    }

    for(i=0; i<3; i++)
    {
        rcRect.left   = m_currentFrame[i]%10*64;
        rcRect.top    = m_currentFrame[i]/10*64 + 480;
        rcRect.right  = m_currentFrame[i]%10*64 + 64;
        rcRect.bottom = m_currentFrame[i]/10*64 + 64 + 480;

        while( 1 )
        {
            ddrval = m_DD.BackBuffer().BltFast (m_xpos[i], m_ypos[i], m_Surface,
                                 rcRect, DDBLTFAST_SRCCOLORKEY );

            if( ddrval == DD_OK )
            {
                break;
            }
            if( ddrval == DDERR_SURFACELOST )
            {
                restoreAll();
            }
            if( ddrval != DDERR_WASSTILLDRAWING )
            {
                return TRUE;
            }
        }
    }
#ifdef EX_5
    if( (thisTickCount - m_lastTickCount[3]) > delay[3] )
    {
        // Change the palette
        m_Palette.GetEntries(0, 256, pe );
        for(i=1; i<256; i++)
        {
            if(!m_torusColors[i])
            {
                continue;
            }
            pe[i].peRed = (pe[i].peRed+2) % 256;
            pe[i].peGreen = (pe[i].peGreen+1) % 256;
            pe[i].peBlue = (pe[i].peBlue+3) % 256;
        }
        m_Palette.SetEntries(0, 256, pe);
   
        m_lastTickCount[3] = thisTickCount;
    }
#endif
    // Flip the surfaces
    while( 1 )
    {
        ddrval = m_DD.Paint ();
        if( ddrval == DD_OK )
        {
            break;
        }
        if( ddrval == DDERR_SURFACELOST )
        {
            restoreAll();
        }
        if( ddrval != DDERR_WASSTILLDRAWING )
        {
            break;
        }
    }

	return TRUE;
}

void CmfcDDex2App::restoreAll()
{
 //   m_DD.FrontSurface().Restore ();
   // m_Surface.Restore();
}

