// mfcddex3View.cpp : implementation of the CMfcddex3View class
//

#include "stdafx.h"
#include "mfcddex3.h"

#include "mfcddex3Doc.h"
#include "mfcddex3View.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMfcddex3View

IMPLEMENT_DYNCREATE(CMfcddex3View, CView)

BEGIN_MESSAGE_MAP(CMfcddex3View, CView)
	//{{AFX_MSG_MAP(CMfcddex3View)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcddex3View construction/destruction

CMfcddex3View::CMfcddex3View() :
	m_Surface (&m_DD, "ALL", RGB (0,0,0)),
	m_Palette (&m_DD, "ALL")
{
	m_lastTickCount [0] = 0;
	m_lastTickCount [1] = 0;
	m_lastTickCount [2] = 0;
	m_lastTickCount [3] = 0;
	m_currentFrame [0] = 0;
	m_currentFrame [1] = 0;
	m_currentFrame [2] = 0;
	m_xpos[0] = 288;
	m_xpos[1] = 190;
	m_xpos[2] = 416;
	m_ypos[0] = 128;
	m_ypos[1] = 300;
	m_ypos[2] = 256;
}

CMfcddex3View::~CMfcddex3View()
{
}

BOOL CMfcddex3View::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.cx = 640;
	cs.cy = 480;

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMfcddex3View drawing

void CMfcddex3View::OnDraw(CDC* pDC)
{
	CMfcddex3Doc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CMfcddex3View printing

BOOL CMfcddex3View::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CMfcddex3View::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CMfcddex3View::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CMfcddex3View diagnostics

#ifdef _DEBUG
void CMfcddex3View::AssertValid() const
{
	CView::AssertValid();
}

void CMfcddex3View::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CMfcddex3Doc* CMfcddex3View::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CMfcddex3Doc)));
	return (CMfcddex3Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMfcddex3View message handlers


void CMfcddex3View::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// create the main DirectDraw object
	m_DD.Create (*this, 640, 480);

    // create and set the palette
	m_Palette.Create ();

	m_DD.SetPalette (m_Palette);


    // Create the offscreen surface, by loading our bitmap.
	m_Surface.Create();

    //
    // Mark the colors used in the torus frames
    //
    int i,x,y;

    // First, set all colors as unused
    for(i=0; i<256; i++)
    {
        m_torusColors[i] = 0;
    }

    // lock the surface and scan the lower part (the torus area)
    // and remember all the index's we find.
	CddSurfaceDesc       ddsd;
	CRect rc (0,0,0,0);
	m_Surface.Lock (rc, ddsd, DDLOCK_WAIT, NULL);

    // Now search through the torus frames and mark used colors
    for( y=480; y<480+384; y++ )
    {
        for( x=0; x<640; x++ )
        {
            m_torusColors[((BYTE *)ddsd.lpSurface)[y*ddsd.lPitch+x]] = 1;
        }
    }

	m_Surface.Unlock(ddsd);
	
}

BOOL CMfcddex3View::updateFrame()
{
//	if (!((CMainFrame*)m_pMainWnd)->m_bActive)
//		return FALSE;

    DWORD               thisTickCount;
    RECT                rcRect;
    DWORD               delay[4] = {50, 78, 13, 93};
    int                 i;
    PALETTEENTRY        pe[256];
    HRESULT             ddrval;

    // Decide which frame will be blitted next
    thisTickCount = GetTickCount();
    for(i=0; i<3; i++)
    {
        if((thisTickCount - m_lastTickCount[i]) > delay[i])
        {
            // Move to next frame;
            m_lastTickCount[i] = thisTickCount;
            m_currentFrame[i]++;
            if(m_currentFrame[i] > 59)
                m_currentFrame[i] = 0;
			// Added to move the sprites.
			if (++m_xpos[i] > (640-64))
				m_xpos[i] = 0;
			if (++m_ypos[i] > (480-64))
				m_ypos[i] = 0;
        }
    }

    // Blit the stuff for the next frame
    rcRect.left = 0;
    rcRect.top = 0;
    rcRect.right = 640;
    rcRect.bottom = 480;
    while( 1 )
    {
        ddrval = m_DD.BackBuffer().BltFast (0, 0, m_Surface, rcRect, DDBLTFAST_NOCOLORKEY );

        if( ddrval == DD_OK )
        {
            break;
        }
        if( ddrval == DDERR_SURFACELOST )
        {
            restoreAll();
        }
        if( ddrval != DDERR_WASSTILLDRAWING )
        {
            return TRUE;
        }
    }
    if(ddrval != DD_OK)
    {
        return TRUE;
    }

    for(i=0; i<3; i++)
    {
        rcRect.left   = m_currentFrame[i]%10*64;
        rcRect.top    = m_currentFrame[i]/10*64 + 480;
        rcRect.right  = m_currentFrame[i]%10*64 + 64;
        rcRect.bottom = m_currentFrame[i]/10*64 + 64 + 480;

        while( 1 )
        {
            ddrval = m_DD.BackBuffer().BltFast (m_xpos[i], m_ypos[i], m_Surface,
                                 rcRect, DDBLTFAST_SRCCOLORKEY );

            if( ddrval == DD_OK )
            {
                break;
            }
            if( ddrval == DDERR_SURFACELOST )
            {
                restoreAll();
            }
            if( ddrval != DDERR_WASSTILLDRAWING )
            {
                return TRUE;
            }
        }
    }
#ifdef EX_5
    if( (thisTickCount - m_lastTickCount[3]) > delay[3] )
    {
        // Change the palette
        m_Palette.GetEntries(0, 256, pe );
        for(i=1; i<256; i++)
        {
            if(!m_torusColors[i])
            {
                continue;
            }
            pe[i].peRed = (pe[i].peRed+2) % 256;
            pe[i].peGreen = (pe[i].peGreen+1) % 256;
            pe[i].peBlue = (pe[i].peBlue+3) % 256;
        }
        m_Palette.SetEntries(0, 256, pe);
   
        m_lastTickCount[3] = thisTickCount;
    }
#endif
    // Flip the surfaces
    while( 1 )
    {
        ddrval = m_DD.Paint ();
        if( ddrval == DD_OK )
        {
            break;
        }
        if( ddrval == DDERR_SURFACELOST )
        {
            restoreAll();
        }
        if( ddrval != DDERR_WASSTILLDRAWING )
        {
            break;
        }
    }

	return TRUE;
}

void CMfcddex3View::restoreAll()
{
 //   m_DD.FrontSurface().Restore ();
   // m_Surface.Restore();
}


