/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1997/02/08
 C Compiler     : WATCOM 10.5
 Assembler      : WASM 10.5

-------------------------------------------------------------------
###################################################################*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "age_grp.h"


struct IMG_HEADER {
    CHAR    Header[20];
    S32     Width, Height;
    S32     LogX, LogY;
};


/************************
   A a
*************************/
IMAGE :: IMAGE( void )
{
    Width  = 0;
    Height = 0;

    Bitmap = NULL;

    LogX = LogY = 0;
}


/************************
   A a
*************************/
IMAGE :: IMAGE( INT Width, INT Height )
{
    Bitmap = NULL;

    Resize( Width, Height );
}


/************************
   A a
*************************/
IMAGE :: IMAGE( STRING FileName )
{
    Bitmap = NULL;

    Load( FileName );
}


/************************
   A ia
*************************/
IMAGE :: ~IMAGE()
{
    if( Bitmap ) delete Bitmap;
}


/************************
    = eea 
*************************/
IMAGE &IMAGE :: operator = ( const IMAGE &Image )
{
    if( Bitmap ) delete Bitmap;

    Width  = Image.Width;
    Height = Image.Height;

    LogX = Image.LogX;
    LogY = Image.LogY;

    int ImgSize = Width * Height;
    ImgSize = (ImgSize + 0x3) & ~0x3;

    Bitmap = new COLOR[ ImgSize ];
    memset( Bitmap, _TransColor, ImgSize );
    memcpy( Bitmap, Image.Bitmap, ImgSize );

    return( *this );
}


/********************************
  aaA i aea.
*********************************/
void IMAGE :: Load( STRING FileName )
{
    char *data;
    IMG_HEADER *ih;


    if( Bitmap ) delete Bitmap;

    _Resource.Load( FileName, &data );
    ih = (IMG_HEADER *)data;

    if( strcmp( ih->Header, "Amos Image File;" ) ) return;

    Width     = ih->Width;
    Height    = ih->Height;
    LogX      = ih->LogX;
    LogY      = ih->LogY;

    int ImgSize = Width * Height;
    ImgSize = (ImgSize + 0x3) & ~0x3;

    Bitmap = new COLOR[ ImgSize ];
    memcpy( Bitmap, data + sizeof(IMG_HEADER), Width * Height );

    free( data );
}


/********************************
  aaA i aea.
*********************************/
void IMAGE :: Write( STRING FileName )
{
    IMG_HEADER ih;


    if( !Bitmap ) return;

    memcpy( ih.Header, "Amos Image File;", 20 );
    ih.Width     = Width;
    ih.Height    = Height;
    ih.LogX      = LogX;
    ih.LogY      = LogY;

    int ImgSize  = Width * Height;

    /* Word Alignment */
    if( ImgSize & 0x3 ) ImgSize += 4 - (ImgSize & 0x3);

    FILE *fp = fopen( FileName, "wb" );
    fwrite( &ih, sizeof(IMG_HEADER), 1, fp );
    fwrite( Bitmap, ImgSize, 1, fp );
    fclose( fp );
}


/***************************
   ai ea.
****************************/
void IMAGE :: Resize( INT Width, INT Height )
{
    if( Bitmap ) delete Bitmap;

    this->Width  = Width;
    this->Height = Height;

    int ImgSize = Width * Height;
    ImgSize = (ImgSize + 0x3) & ~0x3;

    Bitmap = new COLOR[ ImgSize ];
    memset( Bitmap, _TransColor, ImgSize );

    LogX = LogY = 0;
}


/*************************
   ái ea.
**************************/
void IMAGE :: SetLogPosition( INT LogX, INT LogY )
{
    this->LogX = LogX;
    this->LogY = LogY;
}

