/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1997/02/08
 C Compiler     : WATCOM 10.5
 Assembler      : WASM 10.5

-------------------------------------------------------------------
###################################################################*/

#include <stdio.h>
#include <string.h>
#include "age_grp.h"


struct PIC_HEADER {
    CHAR     Header[20];
    INT      Ver;
    INT      Width, Height;
};


SCREEN      _Screen( (COLOR *)0xA0000 );


/*************************
  aa A a
**************************/
SCREEN :: SCREEN( void ) : PALETTEMAP()
{
    Video = new COLOR[ VMEM_SIZE ];

    IsVirtual = TRUE;

    Clear( 0 );
}


/*************************
  aa A a
**************************/
SCREEN :: SCREEN( COLOR *Video ) : PALETTEMAP()
{
    this->Video = Video;

    IsVirtual = FALSE;
}


/*************************
  aa A a
**************************/
SCREEN :: SCREEN( STRING FileName ) : PALETTEMAP()
{
    Video = new COLOR[ VMEM_SIZE ];

    Load( FileName );

    IsVirtual = TRUE;
}


/*************************
  aa A ia
**************************/
SCREEN :: ~SCREEN()
{
    if( IsVirtual ) delete Video;
}


/******************************
  A eA wi aea.
*******************************/
SCREEN &SCREEN :: operator = ( const SCREEN &Screen )
{
    memcpy( Video, Screen.Video, VMEM_SIZE );
    memcpy( Palette, Screen.Palette, 256*sizeof(PALETTE) );

    return( *this );
}


/****************************************
  e wi E a a.
*****************************************/
void SCREEN :: Clear( COLOR Color )
{
    memset( Video, Color, VMEM_SIZE );
}


/****************************************
  e wi aw A wea.
*****************************************/
void SCREEN :: Load( STRING FileName )
{
    char *res;
    _Resource.Load( FileName, &res );
    char *temp = res;

    PIC_HEADER *ph = (PIC_HEADER *)res;
    res += sizeof(PIC_HEADER);
    if( strcmp( ph->Header, "Amos Picture File;" ) ) return;
    if( ph->Ver != 2 ) return;

    PALETTEMAP::Set( (PALETTE *)res );
    res += sizeof( PALETTE[256] );

    memcpy( Video, res, VMEM_SIZE );

    free( temp );
}


/****************************************
  e wi aw A wea.
*****************************************/
void SCREEN :: Write( STRING FileName )
{
    PIC_HEADER ph;

    FILE *fp = fopen( FileName, "wb" );

    memcpy( ph.Header, "Amos Picture File;", 20 );
    ph.Ver    = 2;
    ph.Width  = SCREEN_WIDTH;
    ph.Height = SCREEN_HEIGHT;
    fwrite( &ph, sizeof(PIC_HEADER), 1, fp );

    fwrite( Palette, sizeof( PALETTE[256] ), 1, fp );
    fwrite( Video, VMEM_SIZE, 1, fp );

    fclose( fp );
}


/*******************************
  aw A wbi aea.
********************************/
void SCREEN :: Save( SCREEN &Screen, INT StartX, INT StartY, INT EndX, INT EndY )
{
    int i;
    COLOR *SrcPtr, *DesPtr;
    int width, height;


    if( StartX > EndX ){
      i = StartX; StartX = EndX; EndX = i;
    }
    if( StartY > EndY ){
      i = StartY; StartY = EndY; EndY = i;
    }

    if( (StartX > _Clip.EndX) || (EndX < _Clip.StartX) ||
        (StartY > _Clip.EndY) || (EndY < _Clip.StartY) )
      return;

    if( StartX < _Clip.StartX ) StartX = _Clip.StartX;
    if( EndX   > _Clip.EndX   ) EndX   = _Clip.EndX;
    if( StartY < _Clip.StartY ) StartY = _Clip.StartY;
    if( EndY   > _Clip.EndY   ) EndY   = _Clip.EndY;

    SrcPtr = Screen.Video + CALC_OFFS( StartX, StartY );
    DesPtr = Video + CALC_OFFS( StartX, StartY );

    width  = EndX - StartX + 1;
    height = EndY - StartY + 1;

    for( i = 0; i < height; i ++ ){
      memcpy( DesPtr, SrcPtr, width );
      DesPtr += VMEM_WIDTH;
      SrcPtr += VMEM_WIDTH;
    }
}


/**************************************
  awA i aea.
***************************************/
void SCREEN :: Restore( SCREEN &Screen, INT StartX, INT StartY, INT EndX, INT EndY )
{
    int i;
    COLOR *SrcPtr, *DesPtr;
    int width, height;


    if( StartX > EndX ){
      i = StartX; StartX = EndX; EndX = i;
    }
    if( StartY > EndY ){
      i = StartY; StartY = EndY; EndY = i;
    }

    if( (StartX > _Clip.EndX) || (EndX < _Clip.StartX) ||
        (StartY > _Clip.EndY) || (EndY < _Clip.StartY) )
      return;

    if( StartX < _Clip.StartX ) StartX = _Clip.StartX;
    if( EndX   > _Clip.EndX   ) EndX   = _Clip.EndX;
    if( StartY < _Clip.StartY ) StartY = _Clip.StartY;
    if( EndY   > _Clip.EndY   ) EndY   = _Clip.EndY;

    SrcPtr = Video + CALC_OFFS( StartX, StartY );
    DesPtr = Screen.Video + CALC_OFFS( StartX, StartY );

    width  = EndX - StartX + 1;
    height = EndY - StartY + 1;

    for( i = 0; i < height; i ++ ){
      memcpy( DesPtr, SrcPtr, width );
      DesPtr += VMEM_WIDTH;
      SrcPtr += VMEM_WIDTH;
    }
}


/*********************************
  eA e Ai aea.
**********************************/
void SCREEN :: Display( void )
{
    CRTC::WaitVert();

    _Screen = *this;
}

