/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1997/02/08
 C Compiler     : WATCOM 10.5
 Assembler      : WASM 10.5

-------------------------------------------------------------------
###################################################################*/

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "age_grp.h"
#include "age_err.h"


struct SPR_HEADER {
    CHAR    Header[20];
    INT     Ver;
    INT     Count;
};

struct IMG_HEADER {
    INT     Width, Height;
    INT     LogX,  LogY;
};


/*************************
  aaaa a
**************************/
SPRITE :: SPRITE( void )
{
    Count = 0;
    Image = (IMAGE *)NULL;
}


/*************************
  aaaa a
**************************/
SPRITE :: SPRITE( STRING FileName )
{
    Count = 0;
    Image = (IMAGE *)NULL;

    Load( FileName );
}


/*************************
  aaaa ia
**************************/
SPRITE :: ~SPRITE()
{
    Reset();
}


/*************************
  aaaa ia
**************************/
void SPRITE :: Reset( void )
{
    if( Count > 0 ){
      int count = Count;

      for( int i = 0; i < count; i ++ )
        free( Image[i].Bitmap );

      free( Image );

      Count = 0;
    }
}


/**************************************
  a aaaai aea.
***************************************/
void SPRITE :: Load( STRING FileName )
{
    Reset();

    char *res;
    _Resource.Load( FileName, &res );
    char *temp = res;

    SPR_HEADER *sh = (SPR_HEADER *)res;
    res += sizeof(SPR_HEADER);
    if( strcmp( sh->Header, "Amos Sprite File;" ) ) return;
    if( sh->Ver != 2 ) return;

    int count = sh->Count;

    for( int i = 0; i < count; i ++ ){
      IMG_HEADER *ih = (IMG_HEADER *)res;
      res += sizeof(IMG_HEADER);

      IMAGE *img = new IMAGE( ih->Width, ih->Height );
      int ImgSize = ih->Width * ih->Height;
      memcpy( img->Bitmap, res, ImgSize );

      /* a ii Ё... */
      ImgSize = (ImgSize + 0x3) & ~0x3;
      res += ImgSize;

      img->SetLogPosition( ih->LogX, ih->LogY );

      AddImage( *img );
      delete img;
    }

    free( temp );
}


/**********************************
  aaA aaaai wea.
***********************************/
void SPRITE :: Write( STRING FileName )
{
    SPR_HEADER sh;
    IMG_HEADER ih;


    FILE *fp = fopen( FileName, "wb" );

    memcpy( sh.Header, "Amos Sprite File;", 20 );
    sh.Ver   = 2;
    sh.Count = Count;
    fwrite( &sh, sizeof(SPR_HEADER), 1, fp );

    for( int i = 0; i < Count; i ++ ){
      IMAGE *img = &Image[i];

      ih.Width  = img->Width;
      ih.Height = img->Height;
      ih.LogX   = img->LogX;
      ih.LogY   = img->LogY;

      fwrite( &ih, sizeof(IMG_HEADER), 1, fp );

      int ImgSize = img->Width * img->Height;

      /* a ii Ё... */
      ImgSize = (ImgSize + 0x3) & ~0x3;

      fwrite( img->Bitmap, ImgSize, 1, fp );
    }

    fclose( fp );
}


/*************************
  aaaai aea.
**************************/
void SPRITE :: AddImage( IMAGE &Image )
{
    int PtrSize = (Count + 1) * sizeof(IMAGE);

    this->Image = (IMAGE *)realloc( this->Image, PtrSize );

    IMAGE *img = &this->Image[ Count ];

    img->Bitmap = (COLOR *)NULL;
    *img = Image;

    Count ++;
}


/*******************************
  aaaa i ea.
********************************/
IMAGE * SPRITE :: GetImagePtr( INT Index )
{
    if( Index < 0 || Index >= Count ) return( NULL );

    return( &Image[ Index ] );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: Put( INT X, INT Y, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->Put( X, Y );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutStretch( INT X, INT Y, INT tWidth, INT tHeight, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutStretch( X, Y, tWidth, tHeight );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutScale( INT X, INT Y, FIXED Scale, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutScale( X, Y, Scale );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutChar( INT X, INT Y, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutChar( X, Y );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutCharStretch( INT X, INT Y, INT tWidth, INT tHeight, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutCharStretch( X, Y, tWidth, tHeight );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutCharScale( INT X, INT Y, FIXED Scale, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutCharScale( X, Y, Scale );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutShadow( INT X, INT Y, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutShadow( X, Y );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutShadowStretch( INT X, INT Y, INT tWidth, INT tHeight, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutShadowStretch( X, Y, tWidth, tHeight );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutShadowScale( INT X, INT Y, FIXED Scale, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutShadowScale( X, Y, Scale );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutShadowTrans( INT X, INT Y, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutShadowTrans( X, Y, _ShadeTransTable.Get() );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutShadowTransStretch( INT X, INT Y, INT tWidth, INT tHeight, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutShadowTransStretch( X, Y, tWidth, tHeight, _ShadeTransTable.Get() );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutShadowTransScale( INT X, INT Y, FIXED Scale, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutShadowTransScale( X, Y, Scale, _ShadeTransTable.Get() );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutTrans( INT X, INT Y, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutTrans( X, Y, _ImageTransTable.Get() );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutTransStretch( INT X, INT Y, INT tWidth, INT tHeight, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutTransStretch( X, Y, tWidth, tHeight, _ImageTransTable.Get() );
}


/***********************
  aaaai ea.
************************/
void SPRITE :: PutTransScale( INT X, INT Y, FIXED Scale, INT Index )
{
    IMAGE *img = GetImagePtr( Index );
    if( !img ) return;

    img->PutTransScale( X, Y, Scale, _ImageTransTable.Get() );
}

