/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1997/02/08
 C Compiler     : WATCOM 10.5
 Assembler      : WASM 10.5

-------------------------------------------------------------------
###################################################################*/

#include <dos.h>
#include <conio.h>
#include <string.h>
#include "age_in.h"


MULTIKEY _Key;


/************************
  ˡǡ A a
*************************/
MULTIKEY :: MULTIKEY( void )
{
    OldKeyVect = NULL;

    Reset();
}


/************************
  ˡǡ A ia
*************************/
MULTIKEY :: ~MULTIKEY()
{
    Deactivate();
}


/******************************
   ǡ a Ѕi
*******************************/
static void __interrupt __far MULTIKEY :: NewKeyVect( void )
{
    _disable();

    int k    = inp( 0x60 );
    int flag = k & 0x80;

    k   &= 0x7F;

    if( !flag ){
      _Key.Last = (CHAR)k;

      if( !_Key.Scan[k] ){
        _Key.Scan[k] = TRUE;
        _Key.Press ++;
      }
    } else {
      if( _Key.Scan[k] ){
        _Key.Scan[k] = FALSE;
        _Key.Press --;
      }
    }

    outp( 0x20, 0x20 );

    _enable();
}


/*********************
  Ai Uea.
**********************/
void MULTIKEY :: Reset( void )
{
    for( int i = 0; i < 128; i ++ ) Scan[i] = FALSE;

    Last = NULL;

    Press = 0;
}


/****************
  A ɬ
*****************/
void MULTIKEY :: Activate( void )
{
    if( !OldKeyVect ){
      OldKeyVect = _dos_getvect( 0x09 );

      _dos_setvect( 0x09, NewKeyVect );
    }

    Reset();
}


/****************
  A ɬ
*****************/
void MULTIKEY :: Deactivate( void )
{
    if( OldKeyVect ){
      _dos_setvect( 0x09, OldKeyVect );

      OldKeyVect = NULL;
    }
}

