/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1997/02/08
 C Compiler     : WATCOM 10.5
 Assembler      : WASM 10.5

-------------------------------------------------------------------
###################################################################*/

#include "age_low.h"



/*************************
  abwi Aǥa.
**************************/
void RECT :: Normal( void )
{
    int temp;

    if( StartX > EndX ){
      temp   = StartX;
      StartX = EndX;
      EndX   = temp;
    }

    if( StartY > EndY ){
      temp   = StartY;
      StartY = EndY;
      EndY   = temp;
    }
}


/***********************************
   abw eA eai iϥa.
************************************/
BOOL RECT :: IsInnerPoint( INT X, INT Y )
{
    return( X >= StartX && X <= EndX &&
            Y >= StartY && Y <= EndY );
}


/***********************************
   abw eA eai iϥa.
************************************/
BOOL RECT :: IsInnerPoint( POINT &Point )
{
    return( Point.X >= StartX && Point.X <= EndX &&
            Point.Y >= StartY && Point.Y <= EndY );
}


/*************************************
   abw Aeai iϥa.
**************************************/
BOOL RECT :: IsIntersect( RECT &Rect )
{
    if( StartX < Rect.StartX )
      if( Rect.StartX > EndX ) return( FALSE );
    else
      if( StartX > Rect.EndX ) return( FALSE );

    if( StartY < Rect.StartY )
      if( Rect.StartY > EndY ) return( FALSE );
    else
      if( StartY > Rect.EndY ) return( FALSE );

    return( TRUE );
}


/*************************************
   abw E wbi Aaea.
  e abw AA gv,
   ᝡ sá gvae wⷥ
  ia a gea.
**************************************/
void RECT :: Intersect( RECT *DesRect, RECT &Rect )
{
    DesRect->StartX = ( StartX > Rect.StartX )? StartX : Rect.StartX;
    DesRect->StartY = ( StartY > Rect.StartY )? StartY : Rect.StartY;

    DesRect->EndX   = ( EndX < Rect.EndX )? EndX : Rect.EndX;
    DesRect->EndY   = ( EndY < Rect.EndY )? EndY : Rect.EndY;
}

