/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1998/01/08
 C Compiler     : WATCOM 11.0
 Assembler      : WASM 11.0

-------------------------------------------------------------------
###################################################################*/

#include <dos.h>
#include <conio.h>
#include "age_low.h"


// a ti wi be
LONG MULTITIMER::OrgTick = 0;

static void (__interrupt __far *OldTimerVect)( void ) = NULL;
static int OldTick = 0;
static MULTITIMER *_MultiTimer[ MTIMER_COUNT+1 ] = { NULL, };


/**************************************
   a a(=08h) Ѕi
***************************************/
static void __interrupt __far __loadds NewTimerVect( void )
{
    // a 
    _disable();

    // a t wa
    MULTITIMER::OrgTick ++;

    // ˡ a
    MULTITIMER *mt;

    // ˡ ai ១ea.
    for( int i = 1; i <= MTIMER_COUNT; i ++ ){
      // e ˡ a ei ea.
      mt = _MultiTimer[i];
      // e aa Aae...
      if( mt ){
        // a ˢi aa wa
        mt->Tick ++;
        // a ˢ E i e...
        if( mt->Tick >= mt->Period ){
          // ˢe U
          mt->Tick = 0;
          mt->Counter ++;
          // a Ѕi ѡ
          if( mt->Handler ) mt->Handler();
        }
      }
    }

    // 巁 a a Ѕii 
    if( ++OldTick >= TIMER_RATE / 18.2 ){
      OldTick = 0;
      OldTimerVect();
    }

    // a AI a ѡ a
    outp( 0x20, 0x20 );

    // a ɬ
    _enable();
}


/***********************
  ai ea.
************************/
void MULTITIMER :: InitTimer( void )
{
    // a 
    _disable();

    // a ŝe b e 
    OrgTick = 0;
    OldTick = 0;

    // ˡ a 
    for( int i = 0; i <= MTIMER_COUNT; i ++ )
      _MultiTimer[i]  = NULL;

    // 8253 a᷁ ai 1000Hz ia.
    outp( 0x43, 0x3C );
    outp( 0x40, (1193180 / TIMER_RATE) & 0xFF );
    outp( 0x40, (1193180 / TIMER_RATE) >> 8 );

    //  a a Ѕii ea.
    OldTimerVect = _dos_getvect( 0x08 );

    //  a Ѕi 
    _dos_setvect( 0x08, NewTimerVect );

    // a ɬ
    _enable();
}


/***********************
  ai ǥa.
************************/
void MULTITIMER :: CloseTimer( void )
{
    // e  aa Aae
    if( OldTimerVect ){
      // a a Ѕi 
      _dos_setvect( 0x08, OldTimerVect );

      // 8253 a᷁ ai w(18.2Hz) a.
      outp( 0x43, 0x3C );
      outp( 0x40, 0 );
      outp( 0x40, 0 );
    }

    // b ˡ ai ɬǥa.
    for( int i = 0; i <= MTIMER_COUNT; i ++ )
      if( _MultiTimer[i] )
        _MultiTimer[i]->Disable();
}


/*********************
  ˡ a a
**********************/
MULTITIMER :: MULTITIMER( void )
{
    TimerID = 0;
    Tick    = 0;
    Counter = 0;
    Period  = 0;

    Handler = NULL;
}


/*********************
  ˡ a a
**********************/
MULTITIMER :: MULTITIMER( INT Period, void (*Handler)(void) )
{
    TimerID = 0;
    Tick    = 0;
    Counter = 0;

    this->Period  = Period;
    this->Handler = Handler;
}


/*********************
  ˡ a ia
**********************/
MULTITIMER :: ~MULTITIMER()
{
    Disable();
}


/*******************
  ˡ a U
********************/
void MULTITIMER :: Reset( void )
{
    Tick = 0;
    Counter = 0;
}


/**************************
  ˡ a Ѕi á
***************************/
void MULTITIMER :: SetHandler( void (*Handler)(void) )
{
    this->Handler = Handler;
}


/*************************
  ˡ a  
**************************/
void MULTITIMER :: SetPeriod( INT Period )
{
    this->Period = Period;
}


/*********************
  ˡ a ɬ
**********************/
BOOL MULTITIMER :: Enable( void )
{
    //  ai xea.
    for( int i = 1; i <= MTIMER_COUNT; i ++ )
      // awa ge aa ae...
      if( !_MultiTimer[i] ){
        // ai ea.
        TimerID = i;
        _MultiTimer[i] = this;
        return( TRUE );
      }

    return( FALSE );
}


/************************
  ˡ a aw 
*************************/
BOOL MULTITIMER :: Disable( void )
{
    // aa ɬ A ae...
    if( TimerID ){
      // Ёw a Ѕi aai bA
      _MultiTimer[ TimerID ] = (MULTITIMER *)NULL;
      return( TRUE );
    } else
      return( FALSE );
}

