/*#################################################################
-------------------------------------------------------------------

                             AGE (Ver 1.0)
                       (* =================== *)
                           Amos Game Engine

 Author         : Chu, Kyong-min( Amos )

 Date           : 1997/02/08
 C Compiler     : WATCOM 10.5
 Assembler      : WASM 10.5

-------------------------------------------------------------------
###################################################################*/

#include <stdio.h>
#include <io.h>
#include <string.h>
#include <malloc.h>
#include "age_res.h"
#include "age_err.h"


struct RESOURCE_HEADER {
    CHAR    Header[20];
    LONG    Version;
    LONG    FileCount;
    LONG    ResourceSize;
    CHAR    Dummy[40-(20+4+4+4)];
};


RESOURCE  _Resource;


/***********************

************************/
RESOURCE :: RESOURCE( void )
{
    Header = NULL;
}


/***********************

************************/
RESOURCE :: RESOURCE( STRING FileName )
{
    Header = NULL;

    Set( FileName );
}


/***********************

************************/
RESOURCE :: ~RESOURCE()
{
    if( Header ) delete Header;
}


/*******************************
  a ai Aaea.
  ""i ae  a a
********************************/
void RESOURCE :: Set( STRING FileName )
{
    FILE *fp;
    RESOURCE_HEADER rh;


    if( Header ) delete Header;

    Header = NULL;
    FileCount = 0;

    if( strcmp( FileName, "" ) ){
      if( (fp = fopen( FileName, "rb" )) == NULL ){
        puts( "Cannot open Resource file!\n\a" );
        exit( 1 );
      }

      fread( &rh, sizeof(RESOURCE_HEADER), 1, fp );

      if( strcmp( rh.Header, "Amos Resource File;" ) )
        return;

      Header = new FILE_HEADER[ rh.FileCount ];
      fread( (char *)Header, sizeof(FILE_HEADER) * rh.FileCount, 1, fp );

      fclose( fp );
      FileCount = rh.FileCount;

      strcpy( this->FileName, FileName );
    }
}


/*********************
  ai aea.
**********************/
static int cmpfunc( const void *a, const void *b )
{
    return( strncmp( (STRING)a, ((RESOURCE::FILE_HEADER *)b)->FileName, 8+1+3 ) );
}
ULONG RESOURCE :: Load( STRING FileName, CHAR **DesPtr )
{
    long  offs, flen;
    char filename[8+1+3 + 1];
    FILE_HEADER *fh;
    char *data;
    FILE *fp;


    if( Header == NULL ){
      fp = fopen( FileName, "rb" );
      flen = filelength( fileno(fp) );
      *DesPtr = data = new char[ flen ];
      fread( data, flen, 1, fp );
      fclose( fp );

      return( flen );
    } else {
      memset( filename, '\0', 8+1+3+1 );
      strncpy( filename, FileName, 8+1+3 );
      strupr( filename );

      fh = (FILE_HEADER *)bsearch( filename, Header, FileCount,
                                    sizeof(FILE_HEADER), cmpfunc );
      if( fh == NULL ) return( 0 );

      offs = sizeof(RESOURCE_HEADER) + FileCount * sizeof(FILE_HEADER)
                                     + fh->Offset;

      fp = fopen( this->FileName, "rb" );
      fseek( fp, offs, SEEK_SET );
      data = new char[ fh->FileSize ];
      fread( data, fh->FileSize, 1, fp );
      fclose( fp );

      if( fh->IsCompress ){
        Decode( DesPtr, data, fh->FileOrgSize );
        delete data;
      } else {
        *DesPtr = data;
      }

      return( fh->FileOrgSize );
    }
}


/*****************************
  Ba ai aea.
******************************/
ULONG RESOURCE :: Load( INT Index, CHAR **DesPtr )
{
    long  offs;
    FILE_HEADER *fh, *tfh;
    char *data;
    FILE *fp;


    if( Header == NULL ){
      return( 0 );
    } else {
      tfh = Header;
      fh = NULL;

      for( int i = 0; i < FileCount; i ++ ){
        if( Index == tfh->Index ){
          fh = tfh;
          break;
        }
        tfh ++;
      }
      if( fh == NULL ) return( 0 );

      offs = sizeof(RESOURCE_HEADER) + FileCount * sizeof(FILE_HEADER)
                                     + fh->Offset;

      fp = fopen( this->FileName, "rb" );
      fseek( fp, offs, SEEK_SET );
      data = (char *)malloc( fh->FileSize );
      fread( data, fh->FileSize, 1, fp );
      fclose( fp );

      if( fh->IsCompress ){
        Decode( DesPtr, data, fh->FileOrgSize );
        free( data );
      } else {
        *DesPtr = data;
      }

      return( fh->FileOrgSize );
    }
}


/*********************
  ai ЁAea.
**********************/
void RESOURCE :: Free( CHAR *ResPtr )
{
    free( ResPtr );
}

