/*
theme: Matrix & 3D space
coder: lee jong whan
email: leejw51@hitel.net
compile: tc 3.0 with EGAVGA.BGI
date:1998.4.3.FRI
*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <graphics.h>

class Matrix {
public:
float buf[4][4];
public:
Matrix(void);
Matrix(float a00,float a01,float a02,float a03,
	       float a10,float a11,float a12,float a13,
	       float a20,float a21,float a22,float a23,
	       float a30,float a31,float a32,float a33);

void update(float a00,float a01,float a02,float a03,
	       float a10,float a11,float a12,float a13,
	       float a20,float a21,float a22,float a23,
	       float a30,float a31,float a32,float a33);
Matrix(float a00,float a01,float a02);


Matrix operator * (Matrix a);
void unit(void);
void print(void);
};

Matrix::Matrix(void)
{
	buf[0][0]=1.0, buf[0][1]=0.0, buf[0][2]=0.0, buf[0][3]=0.0;
	buf[1][0]=0.0, buf[1][1]=1.0, buf[1][2]=0.0, buf[1][3]=0.0;
	buf[2][0]=0.0, buf[2][1]=0.0, buf[2][2]=1.0, buf[2][3]=0.0;
	buf[3][0]=0.0, buf[3][1]=0.0, buf[3][2]=0.0, buf[3][3]=1.0;
}

Matrix::Matrix(float a00,float a01,float a02,float a03,
	       float a10,float a11,float a12,float a13,
	       float a20,float a21,float a22,float a23,
	       float a30,float a31,float a32,float a33)
{
	buf[0][0]=a00,buf[0][1]=a01, buf[0][2]=a02, buf[0][3]=a03;
	buf[1][0]=a10, buf[1][1]=a11, buf[1][2]=a12, buf[1][3]=a13;
	buf[2][0]=a20, buf[2][1]=a21, buf[2][2]=a22, buf[2][3]=a23;
	buf[3][0]=a30, buf[3][1]=a31, buf[3][2]=a32, buf[3][3]=a33;

}

void  Matrix::update(float a00,float a01,float a02,float a03,
	       float a10,float a11,float a12,float a13,
	       float a20,float a21,float a22,float a23,
	       float a30,float a31,float a32,float a33)
{
	buf[0][0]=a00,buf[0][1]=a01, buf[0][2]=a02, buf[0][3]=a03;
	buf[1][0]=a10, buf[1][1]=a11, buf[1][2]=a12, buf[1][3]=a13;
	buf[2][0]=a20, buf[2][1]=a21, buf[2][2]=a22, buf[2][3]=a23;
	buf[3][0]=a30, buf[3][1]=a31, buf[3][2]=a32, buf[3][3]=a33;

}

Matrix::Matrix(float a00,float a01,float a02)
{
	buf[0][0]=a00,buf[0][1]=a01, buf[0][2]=a02, buf[0][3]=1.0;
	buf[1][0]=0.0, buf[1][1]=0.0, buf[1][2]=0.0, buf[1][3]=0.0;
	buf[2][0]=0.0, buf[2][1]=0.0, buf[2][2]=0.0, buf[2][3]=0.0;
	buf[3][0]=0.0, buf[3][1]=0.0, buf[3][2]=0.0, buf[3][3]=0.0;
}
void Matrix::unit(void)
{
	float a=buf[0][3];
	int i;
	for (i=0;i<=3;i++) buf[0][i]/=a;
}

void Matrix::print(void)
{
        int i,j;
	for (j=0;j<=3;j++) {
		for (i=0;i<=3;i++) {
		printf("%5.3f  ",buf[j][i]);
                }
	printf("\n");
	}
}

Matrix Matrix::operator * (Matrix a)
{
	int i,j,k;
        Matrix r;
        for (j=0;j<=3;j++) {  //row matrix of first
		for(i=0;i<=3;i++) { //column matrix of second
			r.buf[j][i]=0.0;
                        for (k=0;k<=3;k++) {
                        r.buf[j][i]+= buf[j][k] * a.buf[k][i];
			}

		}
	}
	return r;

}

void draw(void)
{
	float mx=0.0; //camera's location x,y,z
	float my=0.0;
	float mz=0.0;
	float sc=50.0;

	float tx=45.0*M_PI/180.0; //rotating angel around x axis
	float ty=45.0*M_PI/180.0;
	float tz=-45.0*M_PI/180.0;
	float zcp=100.0; //projection screen's location (or height)
	//it it is too short, image will be distorted..

	Matrix mov=Matrix(1.0, 0.0, 0.0, 0.0,
			  0.0, 1.0, 0.0, 0.0,
			  0.0, 0.0, 1.0, 0.0,
			  mx,  my,  mz,  1.0);
	Matrix sca=Matrix(sc, 0.0, 0.0, 0.0,
			  0.0, sc, 0.0, 0.0,
			  0.0, 0.0, sc, 0.0,
			  0.0,  0.0,  0.0,  1.0);

	Matrix zr=Matrix(cos(tz),sin(tz), 0.0, 0.0,
			 -sin(tz),cos(tz), 0.0, 0.0,
			 0.0, 0.0, 1.0, 0.0,
			 0.0, 0.0, 0.0, 1.0);
	Matrix yr=Matrix(cos(ty), 0.0, -sin(ty), 0.0,
			 0.0, 1.0, 0.0, 0.0,
			 sin(ty), 0.0, cos(ty), 0.0,
			 0.0, 0.0, 0.0, 1.0);
	Matrix xr=Matrix(1.0, 0.0, 0.0, 0.0,
			0.0, cos(tx), sin(tx), 0.0,
			0.0, -sin(tx), cos(tx), 0.0,
			0.0, 0.0, 0.0, 1.0);
	Matrix pro= Matrix( 1.0, 0.0, 0.0, 0.0,  //projection
			   0.0, 1.0, 0.0, 0.0,
			   0.0, 0.0, 0.0, 0.0,
			   0.0, 0.0, 0.0, 1.0);
	//translate->rotate(for the camera)
	//->perspective (zoom) -> projection to (screen's x y )
	Matrix s;

	Matrix p=Matrix(0.0, 0.0, 0.0);//1X4 matrix uses 4x4 matrix
	Matrix p2=Matrix(0.0, 0.0, 0.0);//as a convenience

	int x2,y2; //screen's x,y

	float th,pi,r=150.0;//for making 3d points
	float x,y,z;
	int key;

	while(1) {
	cleardevice();
	s=mov*sca*xr*yr*zr*pro;
	for (x=-3;x<=3;x+=0.2)
	for (y=-3;y<=3;y+=0.2)
	{
	//make 3d point's x y z
	//change x,y,z as you wish..
	z=sin(x)*sin(y)*sin(y);

	//produce 2d-coordinates
	p.buf[0][0]=x, p.buf[0][1]=y, p.buf[0][2]=z, p.buf[0][3]=1.0;

	p2=p*s;

	x2=(p2.buf[0][0])+640/2;
	y2=(p2.buf[0][1])+480/2;

	putpixel(x2,y2,WHITE);
	}
	key=getch();
	if (key=='a') tx-=(20.0*M_PI/180.0);
	if (key=='z') tx+=(20.0*M_PI/180.0);
	if (key=='s') ty-=(20.0*M_PI/180.0);
	if (key=='x') ty+=(20.0*M_PI/180.0);
		if (key=='d') tz-=(20.0*M_PI/180.0);
	if (key=='c') tz+=(20.0*M_PI/180.0);
	if (key=='f') sc-=2;
	if (key=='v') sc+=2;
	xr.update(1.0, 0.0, 0.0, 0.0,
			0.0, cos(tx), sin(tx), 0.0,
			0.0, -sin(tx), cos(tx), 0.0,
			0.0, 0.0, 0.0, 1.0);
	zr.update(cos(tz),sin(tz), 0.0, 0.0,
			 -sin(tz),cos(tz), 0.0, 0.0,
			 0.0, 0.0, 1.0, 0.0,
			 0.0, 0.0, 0.0, 1.0);
	yr.update(cos(ty), 0.0, -sin(ty), 0.0,
			 0.0, 1.0, 0.0, 0.0,
			 sin(ty), 0.0, cos(ty), 0.0,
			 0.0, 0.0, 0.0, 1.0);
	sca.update(sc, 0.0, 0.0, 0.0,
			  0.0, sc, 0.0, 0.0,
			  0.0, 0.0, sc, 0.0,
			  0.0,  0.0,  0.0,  1.0);


	if (key==27) return;


	}
}





void main(void)
{
	int card=VGA,mode=VGAHI; initgraph(&card,&mode,"");
	draw();
	getch(); closegraph();
}

