    

#include <windows.h>
#include <windowsx.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <ctype.h> //for isalpha
#include <stdio.h>
#include <stdlib.h>
#include <string.h> //for memset
#include <io.h>             
#include <math.h> //for sin,cos
#include <stdarg.h>

#include "resource.h"  
#include "winsock.h"
                                        
#include "def.h" //type definition and other defines..
#include "ext.h"  // extern 
#include "pro.h" //prototypes 
      
         
    


	  
        

void readfont(void)
{
    FILE* han,* eng, *f;
               
    //ѱ б
	han=fopen(HANGUL_FONT_NAME,"rb");
	if (han==NULL) {MessageBox(0,"cannot read hangul font","error",0);return;}
	fread(HF1,8*20*32,1,han);
	fread(HF2,4*22*32,1,han);
	fread(HF3,4*28*32,1,han);
	fclose(han);
	                       
	// б 	                       
	eng=fopen(ENGLISH_FONT_NAME, "rb");
	if (eng==NULL) {MessageBox(0,"cannot read english font","error",0);return;}
	fread(EF,256*16,1,eng);
	fclose(eng);
	                  
	//ȣ  б   
	f=fopen(GRF_FONT_NAME,"rb");
	if (f==NULL) {Say("cannot open graphic font"); return;}
	GRF=(byte*) malloc(40000);
	if (GRF==NULL) {puts("cannot allocate memory for graphic fonts");return;}
	fread(GRF,1,37664,f);
	fclose(f);
		                  
	                  
	                  
	//read ϼ->  ڵǥ  
	FILE* code;
	
	KSC=(byte*)malloc(20000);
	code=fopen(CODE_TABLE_NAME,"rb");
	if (KSC==NULL) {MessageBox(0,"Cannot seize memory for KSC code","error",0);return;}
	if (code==NULL) {MessageBox(0,"Cannot open code table","error",0);}
	fread(KSC,1,17672,code);
	fclose(code);             
	
	KSSM=(byte*)malloc(20000);
	code=fopen(CODE_TABLE2_NAME,"rb");
	if (KSSM==NULL) Say("%s","cannot seize memory for KSSM code");
	if (code==NULL) Say("%s","cannot open code2 table");
	fread(KSSM,1,17672,code);
	fclose(code);
	
	szLetter=(char*)malloc(LETTER_SIZE);
	if (szLetter==NULL) Say("%s","cannot seize memory for szLetter");
	
	szScreen=(char*)malloc(SCREEN_SIZE); //virtual screen
	if (szScreen==NULL) Say("%s","cannot seize memory for szScreen");
	
	szPocket=(char*)malloc(POCKET_SIZE);
	if (szPocket==NULL) Say("cannot seize szPocket");
	
	szBuffer=(char*)malloc(BUFFER_SIZE);
	if (szBuffer==NULL) Say("cannot seize szBuffer");

	szTalk=(char*)malloc(TALK_SIZE);
	if (szTalk==NULL) Say("cannot seize szTalk");	
	
	szPrint=(char*)malloc(BUFFER_SIZE);//ѱ  
	if (szPrint==NULL) Say("cannot seize szPrint");
	
}
byte DOT_MASK[8]= {
	128,64,32,16,
	8,4,2,1
};

void put_image(int x,int y,byte* buffer,int width)
{
	int i,j,k=-1;
	
	for (j=0;j<16;j++) {
		for (i=0;i<width;i++) {
		if (i==0 || i==8) k++;
		if (buffer[k] & DOT_MASK[i%8]  )  SetPixel(hDC,i+x, j+y, RGB(0,0,0));
	
		}

	}
}

void put_eng(int x,int y, byte munja)
{
		int i;
		byte buffer[16];
		for (i=0;i<16;i++) {
		buffer[i]=EF[munja][i];
		}
		put_image(x*8,y*16,buffer,8);
}

void make_image(byte* src, byte* dst)
{
	int i;
	for (i=0;i<32;i++) {
	dst[i] |= src[i];
	}

}        
void put_grf(int x,int y,hangul munja)
{
	int first,second,w;
	first=munja.word.first;
	second=munja.word.second;
	
	
    if (first==217 && (second>=50 && second<=126) ) w=second-50 + 125;
    else if (first==217 && (second>=145 && second<=229) ) w=second-145+202;
    else if (first==218 && (second>=49 && second<=126) ) w=second-49+ 287;
    else if (first==218 && (second>=145 && second <=254)) w=second-145+365;
    else if (first==219 && (second>=49 && second <= 126)) w=second-49+475;
    else if (first==219 && (second >= 145 && second <= 228)) w=second-145+553;
    else if (first==220 && (second >= 49 && second <= 126)) w= second -49+ 637;
    else if (first==220 && (second >=145 && second <= 254)) w= second-145+715;
    else if (first==221 && (second >= 49 && second <= 126)) w=second-49+ 825;
    else if (first ==221 && (second >= 145 && second <= 243)) w=second-145+903;
    else if (first ==222 && (second >=49 && second <=126)) w=second-49+1002;
    else if (first ==222 && (second >=145 && second <=152)) w=second-145+1080;
    else if (first ==222 && (second >=161 && second <=193)) w=second-161+1096;
    else if (first==222 && (second >=209 && second <= 241)) w=second-209+1144;

    put_image(x*8,y*16,GRF+w*32,16);

} 

void put_hanja(int x, int y, hangul munja)
{
	int first=munja.word.first, second= munja.word.second;
	long int w=0; 
	
	w=(first-224)*188;
	if (second>=49 && second <=126) w+= second-49+ 0 ;
	else if (second>=145 && second <=254) w+=second-145+ 78;
	else return;
	
	
	FILE* f;
	byte buffer[40];
	int size;
	f=fopen(HANJA_FONT_NAME,"rb");
	if (f==NULL) {puts("cannot read hanja font");return;}
	fseek(f,w*32+32,SEEK_SET);
	size=fread(buffer,1,32,f);
    put_image(x*8,y*16,buffer,16);


	fclose(f);	
}
void put_han(int x,int y,hangul munja)
{
	//int i;
	byte buffer[32];
	int chosung,jungsung,jongsung;
	int b1,b2,b3; /* bulsu */

	memset(buffer,0,32);

	chosung=CON_HF[0][munja.code.chosung];
	jungsung=CON_HF[1][munja.code.jungsung];
	jongsung=CON_HF[2][munja.code.jongsung];

	if (jongsung) {
	b2=JUNGSUNG[1][chosung];
	b1=CHOSUNG[1][jungsung];
	}
	else {
	b2=JUNGSUNG[0][chosung];
	b1=CHOSUNG[0][jungsung];
	 }
	b3=JONGSUNG[jungsung];

	if (chosung) make_image(HF1[b1][chosung], buffer);
	if (jungsung) make_image(HF2[b2][jungsung], buffer);
	if (jongsung) make_image(HF3[b3][jongsung], buffer);
	put_image(x*8,y*16,buffer,16); //16 is width
}                                   

            

void hprintf(int x,int y,char* fmt, ...) //ϼ ѱǥ
{
    va_list argptr;
    va_start(argptr,fmt);
    vsprintf(szPrint,fmt, argptr);
    va_end(argptr); 
    
	byte* p=(byte*)szPrint;
	byte a;
	hangul b;
	int b2;

	while ( *p != NULL ) {
	a=*p;
	b.word.first=*p  ,   b.word.second=*(p+1);
	p++;
	if (a&0x80) { //hangul
	//ϼ->  
	b2=((b.word.first-0xa1)*0x5e + b.word.second-0xa1)*2;
	
	b.word.first=*(KSC+b2), b.word.second=*(KSC+b2+1);	
	                                            
	if (b.word.first>=217 && b.word.first <=222) put_grf(x,y,b);
	else if (b.word.first>=224 && b.word.first <= 249) put_hanja(x,y,b);
	else put_han(x,y,b);

	x+=2;
	p++;
	}           
	else  //english
	{
	if (a=='\n') {y++;}
	else if (a=='\r') {x=0;}
	else {put_eng(x,y,a);x+=1;}
	}
	}
}


void h2printf(int x,int y,char* fmt, ...) // ѱ ǥ
{   
     
    va_list argptr;
    va_start(argptr,fmt);
    vsprintf(szPrint,fmt, argptr);
    va_end(argptr); 
    
	byte* p=(byte*)szPrint;
	byte a;
	hangul b;
                         

	//erase first              
	/*
    SelectObject(hDC,GetStockObject(WHITE_PEN));
    SelectObject(hDC,GetStockObject(WHITE_BRUSH));
    Rectangle(hDC,x*8,y*16,(x+strlen(BUFFER))*8,y*16+15);
      */
      
	while ( *p != NULL ) {
	a=*p;
	b.word.first=*p  ,   b.word.second=*(p+1);
	p++;
	
	if (a&0x80) { //hangul
	
	if (b.word.first>=217 && b.word.first <=222) put_grf(x,y,b);
	else if (b.word.first>=224 && b.word.first <= 249) put_hanja(x,y,b);
	else 	put_han(x,y,b);
	x+=2;
	p++;
	}         
	else  //english
	{
	if (a=='\n') {y++;}
	else if (a=='\r') {x=0;}
	else {
	put_eng(x,y,a);
	x+=1;}
	}
	}
}      
           
void hprint(int x,int y,char* BUFFER) // ѱ ǥ , ܼ  
{   
     
	byte* p=(byte*)BUFFER;
	byte a;
	hangul b;
                         

	//erase first              
	/*
    SelectObject(hDC,GetStockObject(WHITE_PEN));
    SelectObject(hDC,GetStockObject(WHITE_BRUSH));
    Rectangle(hDC,x*8,y*16,(x+strlen(BUFFER))*8,y*16+15);
      */
      
	while ( *p != NULL ) {
	a=*p;
	b.word.first=*p  ,   b.word.second=*(p+1);
	p++;  
	
	if (a&0x80) { //hangul
	
	if (b.word.first>=217 && b.word.first <=222) put_grf(x,y,b);        
	else if (b.word.first>=224 && b.word.first <= 249) put_hanja(x,y,b);
	else put_han(x,y,b);

	x+=2;
	p++;
	}           
	else  //english
	{
	if (a=='\n') {y++;}
	else if (a=='\r') {x=0;}       
	else {
	
	put_eng(x,y,a);
	x+=1;}
	}
	}
}      
                         

//edit hangul 

     
int complete_munja(void)
{
	hangul a;
	a.code.chosung=han[0];
	a.code.jungsung=han[1];
	a.code.jongsung=han[2];
	a.code.is_hangul=1;

	//INVISIBLE CHECK
	if (
	!(
	(a.code.chosung==FILL0 ||a.code.chosung==BLK0) &&
	(a.code.jungsung==FILL1 || a.code.jungsung==BLK1) &&
	(a.code.jongsung==FILL2 || a.code.jongsung==BLK2)
	)
	)
	{
	*(szMain+CurP)=a.word.first;
	*(szMain+CurP+1)=a.word.second;
	}

	
	
	if (  CurP+2<=MainP )   // XX0
	{
	CurP+=2;
	if (INS ) {insert (CurP);insert(CurP);}
	han[0]=BLK0;han[1]=BLK1;han[2]=BLK2;
	han_making=0;return 1;
	}
	else return 0;
}
      

int find_jongsung(int code)
{
	int i;
	for (i=0;i<19;i++) {
	if (cho2jong[i][0]==code) return cho2jong[i][1];

	}
	return 0;
}
int find_chosung(int code)
{
	int i;
	for (i=0;i<19;i++) {
	if (cho2jong[i][1]==code) return cho2jong[i][0];

	}
	return 0;
}
int find_jungsung(int c,int d)
{
	int i;
	for (i=0;i<7;i++) {
	if (jung2jung[i][0]==c && jung2jung[i][1]==d) return jung2jung[i][2];
	}
	return 0;
}


int find_boksa(int jong,int cho)  // , 
{
		int i;
        for (i=0;i<11;i++){
		if (boksa[i][0]==jong && boksa[i][1]==cho) return boksa[i][2];//
		}
		return 0;
}

void separate_boksa(int bok,int& jong,int& cho )    //  , 
{
	int i;
	for (i=0;i<11;i++) {
		if (boksa[i][2]==bok) {jong=boksa[i][0];cho=boksa[i][1];}
	}
}
int separate_jungsung(int bok,int& a)   //  , 
{
    int i;
    for (i=0;i<7;i++){
		if (jung2jung[i][2]==bok) {a=jung2jung[i][0];
            return 1;}
	}
    return 0;
}

int is_bokjung(int bok) {
    int i;
	for (i=0;i<7;i++){
    if (jung2jung[i][2]==bok) return 1;
    }
    return 0;
}

int is_boksa(int jong) {
	int i;
	for (i=0;i<11;i++) {
		if (boksa[i][2]==jong) return 1;
		}
		return 0;
}
int is_hangul(byte* BUFFER,int p) {
		int i=0;
		int b;
		while(1) {
		b=*(BUFFER+i);

		if (b>=' ' && b<='z') {i++;} //ascii code
		else i+=2; //hangul
		if (i>=p+1) break;
		}

		//  p = 6
				//      |          |                 |              |
				// ÷ȣ: 012345678         012345678      012345678
				// :     ȳϽP         ȳ  P      abc237P
				// P-2 6̴.
				// i=2+2+2+2=8                 i=2+2+1+2=7   i=3+2+2=7
				// p+1=6+1=7                   p+1=7         p+1=7
				// :ѱ̴              ̴        ̴
				// : p  (6÷) Ǿ ϹǷ 7 ų
				//     ũ  ´

				if (p+1==i) return 0; else return 1;//ѱ̸
						   //̸
}
int is_eng(byte* BUFFER,int p) {
	int a=*(BUFFER+p);
	if (a>=' ' && a<='z') return 1;
	return 0;
}
int is_ascii(byte a)
{
	if (a>=' ' && a<='z') return 1;
    return 0;
}

void do_consonant(int code)
{
		if (han[0]!=BLK0)  { //ʼ ϴ 
								if (han[2]!=BLK2 && find_boksa(han[2],code) ) // 
											//  ϴ
				{han[2]=find_boksa(han[2],code); }

				else if (han[2]!=BLK2 && !find_boksa(han[2],code) )
				//  ,   Ұ
				{
							   //ο ѱ ڰ ϴٸ
					if (complete_munja()) han[0]=code;}

				else if (han[2]==BLK2 && han[1]!=BLK1) // ϰ,߼ 
				{int a=find_jongsung(code);
                                if (a) han[2]=a; else {
								if (complete_munja()) han[0]=code;}
				} // ڵ带 

								else if (han[2]==BLK2 && han[1]==BLK1) //  ϰ ߼  ϸ
						   {han[2]=FILL2;han[1]=FILL1;
										if (complete_munja())
               han[0]=code;} //߼   ä


		}         //end of if ʼ ϴ 
		else { //ʼ  
                                if (han[0]==BLK0 ) {han[0]=code;}

				}
}
void do_vowel(int code)
{
                if (han[1]!=BLK1) { //߼  
						if (han[0]==BLK0) han[0]=FILL0;

		 int newjung=find_jungsung(han[1],code);

                                if (newjung && han[2]==BLK2) {han[1]=newjung;}
				//ο ߼ڵ尡 ,   Ѵ

				 // ο ߼ Ұϰ   
                                else if (!newjung && han[2]==BLK2) {
										han[2]=FILL2;
										if (complete_munja()) {
										han[0]=FILL0;
										han[1]=code; }

					}
                           else if (han[2]!=BLK2 && is_boksa(han[2]))
				//ο ߼ Ұ,ֽ
				 {  // ִٸ иŰ ο ڷ
				 int c,d; //  han[3] ֽ
				 separate_boksa(han[2],c,d); //  
								 han[2]=c;
                                 if (complete_munja() ) {
				 han[0]=d; //ùڷ  
                                 han[1]=code;}
			   }
                           else if (han[2]!=BLK2 && !is_boksa(han[2]))
			   //ο ߼ Ұ, ܼ  
			   {
			   int t;
                 t=find_chosung(han[2]);han[2]=BLK2;  //ռ  ƴ
				 if (complete_munja()) {
                 han[0]=t;han[1]=code;      }
			   }

				} //end of if ߼  


				else //߼  
		{

				if (han[0]==BLK0) han[0]=FILL0; //ʼ   ä ڵ
                han[1]=code;

		}

}
int delete_han(void) //ڼ 
{
        if (han[2]>=2 && !is_boksa(han[2])) {han[2]=BLK2;return 0;}

		else  //  
	if (han[2]>=2 && is_boksa(han[2])) {int jong,cho;
	separate_boksa(han[2],jong,cho);
	han[2]=jong;
	return 0;}

		else            //ܼ  
				if (han[1]>=3 && !is_bokjung(han[1]))
				{han[1]=BLK1;if (han[0]==FILL0) {han[1]=BLK1;return 1;} else return 0;}
		else
		if (han[1]>=3 && is_bokjung(han[1])) {int newjung;
		separate_jungsung(han[1],newjung);han[1]=newjung;return 0;}

		else
        if (han[0]>=2) {han[0]=BLK0;return 1;}
	return 1;
}
         
         
void insert(int p)
{
	int i;
	
	if (MainP+1>=MAXP) return;
   //NORMAIL INSERT
	MainP++;  //increase pointer
	for (i=MainP;i>=p+1;i--)  *(szMain+i)=*(szMain+i-1);
   
   *(szMain+p)=' '; 

	
}

int pull(int p)
{
	int i;
	if (MainP<=0) {*(szMain+0)= NULL;MainP=0;return -1;}
	if (p>=MainP) return -1;

	
	for (i=p;i<=MainP-1;i++)
	*(szMain+i)=*(szMain+i+1);
      
    MainP--;  
	*(szMain+MainP)=NULL;
	
	return 0;
}
    
    
    


int value(int a)
{
	char*ap=(char*)&a;

	int b;
	char* bp=(char*)&b;
	*(bp+0)=*(ap+1);
	*(bp+1)=*(ap+0);

	return b;
}
int value(char* ap)
{
	int b;
	char* bp=(char*)&b;
	*(bp+0)=*(ap+1);
	*(bp+1)=*(ap+0);

	return b;
}
int BISEARCH(char Table2[],int start,int end,char* key2)
{
	int key=value(key2);
	int* Table=(int*)Table2;
	int low,high,mid;
	low=start;
	high=end;

	while(low<=high) {
	mid=(low+high)/2;
	if (key>value(Table[mid])) low=mid+1;   //content: Table[mid]      K
							  // index:              low
	else if (key<value(Table[mid])) high=mid-1; //content: K      Table[mid]
							       //index:       high
	else if (key==value(Table[mid])) return mid;
	}
	return -1;
}                  



 void convert2(char * src)  //ϼ 
{
	int idx,i,l;
	unsigned char first;
	unsigned char  second;
	l=strlen(src);
	
	if (l<=1) return ; //if it is not hangul return!
	
	for (i=0;i<l;i++)
	{
	if (*(src+i)&0x80)
	{
	idx=(*(src+i)-0xa1)*0x5e + *(src+i+1)-0xa1;
	first=*(src+i);
	second=*(src+i+1);
	idx=(first-0xa1)*0x5e+second-0xa1;
	*(src+i)=*(KSC+idx*2);
	*(src+i+1)=*(KSC+idx*2+1);
	i++;
	}
	}                

}
         


void convert(char * src)  // ϼ
{
	int idx,i,l;
    int first;
	l=strlen(src);

	for (i=0;i<l;i++)
	{
	if (*(src+i)&0x80)
	{
    first=(int)((unsigned char)*(src+i));

    if (first>=217 && first <=222) //Ư
    idx=BISEARCH((char*)KSC,0,1114, (src+i));
    else if (first>=224 && first <= 249) //
    idx = BISEARCH((char*)KSC, 3854, 8741, (src+i) );
    else  idx=BISEARCH((char*)KSC,1410,3759,(src+i)); //ѱ

	if (idx==-1) {*(src+i)=*(src+i+1)='X'; } else{
	*(src+i)=*(KSSM+idx*2);
	*(src+i+1)=*(KSSM+idx*2+1);}
	i++;
	}


	}
}


void DecodeText(void)  //read text to editor
{  

	int i;
	int x;          
	int l=strlen(szLetter);
	char Line[200];    
	          
	                  
	//    Ѵ 
	NOTE.kill();
	                
	//set poistions of x,y
	x=0; 
	
	//decode	
	for (i=0;i<l;i++) {

	
	
	//ǵ   
	if ( 
	 (x==MAXP-2 && is_hangul((byte*)szLetter,i) )  ||
	 (x==MAXP-1 && is_hangul((byte*)szLetter,i) )  ||
	 (x>=MAXP-1 ) )
	 {                                   
	 
	 if (is_hangul((byte*)szLetter,i-4)) {  
	 Line[x-4]=NULL;
	 convert2(Line);NOTE.add(Line);x=0;i-=4;
	 
	 }
	 
	 else 
	 
	 {    //ٷ ٲ۴. 
	 if (szLetter[i-4] == ' ' || szLetter[i-3]==' ') 
	 {Line[x-3]=NULL;} else {Line[x-3]='-';Line[x-2]=NULL;}
	 i-=3; convert2(Line);NOTE.add(Line); x=0;
	 }
	     
	 
	 }
	
	if (x<=MAXP-1 && szLetter[i]!='\n' && szLetter[i]!='\r' && szLetter[i]!=9) 
	{Line[x]=szLetter[i];x++;}    
		//TAB ?
	if (szLetter[i]==9) {int i; for (i=0;i<=4;i++) {Line[x]=' ';x++;}}                       
		
	//  r ,  n <- the order
	
	if (szLetter[i]=='\n') {Line[x]=NULL;convert2(Line); NOTE.add(Line);x=0;}
	
	}	
	                     
	 //  Ȯϰ Է                     
	if (szLetter[i]!='\n') {Line[x]=NULL,convert2(Line); NOTE.add(Line);}	    
    	
		//cursor setting          ۾
    LineP=0;
    SLineP=0;          
    NOTE.movefirst();
	strcpy(szMain,NOTE.print());    
	MainP=strlen(szMain);
	CurP=0;    				    
	han_making=0;
    				   
						
}