#include <windows.h>
#include <windowsx.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <ctype.h> //for isalpha
#include <stdio.h>
#include <stdlib.h>
#include <string.h> //for memset
#include <io.h>             
#include <math.h> //for sin,cos
#include <stdarg.h>

#include "resource.h"  
#include "winsock.h"
                                        
#include "def.h" //type definition and other defines..
#include "ext.h"  // extern 
#include "pro.h" //prototypes 
      

Line::Line(char* s_)
{
strcpy(s,s_);
pre=NULL;
nxt=NULL;
}
Line::~Line(void)
{    
}
  
Note::Note(void)
{
	p=NULL;
}
void Note::update(char*src)
{
	Line* curl=p;
	strcpy(curl->s,src);
}
void Note::add(char* s_)
{
	Line* curl=p;

	if (p==NULL) //is it the first node ?
	{
	curl=p=new Line(s_);
	return;
	}


	while(1) {     //move to last node
	if (curl->nxt==NULL) break;
	curl=curl->nxt;
	}


	Line* newl= new Line(s_); //make a new node
	curl->nxt=newl; //connect the new node to the last node
	newl->pre=curl;
	
	p=newl;

}
char* Note::print(void)
{
	//puts(p->s);
	return p->s;
}
void Note::printn(int n)
{
	Line* curl=p;
	int i=0;
	while(1) {
	if (i==n) break;
	puts(curl->s); i++;
	if (curl->nxt==NULL) break;

	curl=curl->nxt;

	}
}
void Note::printall(void)
{
	Line* curl=p;

	while(1) {     //move to the first node
	if (curl->pre==NULL) break; //is it a first node?
	curl=curl->pre;
	}

	while(1) { //print each node
	//puts(curl->s);
	curl=curl->nxt;
	if (curl->nxt==NULL) break;
	}
	//puts(curl->s); //print last line

}
void Note::movenext(void)
{
	if (p->nxt) p=p->nxt;
}
void Note::moveprevious(void)
{
	if (p->pre) p=p->pre;
}
void Note::movefirst(void)
{
	Line* curl=p;
	while(1) {
	if (curl->pre==NULL) break;
	curl=curl->pre;
	}
	p=curl;
}
void Note::movelast(void)
{
	Line* curl=p;
	while(1) {
	if (curl->nxt==NULL) break;
	curl=curl->nxt;
	}
	p=curl;
}
void Note::moveto(int n)
{
	movefirst();

	Line* curl=p;
	int i=0;
	while(1) {
	p=curl;
	if (i==n) break;
	curl=curl->nxt , i++;
	}
}
void Note::kill(void)
{
	Line* curl=p;
	Line* newl;
	if (p==NULL) return;                        //there is no node to delete
	else 
	if (p->pre == NULL && p->nxt==NULL) {delete p; p=NULL; return;} //first node
	
	while(1) {     //move to the first node
	if (curl->pre==NULL) break;
	curl=curl->pre;
	}

	while(1) {
	newl=curl->nxt;
	delete curl;
	curl=newl;

	if (curl->nxt==NULL) break;
	}

	delete curl; //delete last line
	p=NULL;
}
        


void Note::del(void)
{
	if (p==NULL || (p->pre==NULL && p->nxt==NULL)) return ; //nothing to delete

	if (p->pre==NULL) // if it is the first node
	{
	Line* Cur=p;
	Line* Nxt=p->nxt;
	delete Cur;
	Nxt->pre=NULL;
	p=Nxt;
	return;
	}
	if (p->nxt==NULL)
	{
	Line* Pre=p->pre;
	Line* Cur=p;
	delete Cur;
	Pre->nxt=NULL;
	p=Pre;
	return;
	}



	Line* Cur=p;
	Line* Pre=p->pre;
	Line* Nxt=p->nxt;

	delete Cur;
	Pre->nxt=Nxt;
	Nxt->pre=Pre;
	p=Nxt;
}        

void Note::insert(char*s_)
{
	if (p==NULL) //it is the start of the Note..
	{
	p=new Line(s_); return;
	}

    if (p->pre==NULL) {
    Line* Cur=new Line(s_);
    Line* Nxt=p;
    Cur->nxt= p;
    Nxt->pre=Cur;

    p=Cur;
    return;
    }
    else {

	Line* Pre=p->pre;
	Line* Cur=new Line(s_);
	Line* Nxt=p;



	Pre->nxt=Cur;
	Cur->pre= Pre, Cur->nxt=Nxt;
	Nxt->pre=Cur;
	p=Cur;
    }
}

      
int Note::last(void)
{
	if (p->nxt==NULL) return 1;
	else return 0;
}
int Note::first(void)
{
	if (p->pre==NULL) return 1;
	else return 0;
}              

int Note::canprevious(void)
{
	if (p->pre) return 1;
	else return 0;
}

int Note::cannext(void)
{
	if (p->nxt) return 1;
	else return 0;
} 


int Note::tell(void)
{
    Line* Cur=p;
    movefirst();
    Line* Nxt=p;
    int i=0;
    while (1) {
    if (Nxt==Cur) break;
    Nxt=Nxt->nxt;
    i++;
    }

    p=Cur;
    return i;
}