/*
simple telent
by lee jong whan
project: winsock.lib
version: 0.1.17
date:1998.1.20.TUE
compiler: visual c++ 1.52
memory model: large
caution: modify USER_ID, USER_PASSWORD with yours.
compile: this package contains all files which are necessary to compile.
         use "tel.mak" as visual c++ 1.52's project file
         After PPP winsock connection, activate this program.
history: 1998.1.24 SAT : hangul routine added
              1.25 SUN : hangul editor added
              2.3  TUE : scroll mode added 
              2.5  THU : fast put-image added  
              2.6  FRI : SOURCE divided for fast compliling
              2.25 WED: graphic fonts added      
              2.26 THU: hanja fonts added, KSSM->KSC upgraded   
              			long sentence divider upgraded
*/
  
      

#include <windows.h>
#include <windowsx.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <ctype.h> //for isalpha
#include <stdio.h>
#include <stdlib.h>
#include <string.h> //for memset
#include <io.h>             
#include <math.h> //for sin,cos
#include <stdarg.h>
#include <commdlg.h>

#include "resource.h"  
#include "winsock.h"
                                        
#include "def.h" //type definition and other defines..
#include "ext.h"  // extern 
#include "pro.h" //prototypes 
      
      
//error report
void Say(char* fmt, ...)
{
    static char BUFFER[300];//for virtual list
    va_list argptr;
    va_start(argptr,fmt);
    vsprintf(BUFFER,fmt, argptr);
    va_end(argptr); 
	MessageBox(0,BUFFER,"report",0);    
}
              

WINAPI WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
	HWND hwnd;
	MSG Msg;
	WNDCLASS wndclass;
	if (!hPrevInstance) {
	wndclass.style=CS_HREDRAW|CS_VREDRAW;wndclass.lpfnWndProc=WndProc;wndclass.cbClsExtra=0; wndclass.cbWndExtra=0;
	wndclass.hInstance=hInstance;wndclass.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);wndclass.hbrBackground=GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName=MAKEINTRESOURCE(IDR_MENU1);wndclass.lpszClassName="TelnetWin";
	RegisterClass(&wndclass);
	}        
	
	ghInstance=hInstance;
	hwnd=CreateWindow("TelnetWin","Telnet for windows",WS_OVERLAPPEDWINDOW,0,0,640,479,NULL,NULL,hInstance,NULL);
	
	
	ShowWindow(hwnd,nCmdShow);
	readfont();//KSC,KSSM,szLetter  ⿡ . 
	
		
	//edit buffer initializing
	int i;
	char s[200];
	for (i=0;i<=ENDLINE;i++) {
	sprintf(s,"");
	strcpy(szLines[i],s);
	}
	
	//cursor setting          ۾
    LineP=0;
    SLineP=0;          
    strcpy(szLines[LineP],"\r"); //ù  
    NOTE.add("\r");
	strcpy(szMain,szLines[LineP]);    
	MainP=strlen(szMain);
	CurP=0;    				    
	han_making=0;
    				  
	
	
	
	UpdateWindow(hwnd);
	while(GetMessage(&Msg,NULL,0,0)) {
	TranslateMessage(&Msg);
	DispatchMessage(&Msg);
	}            
	  
	NOTE.kill(); // ũƮ Ʈ    
	free(KSC);//   
	free(KSSM);        
	free(GRF); //׷  ޸  
	free(szLetter);
	free(szScreen);
	free(szPocket);
	free(szBuffer);
	free(szTalk);
	free(szPrint);
	return Msg.wParam;	
}       


LRESULT CALLBACK WndProc(HWND hwnd,UINT Message,UINT wParam,LONG lParam)
{ 
	FARPROC pDlg;//dialog far procedure

	
		
	switch(Message) {            
	case WM_KEYUP: OnSysKeyUp(hwnd, wParam, lParam); return TRUE;
	case WM_KEYDOWN: OnSysKeyDown(hwnd, wParam,lParam); return TRUE;
	case WM_CHAR: OnKey(hwnd,wParam,lParam);return TRUE;
	
	
	
	case WM_COMMAND: switch(wParam) {       
				case ID_TELNET_SET:    
				 //޴ ٲ۴ 
				{                
				HMENU hMain, hSub;
				hMain=GetMenu(hwnd);
				hSub=GetSubMenu(hMain,1);
				EnableMenuItem(hSub,1,MF_BYPOSITION | MF_ENABLED);
				EnableMenuItem(hSub,2,MF_BYPOSITION | MF_ENABLED);
				EnableMenuItem(hSub,3,MF_BYPOSITION | MF_ENABLED);
				}   
					{HMENU hMain,hSub;
				hMain=GetMenu(hwnd); if (hMain==NULL) Say("no menu");
				hSub=GetSubMenu(hMain,2);if(hSub==NULL) Say("no submenu");
				EnableMenuItem(hSub, 1, MF_BYPOSITION | MF_GRAYED );
				EnableMenuItem(hSub, 2, MF_BYPOSITION | MF_GRAYED );
				}

								

				
				
				TELNET_MODE=1; strcpy(szScreen,"START TELNET"); ReadType(hwnd,F2_KEY);
				
				break;
				
				case ID_EDIT_SET: 
				//޴ ٲ۴. 
				{HMENU hMain,hSub;
				hMain=GetMenu(hwnd); if (hMain==NULL) Say("no menu");
				hSub=GetSubMenu(hMain,1);if(hSub==NULL) Say("no submenu");
				EnableMenuItem(hSub, 1, MF_BYPOSITION | MF_GRAYED );
				EnableMenuItem(hSub, 2, MF_BYPOSITION | MF_GRAYED );
				EnableMenuItem(hSub, 3, MF_BYPOSITION | MF_GRAYED);
				}  
				{HMENU hMain,hSub;
				hMain=GetMenu(hwnd); if (hMain==NULL) Say("no menu");
				hSub=GetSubMenu(hMain,2);if(hSub==NULL) Say("no submenu");
				EnableMenuItem(hSub, 1, MF_BYPOSITION | MF_ENABLED );
				EnableMenuItem(hSub, 2, MF_BYPOSITION | MF_ENABLED );
				}

				
				
				TELNET_MODE=0; InvalidateRect(hwnd,NULL,TRUE);
	                UpdateWindow(hwnd);         
	                
	                
	                
				break;
	
				case ID_TELNET_CONNECT: if (TELNET_MODE) connect_server(); else Say("you are in the edit mode");
				break;       
				
				case ID_TELNET_CANCEL:
				if (!TELNET_MODE) {Say("you are in the edit mode");break;}
						if (WSAIsBlocking()) 
					   {re=WSACancelBlockingCall();if (re!=0) MessageBox(0,error_WSACancelBlockingCall(WSAGetLastError()),"error",0);else MessageBox(0,"WSACancelBlockingCall OKAY","check",0);}
					   break;
						   
				
				case ID_TELNET_DISCONNECT:
				if (!TELNET_MODE) {Say("You are in the edit mode");break;}
				re=closesocket(s); if (re==0) MessageBox(0,"SOCKET CLOSED","success",0); else MessageBox(0,error_closesocket(WSAGetLastError()),"error",0);
						gg=WSACleanup(); if (gg==WSANOTINITIALISED) {MessageBox(0,"cannot initialize .. try again","error",0);return -1;}
						re=shutdown(s,2); if (re==0) MessageBox(0,error_shutdown(WSAGetLastError()),"result",0); else MessageBox(0,"cannot shutdown","error",0);
				break;
	
							case ID_EDIT_READ:
							read_file(hwnd);
						break;                
						
						case ID_EDIT_WRITE:
						write_file(hwnd);
						break;
					
	        		case ID_FILE_CFG: 
	        		pDlg=(DLGPROC)MakeProcInstance((FARPROC)CfgDlgProc,ghInstance);
	        		DialogBox(ghInstance,MAKEINTRESOURCE(IDD_CFG),hwnd,pDlg);
	        		FreeProcInstance(pDlg);
	        		break;
			
					case ID_FILE_POP:
					pDlg=(DLGPROC)MakeProcInstance((FARPROC)PopDlgProc,ghInstance);
					DialogBox(ghInstance,MAKEINTRESOURCE(IDD_POP),hwnd,pDlg);
					FreeProcInstance(pDlg);  
					hDC=GetDC(hwnd);
					//show hangul 
					InvalidateRect(hwnd,NULL,TRUE);
	                UpdateWindow(hwnd);
					
					break;
	
	
					 case ID_FILE_SMTP: 
					 ReadType(hwnd,27);//read letter file
					 pDlg=(DLGPROC)MakeProcInstance((FARPROC)SmtpDlgProc, ghInstance);
					 DialogBox(ghInstance,MAKEINTRESOURCE(IDD_SMTP),hwnd,pDlg);
					 FreeProcInstance(pDlg);
					 hDC=GetDC(hwnd); //̽ ؽ ٽ ´
					 //show hangul 
					InvalidateRect(hwnd,NULL,TRUE);
	                UpdateWindow(hwnd);
					
					 break;   
					case ID_FILE_TALK:
					ReadType(hwnd,27);//read letter file
					pDlg=(DLGPROC)MakeProcInstance((FARPROC)DlgProc, ghInstance);
					DialogBox(ghInstance,MAKEINTRESOURCE(IDD_TELNET),hwnd,pDlg);
					FreeProcInstance(pDlg); 
					break;
														
	 				case ID_FILE_EXIT: PostQuitMessage(0);break;
					 }break;
	case WM_CREATE: 
	LoadInfo();
	SendMessage(hwnd,WM_COMMAND, ID_EDIT_SET,0 );
	break;
	    
	case WM_DESTROY: PostQuitMessage(0);return 0;
	
	case WM_PAINT:  
	OnPaint(hwnd); break;
	
	}
	return DefWindowProc(hwnd,Message,wParam,lParam);
}
                            
                            
LRESULT CALLBACK DlgProc(HWND hDlg, UINT Message, WPARAM wParam, LPARAM lParam)
{                   
	hwndScr=GetDlgItem(hDlg,IDC_SCREEN);
	hwndChk=GetDlgItem(hDlg,IDC_CHECK);
	hwndHan=hDlg;
	
	switch( Message) {
	case WM_INITDIALOG:       
	strcpy(szScreen,"Telnet for Windows \n\rcoded by lee jong whan");
	
	return TRUE;   
	
	
	case WM_PAINT: OnPaintTelnet(hDlg);break;
	case WM_COMMAND: switch(wParam) {        
						
	
	                    case IDC_HANGUL:   
	                    InvalidateRect(hDlg,NULL,TRUE);
	                    UpdateWindow(hDlg);
	                   
	                    break;
					     
						
						case IDC_CONNECT:
						connect_server();
						break; 
						
						case IDC_CB:
						if (WSAIsBlocking()) 
					   {re=WSACancelBlockingCall();if (re!=0) MessageBox(0,error_WSACancelBlockingCall(WSAGetLastError()),"error",0);else MessageBox(0,"WSACancelBlockingCall OKAY","check",0);}
					   break;
						   
						case IDC_QUIT:
						re=closesocket(s); if (re==0) MessageBox(0,"SOCKET CLOSED","success",0); else MessageBox(0,error_closesocket(WSAGetLastError()),"error",0);
						gg=WSACleanup(); if (gg==WSANOTINITIALISED) {MessageBox(0,"cannot initialize .. try again","error",0);return -1;}
						re=shutdown(s,2); if (re==0) MessageBox(0,error_shutdown(WSAGetLastError()),"result",0); else MessageBox(0,"cannot shutdown","error",0);
						break;

						
						case IDC_SEND: 
    				   hwndIn=GetDlgItem(hDlg,IDC_EDIT3);
    				   SendMessage(hwndIn,WM_GETTEXT,BUFFER_SIZE,(LPARAM)((LPSTR)szBuffer));
    				   talk(szBuffer);hear("IDC_SENTED"); hear("WAIT");
                       break;      
                       case IDC_ENTER: talk(" "); hear("IDC_ENTER"); hear("WAIT");break;
				       case IDC_ID:talk(szID); hear("IDC_ID"); 
				       SendMessage(hwndChk,WM_SETTEXT,0,(LPARAM)(LPSTR)"SENDING ID");
				       break;
                       case IDC_PASS: talk(szPASSt);hear("IDC_PASS");break;
                       case IDC_REDRAW: talk("z"); hear("IDC_REDRAW");break;
                       case IDC_TOP:talk("T");hear("IDC_TOP"); hear("WAIT");break;
                       case IDC_ABOVE: talk("A");hear("IDC_ABOVE");hear("WAIT");break;
                       case IDC_NEXT: talk("N");hear("IDC_NEXT");hear("WAIT");break;
                       case IDC_BACK: talk("B");hear("IDC_BACK");hear("WAIT");break;
                       case IDC_PREVIOUS: talk("P");hear("IDC_PREVIOUS");hear("WAIT");break;
                       
                       case IDC_RECEIVE: hear("IDC_RECEIVE");
                       break;
    
						case IDC_EDIT3:     
						
						break;						
						
						case IDCANCEL: break;
						case IDOK:
						EndDialog(hDlg,IDOK);return TRUE;
					 }        
					 break;
	}
	return FALSE;
}                            
                                    


void abc(char *p)
{
FILE *fp=fopen("z.txt","a+");
fprintf(fp,"%s",p);
fclose(fp);
           
}                         

void talk(char *a )
{  
	sprintf(szTalk,"talking: %s",a);
    SendMessage(hwndChk,WM_SETTEXT,0,(LPARAM) (LPSTR) szTalk);

	send(s,a,strlen(a),0);
	s1[0]=0x0d;s1[1]=0x0a; 
	send(s,s1,2,0);
	sprintf(szTalk,"<talk %s>",a);
	abc(szTalk);         
	
	

}

void hear(char *a) 
{                 
	static char szHear[500];
	sprintf(szHear,"hearing: %s",a);
SendMessage(hwndChk,WM_SETTEXT,0,(LPARAM) (LPCSTR) szHear);
		

ii=recv(s,cc,sizeof(cc),0);
sprintf(aa,"<%s received %d bytes>",a,ii);
abc(aa);             
szScreen[0]=0;
for ( jj = 1;jj<= ii; jj++)
{
sprintf(aa,"%c",cc[jj-1]);
abc(aa);      
strcat(szScreen,aa);
}                   

SendMessage(hwndScr,WM_SETTEXT,0,(LPARAM) (LPCSTR) szScreen);						                        





}

int connect_server(void)
{
gg=WSAStartup(0x0101,&ws);
if (gg!=0) {MessageBox(0,error_WSAStartup(WSAGetLastError()),"error",0);return -1;}

SendMessage(0,hwndChk,0,(LPARAM) (LPSTR) "try to open socket");
s = socket(AF_INET,SOCK_STREAM,0);
if (s==INVALID_SOCKET) {MessageBox(0,error_socket(WSAGetLastError()),"error",0);return -1;}

A.sin_family = AF_INET;
A.sin_port = htons(23);

SendMessage(0,hwndChk,0,(LPARAM) (LPSTR) "try to get host name");
H=gethostbyname(szSERVERt);
if (H==NULL) {MessageBox(0,"cannot get host","error",0); return-1;}
            
A.sin_addr.s_addr=*((unsigned long *) H->h_addr);


SendMessage(0,hwndChk,0,(LPARAM) (LPSTR) "try to connect");
d=connect(s,(struct sockaddr *)&A,sizeof(A));
if (d!=0) {MessageBox(0,"cannot connect","error",0);}
                                                          
s1[0]= (unsigned char) 0xff;s1[1]=(unsigned char) 0xfb;s1[2]=(unsigned char)0x18;
send(s,s1,3,0);
s1[0]= (unsigned char) 0xff;s1[1]=(unsigned char) 0xfc;s1[2]=(unsigned char) 0x20;
send(s,s1,3,0);
s1[0]= (unsigned char) 0xff;s1[1]=(unsigned char) 0xfc;s1[2]=(unsigned char) 0x23;
send(s,s1,3,0);
s1[0]= (unsigned char) 0xff;s1[1]=(unsigned char) 0xfc;s1[2]=(unsigned char) 0x24;
send(s,s1,3,0);

hear("CONNECT 1");
s2[0]=(unsigned char) 0xff;s2[1]=(unsigned char) 0xfa;s2[2]=(unsigned char) 0x18;s2[3]=0x0;s2[4]=0x76;s2[5]=(unsigned char) 0x74;
s2[6]=(unsigned char) 0x31;s2[7]=(unsigned char)0x30;s2[8]=(unsigned char)0x30;s2[9]=(unsigned char)0xff;s2[10]=(unsigned char)0xf0;
send(s,s2,11,0);

hear("CONNECT 2");
s1[0]= (unsigned char)0xff;s1[1]=(unsigned char)0xfd;s1[2]=(unsigned char)0x03;
send(s,s1,3,0);
s1[0]= (unsigned char)0xff;s1[1]=(unsigned char)0xfb;s1[2]=(unsigned char)0x01;
send(s,s1,3,0);
s1[0]= (unsigned char)0xff;s1[1]=(unsigned char)0xfc;s1[2]=(unsigned char)0x1f;
send(s,s1,3,0);
s1[0]= (unsigned char)0xff;s1[1]=(unsigned char)0xfe;s1[2]=(unsigned char)0x05;
send(s,s1,3,0);
s1[0]= (unsigned char)0xff;s1[1]=(unsigned char)0xfc;s1[2]=(unsigned char)0x21;
send(s,s1,3,0);

hear("CONNECT 3");
s1[0]= (unsigned char)0xff;s1[1]=(unsigned char)0xfc;s1[2]=(unsigned char)0x01;
send(s,s1,3,0);
s1[0]= (unsigned char)0xff;s1[1]=(unsigned char)0xfd;s1[2]=(unsigned char)0x01;
send(s,s1,3,0);
s1[0]= 0x76;
send(s,s1,1,0); 

hear("Prepare");
hear("First");
talk(" ");
hear("Second");
hear("Third");
talk(szID);
hear("Fourth");
talk(szPASSt);
hear("Fifth");
hear(" ");


return 0;
} 



            
     
  
char* error_shutdown(int a)
{                        
if (a==WSANOTINITIALISED) return("shutdown: A successful WSAStartup() must occur before using this API.");
if (a==WSAENETDOWN) return("shutdown: The Windows Sockets implementation has detected that the network subsystem has failed.");
if (a==WSAEINVAL) return("shutdown: how is not valid.");
if (a==WSAEINTR) return("shutdown: The (blocking) call was canceled via WSACancelBlockingCall()");
if (a==WSAEINPROGRESS) return("shutdown: A blocking Windows Sockets operation is in progress.");
if (a==WSAENOTCONN) return ("shutdown: The socket is not connected (SOCK_STREAM only).");
if (a==WSAENOTSOCK) return ("shutdown: The descriptor is not a socket.");

return ("shutdown: error cause unknown");
}                                                                          
                                    
                           
                                    
char* error_closesocket(int a)
{
if (a==WSANOTINITIALISED) return("closesocket: A successful WSAStartup() must occur before using this API.");
if (a==WSAENETDOWN) return ("closesocket: The Windows Sockets implementation has detected that the network subsystem has failed.");
if (a==WSAENOTSOCK) return("closesocket: The descriptor is not a socket.");
if (a==WSAEINPROGRESS) return("closesocket: A blocking Windows Sockets call is in progress.");
if (a==WSAEINTR) return("closesocket: The (blocking) call was canceled via WSACancelBlockingCall().");
if (a==WSAEWOULDBLOCK) return("closesocket: The socket is marked as nonblocking and SO_LINGER is set to a nonzero timeout value.");
return ("closesocket: error cause unknown");

}                              


char* error_WSAStartup(int a)
{
if (a==WSASYSNOTREADY) return("WSAStartup: Indicates that the underlying network subsystem is not ready for network communication.");
if (a==WSAVERNOTSUPPORTED) return("WSAStartup:The version of Windows Sockets API support requested is not provided by this particular Windows Sockets implementation.");
if (a==WSAEINVAL) return("WSAStartup:The Windows Sockets version specified by the application is not supported by this DLL.");
return ("WSAStartup:error cause unknown");
}
                               
                               
char* error_socket(int a)
{
if (a==WSANOTINITIALISED) return("socket: A successful WSAStartup() must occur before using this API.");
if (a==WSAENETDOWN) return("socket:The Windows Sockets implementation has detected that the network subsystem has failed.");
if (a==WSAEAFNOSUPPORT) return("socket:The specified address family is not supported..");
if (a==WSAEINPROGRESS) return("socket:A blocking Windows Sockets operation is in progress.");
if (a==WSAEMFILE) return("socket:No more file descriptors are available.");
if (a==WSAENOBUFS) return("socket:No buffer space is available.  The socket cannot be created.");
if (a==WSAEPROTONOSUPPORT) return("socket:The specified protocol is not supported.");
if (a==WSAEPROTOTYPE) return("socket:The specified protocol is the wrong type for this socket.");
if (a==WSAESOCKTNOSUPPORT) return("socket:The specified socket type is not supported in this address family.");
return ("socket:error cause unknown"); 
 }


char* error_WSACancelBlockingCall(int a)
{                                                                
	if (a==WSANOTINITIALISED) return "socket: A successful WSAStartup() must occur before using this API.";
	if (a==WSAENETDOWN) return	"socket:The Windows Sockets implementation has detected that the network subsystem has failed.";
	if (a==WSAEINVAL) return "socket:Indicates that there is no outstanding blocking call.";                                    
	return ("socket:cause unknown");
} 
    
    BOOL CALLBACK CfgDlgProc(HWND hDlg, UINT Message, WPARAM wParam, LPARAM lParam)
    {   
    	
    	switch (Message) {
    	case WM_INITDIALOG:
    	hwndIn=GetDlgItem(hDlg,IDC_ID);SendMessage(hwndIn,WM_SETTEXT,0,(LPARAM)(LPSTR)szID);
    	hwndIn=GetDlgItem(hDlg,IDC_PASSWORDT);SendMessage(hwndIn,WM_SETTEXT,0,(LPARAM)(LPSTR) szPASSt);
    	hwndIn=GetDlgItem(hDlg,IDC_PASSWORDM);SendMessage(hwndIn,WM_SETTEXT,0,(LPARAM)(LPSTR) szPASSm);
    	hwndIn=GetDlgItem(hDlg,IDC_SERVERT); SendMessage(hwndIn, WM_SETTEXT,0,(LPARAM) (LPSTR) szSERVERt);
    	hwndIn=GetDlgItem(hDlg,IDC_SERVERM); SendMessage(hwndIn, WM_SETTEXT,0,(LPARAM) (LPSTR) szSERVERm);
    	hwndIn=GetDlgItem(hDlg,IDC_WD); SendMessage(hwndIn, WM_SETTEXT,0,(LPARAM) (LPSTR) szWD);
    	
    	return TRUE;
    	break;                                                
    	
    	case WM_COMMAND: switch( wParam) {
    					case IDOK: 
    					         
    					hwndIn=GetDlgItem(hDlg,IDC_ID);SendMessage(hwndIn,WM_GETTEXT,BUFFER_SIZE,(LPARAM) (LPSTR) szBuffer);strcpy(szID,szBuffer); 
    					hwndIn=GetDlgItem(hDlg,IDC_PASSWORDT);SendMessage(hwndIn,WM_GETTEXT,BUFFER_SIZE,(LPARAM) (LPSTR) szBuffer);strcpy(szPASSt,szBuffer);
    					hwndIn=GetDlgItem(hDlg,IDC_PASSWORDM);SendMessage(hwndIn,WM_GETTEXT,BUFFER_SIZE,(LPARAM) (LPSTR) szBuffer);strcpy(szPASSm,szBuffer);
    					hwndIn=GetDlgItem(hDlg,IDC_SERVERT);SendMessage(hwndIn,WM_GETTEXT,BUFFER_SIZE,(LPARAM) (LPSTR) szBuffer);strcpy(szSERVERt,szBuffer);
    					hwndIn=GetDlgItem(hDlg,IDC_SERVERM);SendMessage(hwndIn,WM_GETTEXT,BUFFER_SIZE,(LPARAM) (LPSTR) szBuffer);strcpy(szSERVERm,szBuffer);
    					hwndIn=GetDlgItem(hDlg,IDC_WD);SendMessage(hwndIn, WM_GETTEXT, BUFFER_SIZE, (LPARAM) (LPSTR) szWD);
    					
    					
    					SaveInfo();
    					EndDialog(hDlg,IDOK);
    					return TRUE;
    					}
    	break;
    	}     
    	return FALSE;
    }      
    
    
    int LoadInfo(void)
    {                         
    
    FILE* a=fopen("info.txt","rb");   
    if (a==NULL) {MessageBox(0,"cannot load information","error",0);return -1;}
    fread(szID,sizeof(szID),1,a);
    fread(szPASSt,sizeof(szPASSt),1,a);
    fread(szPASSm,sizeof(szPASSm),1,a);
    fread(szSERVERt,sizeof(szSERVERt),1,a);
    fread(szSERVERm,sizeof(szSERVERm),1,a);
    fread(szWD, sizeof(szWD),1,a);
    fclose(a);
    return 0;
    }       	     
    
    int SaveInfo(void)
    {
    FILE* a=fopen("info.txt","wb");
    if (a==NULL) {MessageBox(0,"cannot save information","error",0);return -1;}
    fwrite(szID,sizeof(szID),1,a);
    fwrite(szPASSt,sizeof(szPASSt),1,a);
    fwrite(szPASSm,sizeof(szPASSm),1,a);
    fwrite(szSERVERt,sizeof(szSERVERt),1,a);
    fwrite(szSERVERm,sizeof(szSERVERm),1,a);
    fwrite(szWD, sizeof(szWD),1,a);
    
    fclose(a);
    return 0;
    } 
    
 

          
void onSysKeyDown(HWND hwnd,WPARAM wParam, LPARAM lParam)
{   
	//for only special keys
	switch (wParam) {
	case 37: ReadType(hwnd, LEFT_ARROW); break;
	case 39: ReadType(hwnd, RIGHT_ARROW); break;
	case 46: ReadType(hwnd, DEL_KEY); break;
	case 45: ReadType(hwnd, INS_KEY);break;   
	case 38: ReadType(hwnd, UP_ARROW);break;
	case 40: ReadType(hwnd, DOWN_ARROW);break;
	case 16: SHIFT=1;ReadType(hwnd, DUMMY_KEY);break;      
	case 112: ReadType(hwnd, F1_KEY);break;
	case 113: ReadType(hwnd, F2_KEY);break; 
	}			
	
}          
void onSysKeyUp(HWND hwnd,WPARAM wParam, LPARAM lParam)
{   
	//for only special keys
	switch (wParam) {
	case 16: SHIFT=0;ReadType(hwnd, DUMMY_KEY);break;
	}			
	
}
               
void OnKey(HWND hwnd,WPARAM wParam, LPARAM lParam)  //WM_KEYDOWN
{    
		
	ReadType(hwnd, wParam); 
	
} 
                          
                          
void OnPaint(HWND hwnd)
{
	PAINTSTRUCT ps;
	
	

	hDC=BeginPaint(hwnd, &ps);
		       
	SelectObject(hDC,GetStockObject(WHITE_PEN));
	SelectObject(hDC,GetStockObject(WHITE_BRUSH));

	Rectangle(hDC,0,0,640,480); //ȭ . 

	
	ReadType(hwnd,F1_KEY); // ڸ ٽ  

 
	                   
	EndPaint(hwnd,&ps);
}
            
            
void OnPaintTelnet(HWND hwnd)
{  
    HDC temp=hDC;
    
	PAINTSTRUCT ps;
	hDC=BeginPaint(hwnd,&ps);
	hprintf(0,0,"%s",szScreen);
	EndPaint(hwnd,&ps);
	
	hDC=temp;
}           

void OnPaintSmtp(HWND hwnd)
{   
	PAINTSTRUCT ps;
	BeginPaint(hwnd,&ps);
	EndPaint(hwnd,&ps); 
 
}                         
 

void read_file(HWND hwnd)
{

		   
			OPENFILENAME ofn;
char szDirName[256];
char szFile[256], szFileTitle[256];
UINT  i, cbString;
char  chReplace;    /* string separator for szFilter */
char  szFilter[256];

/* Get the system directory name, and store in szDirName */
//GetSystemDirectory(szDirName, sizeof(szDirName));
strcpy(szDirName,szWD);

szFile[0] = '\0';
       
                                              
strcpy(szFilter, "Text Files(*.txt)|*.txt|Document Files(*.DOC)|*.doc|");
cbString = strlen(szFilter);


chReplace = szFilter[cbString - 1]; /* retrieve wildcard */

for (i = 0; szFilter[i] != '\0'; i++) {
    if (szFilter[i] == chReplace)
       szFilter[i] = '\0';
}

       
       



/* Set all structure members to zero. */

memset(&ofn, 0, sizeof(OPENFILENAME));

ofn.lStructSize = sizeof(OPENFILENAME);
ofn.hwndOwner = hwnd;
ofn.lpstrFilter = szFilter;
ofn.nFilterIndex = 1;
ofn.lpstrFile= szFile;
ofn.nMaxFile = sizeof(szFile);
ofn.lpstrFileTitle = szFileTitle;
ofn.nMaxFileTitle = sizeof(szFileTitle);
ofn.lpstrInitialDir = szDirName;
ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

if (GetOpenFileName(&ofn)) {
	FILE* src_file;
	char name[200];
	int size,read_size;
	strcpy(name, ofn.lpstrFile);
	
	src_file=fopen(name,"rb");
	if (src_file==NULL) {Say("cannot open");return;}	                                                
	fseek(src_file,0L,SEEK_END);
	size=(int)ftell(src_file);
	//Say("file size is %d ",size);
	fseek(src_file,0L,SEEK_SET);
	if (size>LETTER_SIZE) size=LETTER_SIZE;
	read_size=fread(szLetter,1,size,src_file);
	*(szLetter+read_size)=NULL; // ι ߰..
	
	//Say("%s",szLetter);
	DecodeText();    
	
		       
		hDC=GetDC(hwnd);	       
	SelectObject(hDC,GetStockObject(WHITE_PEN));
	SelectObject(hDC,GetStockObject(WHITE_BRUSH));

	Rectangle(hDC,0,0,640,480); //ȭ . 
	
	ReadType(hwnd,F1_KEY); //ȭ !
	fclose(src_file);
	
		

	
}


}                                      
           
                                     
                                     
  
                                         


void write_file(HWND hwnd)
{

		   
			OPENFILENAME ofn;
char szDirName[256];
char szFile[256], szFileTitle[256];
UINT  i, cbString;
char  chReplace;    /* string separator for szFilter */
char  szFilter[256];

/* Get the system directory name, and store in szDirName */

//GetSystemDirectory(szDirName, sizeof(szDirName));
strcpy(szDirName,szWD);

szFile[0] = '\0';
                   
                                             
strcpy(szFilter, "Text Files(*.txt)|*.txt|Document Files(*.DOC)|*.doc|");
cbString = strlen(szFilter);


chReplace = szFilter[cbString - 1]; /* retrieve wildcard */

for (i = 0; szFilter[i] != '\0'; i++) {
    if (szFilter[i] == chReplace)
       szFilter[i] = '\0';
}

       
       
                   

/* Set all structure members to zero. */

memset(&ofn, 0, sizeof(OPENFILENAME));

ofn.lStructSize = sizeof(OPENFILENAME);
ofn.hwndOwner = hwnd;
ofn.lpstrFilter = szFilter;
ofn.nFilterIndex = 1;
ofn.lpstrFile= szFile;
ofn.nMaxFile = sizeof(szFile);
ofn.lpstrFileTitle = szFileTitle;
ofn.nMaxFileTitle = sizeof(szFileTitle);
ofn.lpstrInitialDir = szDirName;
ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

if (GetSaveFileName(&ofn)) {
	FILE* dst_file;
	char name[200];
	int size;
	strcpy(name, ofn.lpstrFile);
	
	dst_file=fopen(name,"wb");
	if (dst_file==NULL) {Say("cannot open");return;}	                                                
	
	ReadType(hwnd,27); // ڷḦ  szLetter Ѵ 
	
	size=fwrite(szLetter,1,strlen(szLetter),dst_file);
	
	fclose(dst_file);
	
		

	
}


}           
                           
           
                                     
                                     
  
                                           