/*
	A* Path Finder Example

	Coded by Choi Yong Hui.

	ȳϼ...
	ø    ҽ øԵǾ ˼մϴ.
	 нδ ̱Ǯ~  ø ε ̳  Ǿ մϴ.
	߿Ѱ... ̰  α׷ ҽ Դϴ...
	״ и ̴ ׷ һ ߻ . . ˾Ƽ Ͻõ  ֽõ.
	BGIԼ  ̶..
	ó ǵʹ ʹ ... Ͻñ⿡  Ҳ.
	ҽ  ϼ..    ߽ϴ.

	 нδ ҽ ͳ 𿡼 Դϴ.
	ű  E-MAIL ּҰ ֻ...   ʿ.. Ͻñٶϴ..^^;
*/
#include <graphics.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#include "astar.h"

#define	XTN	640/TILESIZE 	// x Ÿ 
#define YTN	480/TILESIZE	// y Ÿ 

/* TILESIZE astar.h  32 defineǾִµ ׷ϱ X Ÿϰ 20 Y 480/32 ƽð? 
   ׸ ׹ؿ SHIFT TILESIZE 32ϰ쿡 2 5 32̴ϱ 5 ֽð.
   64ϰ쿡 6 . . . ƽð? */

void Initialize_Astar(void);				// A* ü ʱȭ.
void Initialize_Point(int ux, int uy, int hx, int hy);  // Cursor Chaser ġ ٲ۴.
void Terminate_Astar(void);	// A* .
void Initialize_TileMap(int value);	// Ÿϸ value  ʱȭѴ.
void DrawTileMap(void);		// Ÿϸ ȭ鿡 ׷ش.
void InitializeGraphicsMode(void);	// ׷ȸ ʱȭ
void ChaseCursor(void);		//  ã´.

typedef struct po{
int x;
int y;
}POINT;

POINT ptCursor;	// Ŀ ġ
POINT ptChaser;	// chaser ġ..< ϸ ̸   ϴ. ^^;>
POINT ptNextDest; // ٷ  ŸϿ شϴ ǥ ñ ǥ ƴϴ ϼ.

BOOL  cursor_move = FALSE;	// Ŀ ̵ߴ .   ߿ 켼.
BOOL  pushed_enter = FALSE;	// ͸  ã⸦  ߴ 

AstarPathfinder* Astar; // A* ü.
int Tile_Map[XTN*YTN];  // Ÿϸ. 1̸  0̸ ո.


void main(void)
{
	Initialize_Astar();
	InitializeGraphicsMode();
	Initialize_Point(100,100,639,479); //   Ƕʹ Cursor ġ.   Ƕʹ Chaser ġ
	Initialize_TileMap(0);		// Ÿϸ   վ´.
	while(1)
	{
		if(kbhit())	// ŰԷ .
		{
			int extended = 0;
			int c = getch();
			if(!c) extended = getch();

				if(extended) {
					switch(extended)
					{
						case 72: //UP		// Ŀ ̵
						cursor_move = TRUE;
						ptCursor.y-=8;	
						break;
						case 80: //DOWN
						cursor_move = TRUE;
						ptCursor.y+=8;
						break;
						case 75: //LEFT
						cursor_move = TRUE;
						ptCursor.x-=8;
						break;
						case 77: // RIGHT
						cursor_move = TRUE;
						ptCursor.x+=8;
						break;
					}
				}else{
					switch(c)
					{
						case 13: // ENTER  ã⸦ մϴ.
						pushed_enter = TRUE;
						break;
						case 32: // SPACE  Ŀ ġ شϴ Ÿϸ 1 ŷǸ鼭  ˴ϴ.
						Tile_Map[ptCursor.x/TILESIZE + (ptCursor.y/TILESIZE * XTN)] = 1;
						Initialize_Astar();	// ŷ  Ÿϸ A*ü Ű ٽ ʱȭմϴ.
						Initialize_Point(ptCursor.x,ptCursor.y,639,479); // Chaser ġ ٽ   ʱȭŵϴ.
						break;
						case 113:	// qŰ  ˴ϴ.
						closegraph();
						Terminate_Astar();
						exit(1);
						break;
						case 27:	// Ű κ ESC Ѵٴ° ..--;
						closegraph();
						Terminate_Astar();
						exit(1);
						break;
					}
				}
		}
		// Ŀ Ÿϸ   ߻ϴ  .. ^^;
		if(ptCursor.y<0) ptCursor.y = 0;
		if(ptCursor.y>479) ptCursor.y = 479;
		if(ptCursor.x<0) ptCursor.x = 0;
		if(ptCursor.x>639) ptCursor.x = 630;

		ChaseCursor();	//  ãϴ.
		cursor_move = FALSE;	// Ŀ ̵ ٷ ʱȭ.
		DrawTileMap(); // Ÿϸ ׸ϴ.
		putpixel(ptCursor.x, ptCursor.y, 10);	// Cursor ȭ鿡 ǥմϴ. <>

		putpixel(ptChaser.x, ptChaser.y, 15); // Chaser θ β ǥϱ 밡ٸ....<>
		putpixel(ptChaser.x+1, ptChaser.y, 15);
		putpixel(ptChaser.x+1, ptChaser.y+1, 15);
		putpixel(ptChaser.x, ptChaser.y+1, 15);
	}
}

void Initialize_Point(int ux, int uy, int hx, int hy)
{
	ptCursor.x = ux;
	ptCursor.y = uy;
	ptChaser.x = hx;
	ptChaser.y = hy;
	ptNextDest.x = hx;
	ptNextDest.y = hy;
}

void Initialize_TileMap(int value)
{
	// Ÿϸ ʱȭѴ.
	for(int i = 0; i<XTN*YTN; i++) Tile_Map[i] = value;
}

//  ã ԼԴϴ.
void ChaseCursor(void)
{
		// Ű ٸ ׶ Ŀġ ǥ  մϴ.
		if( pushed_enter && ptCursor.x < XTN*TILESIZE){
			// Astar Լ FreeTile Էµ ǥ شϴ Ÿϸ 
			//  ƴҶ 0 ƴѰ մϴ. < ޱ򸮴±...>
			if(!Astar->FreeTile(ptCursor.x,ptCursor.y))
			{ // ࿡ ΰ Ÿϸʿ 1 شϴ  콺 Ͱ ٸ
			  //  Xǥ شϴ Ʒ  ʷ Žؼ Ǹ 0̵Ǵ  ǥ մϴ. . . --;
				BOOL find_haha = FALSE;
				int tilexxxxxxx,tileyyyyyyy;
				tilexxxxxxx = ptCursor.x/TILESIZE;
				tileyyyyyyy = ptCursor.y/TILESIZE;

				for(;tileyyyyyyy<YTN;tileyyyyyyy++){
					if(Astar->FreeTile(tilexxxxxxx*TILESIZE, tileyyyyyyy*TILESIZE)) {
						find_haha = TRUE; break; }
				}
				if(!find_haha) for(;tileyyyyyyy>0	   ;tileyyyyyyy--) {
					if(Astar->FreeTile(tilexxxxxxx*TILESIZE, tileyyyyyyy*TILESIZE)) { find_haha = TRUE; break; }
					}

				// !!! ߿ NewPathԼ  ΰ Ƕʹ Chaser ġ ̰.
				//  ΰ Ƕʹ ǥԴϴ.
			
				Astar->NewPath(ptChaser.x,ptChaser.y,tilexxxxxxx*TILESIZE,tileyyyyyyy*TILESIZE); // ο ǥ .
				// ࿡   ִ(Astar->FreeTile() == TRUE)϶.
			} else Astar->NewPath(ptChaser.x,ptChaser.y,ptCursor.x,ptCursor.y);
		}

		// AstarŬ Ž Ǵ  θ ʷ ü ÿ Push ϴ.
		//   Pop ϴ   ǥ ˴ϴ.
		// Ž  ִ  Pushس ʷ popذ鼭
		// ȭ鿡  ϴ.
		// ׷ٺ Ÿϰ  Ǵµ..... װ  ϳ  ǰ ϱ...
		// ѹ pop  ptNextDest ϰ ptChaser ptNextDest ġϰԵɶ
		// ptChaser ̵Ű  ġϰ Ǿ. ٽ popؼ ptNextDest մϴ.

		// ReacheGoal() Լ ǥ  (̻ POPҰ ) 0 ƴѰ ˴ϴ.
		if (!Astar->ReachedGoal() && ptNextDest.x == ptChaser.x && ptNextDest.y == ptChaser.y) {	// ࿡ ǥ  Ͽ.
		Astar->PathNextNode();			// ũ帮Ʈ ̿ ÿ 带 Ű մϴ. 
		ptNextDest.x = Astar->NodeGetX();	
		ptNextDest.y = Astar->NodeGetY();
		}

		if(ptNextDest.x > ptChaser.x) {ptChaser.x++; if(ptChaser.x>=ptNextDest.x) ptChaser.x = ptNextDest.x;} //  ÷̾ ġ ǥġ  ʿ .
		if(ptNextDest.x < ptChaser.x) {ptChaser.x--; if(ptChaser.x<=ptNextDest.x) ptChaser.x = ptNextDest.x;} //  ÷̾ ġ ǥġ  ʿ .
		if(ptNextDest.y > ptChaser.y) {ptChaser.y++; if(ptChaser.y>=ptNextDest.y) ptChaser.y = ptNextDest.y;} //  ÷̾ ġ ǥġ  Ʒ .
		if(ptNextDest.y < ptChaser.y) {ptChaser.y--; if(ptChaser.y<=ptNextDest.y) ptChaser.y = ptNextDest.y;} //  ÷̾ ġ ǥġ  ʿ .

		pushed_enter = FALSE;
}



void Initialize_Astar(void)
{
	// A* ü ʱȭ
	if(!Astar) delete Astar;
	Astar = new AstarPathfinder(Tile_Map,XTN,YTN, 1); //  ù° ڴ Ÿϸ , ι² X Ÿϰ, Y Ÿϰ, ǵ  Ÿ 1̳ 0̳? ⼭ 0
}

void Terminate_Astar(void)
{
	// A* ü 峿
	delete Astar;
}

void InitializeGraphicsMode(void)
{
	// ׷ȸ ʱȭ.
	int gdriver = DETECT, gmode, errorcode;

	initgraph(&gdriver, &gmode, "");
	errorcode = graphresult();

	if (errorcode != grOk)  /* an error occurred */
	{
		printf("Graphics error: %s\n", grapherrormsg(errorcode));
		printf("Press any key to halt:");
		getch();
		exit(1);             /* return with error code */
	}
}

void DrawTileMap(void)
{

	setfillstyle(SOLID_FILL, 13);

	int i,j;
	for(i=0;i<XTN;i++)
		for(j=0;j<YTN;j++)
			if(Tile_Map[i+(j*XTN)] == 1) bar(i*TILESIZE, j*TILESIZE, (i+1)*TILESIZE, (j+1)*TILESIZE);
}

