#include <dgSys.h>
#include <dgDraw.h>
#include <dgImage.h>

int counter=0;
void timer_interrupt_function()
{
   counter++;
}

void dgMain()
{
	U8	option=0;
    U8  angle=0;
	U8	button, prevbutton=0;
	S32	width,height;

	dgSURFACE	*surface;

    dgSetScreenMode( DG_640x480 );
    dgDrawSetGlobalColor( 255,0,255 );

    dgSetTimerFunction( timer_interrupt_function );
    dgSetTimerHz( 256 );

	if( dgLoadBmp( "dgPIX.bmp", &surface )==dgFALSE ) return;
//	if( dgLoadBmpPal( "dgPIX.bmp","dgPIX.pal", &surface )==dgFALSE ) return;
//	if( dgLoadPcx( "dgPIX.pcx", &surface )==dgFALSE ) return;
//	if( dgLoadPcxPal( "dgPIX.pcx","dgPIX.pal", &surface )==dgFALSE ) return;
	dgSetTexture( surface );
	width  = dgGetSurfaceInfo( surface, DG_SURFACE_WIDTH );
	height = dgGetSurfaceInfo( surface, DG_SURFACE_HEIGHT );

	while( 1 ) 
	{
        button = dgGetButton( dgRIGHT_PLAYER );
		if( ((prevbutton&dgPLAY_A)==0) && ((button&dgPLAY_A)!=0) )	option = (option+1)%4;
		if( ((prevbutton&dgPLAY_B)==0) && ((button&dgPLAY_B)!=0) )	break;
		prevbutton = button;

		if( dgFrameSkip() )
		{
			dgClearScreen( 255, 255, 255 );
			dgClearZBuffer();

			dgSetDrawMode( DG_TEXTURE );
			dgDrawTexture( 20, 20, width, height, 0, 0, option );
		//	dgDrawStretchTexture( 20, 20, 280, 200, 0, 0, width, height, option );
		//	dgDrawCStretchTexture( 160, 130, 50, 50, 0, 0, width, height, width/2, height/2, option );
		//	dgDrawRotateTexture( 160, 130, 160,160,0,0,width, height, width/2, height/2, angle, option );
			angle++;
			
			dgSetDrawMode( DG_SHADE );
			dgDrawTexture( 160-2,130-2,4,4,0,0,0 );

			dgFlip();
		}
		dgReport("counter: %05d, time: %10f sec\n",counter,(float)dgGetSystemTime()/1024);
	}
}
