#include <dgSys.h>
#include <dgDraw.h>
#include <dgImage.h>

typedef struct tagANIMATION
{
	S16 x, y;
	S16 sx,sy;
	S32 aniframe;
	U8	flag;
	dgSURFACE	*surface;
} ANIMATION;

//  ִ ִϸ̼(AniTest.bmp)  ƾ.
void DrawAni( ANIMATION *ani )
{
	int tx,ty;
	U8	option=0;

	if( ani->flag & 0x01 )	option = DG_DRAW_FLIPH;
	if( ani->flag & 0x02 )	ty = 0;
	else					ty = 64;

	tx = ( (ani->aniframe>>3) % 4 ) * 64;

	dgSetTexture( ani->surface );
	dgDrawTexture( ani->x - ani->sx, ani->y - ani->sy, 
					64, 64, tx, ty, option );
}

void dgMain()
{
	U8	stick=0;
	U8	button, prevbutton=0;

	ANIMATION	anitest;

    dgSetScreenMode( DG_640x480 );
    dgDrawSetGlobalColor( 255,0,255 );
	dgSetTransparencyColor( 0, 255, 0 );
	dgSetDrawMode( DG_TEXTURE|DG_TRANSPARENCY );

	anitest.x = SCREEN_CX/2;
	anitest.y = SCREEN_CY/2;
	anitest.sx = 32;
	anitest.sy = 54;
	anitest.aniframe = 0;

	if( dgLoadBmp( "AniTest.bmp", &anitest.surface )==dgFALSE ) return;

	while( 1 ) 
	{
        button = dgGetButton( dgRIGHT_PLAYER );
		if( prevbutton==0 && button!=0 )	break;
		prevbutton = button;

		stick = dgGetStick( dgRIGHT_PLAYER );
		if( stick & dgPLAY_UP )
		{
			anitest.flag = 2;
			anitest.y--;
		}
		else 
		{
			anitest.flag = 0;
			if( stick & dgPLAY_DOWN ) anitest.y++;
		}
		if( stick & dgPLAY_RIGHT )
		{
			anitest.flag |= 1;
			anitest.x++;
		}
		else if( stick & dgPLAY_LEFT )
		{
			anitest.x--;
		}

		anitest.aniframe++;

		if( dgFrameSkip() )
		{
			dgClearScreen( 255, 255, 255 );
			dgClearZBuffer();

			DrawAni( &anitest );

			dgFlip();
		}
	}
}
