#include <dgSys.h>
#include <dgDraw.h>
#include <dgImage.h>

U8		*MidiData=NULL;
U32		MidiDataSize;

void LoadMidiFile( char* MidiFileName )
{
	dgFILE	fp;

	if( MidiData!=NULL ) dgFree( MidiData );
	MidiData = NULL;
	MidiDataSize=0;

	fp = dgfopen( MidiFileName, "rb" );
	if( fp==NULL )
	{
		dgReport( "ERROR: LoadMidi(%s)\n", MidiFileName );
		return;	
	}
	dgfseek( fp, 0, SEEK_END );
	MidiDataSize = dgftell( fp );
	dgfseek( fp, 0, SEEK_SET );
	
	MidiData = dgMalloc( MidiDataSize );
	if( MidiData == NULL ) 
	{
		dgReport( "ERROR: LoadMidi(%s): memory allocation error!!\n", MidiFileName );
		return;	
	}
	dgfread( MidiData, MidiDataSize, fp );
	dgfclose( fp );

	dgReport("LoadMidi (%s): %d\n",MidiFileName,MidiDataSize);
};

void PlayMidi()
{
	if( MidiData==NULL ) return;
	dgPlayMidi( MidiData, MidiDataSize );
	dgSetMidiMainVolume( 100 );
}

void dgMain()
{
	U16	colorR=0, colorG=0, colorB=0;
	U8	button, prevbutton=0;

    dgSetScreenMode( DG_640x480 );

	LoadMidiFile( "Midi.mid" );
	if( MidiData == NULL ) return;	

	while( 1 ) 
	{
        button = dgGetButton( dgRIGHT_PLAYER );
		if( prevbutton==0 && button!=0 )	break;
		prevbutton = button;

		if( dgGetMidiState( DG_MIDI_PLAY ) == 0 ) PlayMidi();

		colorR+=16;
		if( colorR> 255 ){ colorR=0; colorG+=16;}
		if( colorG> 255 ){ colorG=0; colorB+=16;}
		if( colorB> 255 )  colorB=0;

		if( dgFrameSkip() )
		{
			dgClearScreen( colorR, colorG, colorB );
			dgFlip();
		}
	}
}
