#ifndef _DGDRAW_H
#define _DGDRAW_H

#include "dgType.h"

#define DG_DRAW_FLIPH	0x01
#define DG_DRAW_FLIPV	0x02

void dgDrawSetGlobalAlpha( U8 alpha );
void dgDrawSetGlobalColor( U8 r, U8 g, U8 b );
void dgDrawSetGlobalZ( zFIX z );
void dgDrawSetGlobalW( wFIX w );

void dgDrawTexture( S16 x, S16 y, S16 dx, S16 dy, S16 tx, S16 ty, U8 option );
void dgDrawStretchTexture( S16 x, S16 y, S16 dx, S16 dy, 
                          S16 tx, S16 ty, S16 tdx, S16 tdy, U8 option );

void dgDrawTile( S16 x, S16 y, S16 dx, S16 dy, 
                 S16 tx, S16 ty, 
                 S16 mapx, S16 mapy, S16* map, U8 option );
void dgDrawStretchTile( S16 x, S16 y, S16 dx, S16 dy, 
                       S16 tx, S16 ty, S16 tdx, S16 tdy, 
                       S16 mapx, S16 mapy, S16* map, U8 option );

void dgDrawCStretchTexture( S16 x, S16 y, S16 dx, S16 dy, 
                           S16 tx, S16 ty, S16 tdx, S16 tdy, 
                           S16 tcx, S16 tcy, U8 option );
void dgDrawCStretchTile( S16 x, S16 y, S16 dx, S16 dy, 
                        S16 tx, S16 ty, S16 tdx, S16 tdy, 
                        S16 tcx, S16 tcy, 
                        S16 mapx, S16 mapy, S16* map, U8 option );

void dgDrawRotateTexture( S16 x, S16 y, S16 dx, S16 dy, 
                          S16 tx, S16 ty, S16 tdx, S16 tdy, 
                          S16 tcx, S16 tcy, U8 angle, U8 option );
void dgDrawRotateWindowTile( S16 x, S16 y, S16 dx, S16 dy, 
                             S16 tdx, S16 tdy, S16 cx, S16 cy, 
                             S16 tcx, S16 tcy, U8 angle, 
                             S16 mapx, S16 mapy, S16* map, U8 option );
#endif
