#ifndef _DG_KBD_H
#define _DG_KBD_H

#define _1       0x02   /*  1 ǡ                   */
#define _2       0x03   /*  2                        */
#define _3       0x04   /*  3                        */
#define _4       0x05   /*  4                        */
#define _5       0x06   /*  5                        */
#define _6       0x07   /*  6                        */
#define _7       0x08   /*  7                        */
#define _8       0x09   /*  8                        */
#define _9       0x0A   /*  9                        */
#define _0       0x0B   /*  0                        */
#define _MINUS   0x0C   /*  - ǡ                   */
#define _EQUAL   0x0D   /*  = ǡ                   */
#define _BACKSP  0x0E   /*  back space ǡ          */
#define _Q       0x10   /*  Q                        */
#define _W       0x11   /*  W                        */
#define _E       0x12   /*  E                        */
#define _R       0x13   /*  R                        */
#define _T       0x14   /*  T                        */
#define _Y       0x15   /*  Y                        */
#define _U       0x16   /*  U                        */
#define _I       0x17   /*  I                        */
#define _O       0x18   /*  O                        */
#define _P       0x19   /*  P                        */
#define _LPAREN  0x1A   /*  [                        */
#define _RPAREN  0x1B   /*  ]                        */
#define _A       0x1E   /*  A                        */
#define _S       0x1F   /*  S                        */
#define _D       0x20   /*  D                        */
#define _F       0x21   /*  F                        */
#define _G       0x22   /*  G                        */
#define _H       0x23   /*  H                        */
#define _J       0x24   /*  J                        */
#define _K       0x25   /*  K                        */
#define _L       0x26   /*  L                        */
#define _SEMI    0x27   /*  ;                        */
#define _QUATO   0x28   /*  '                        */
#define _BQUATO  0x29   /*  `  key                   */
#define _RSLASH  0x2B   /*  \  key                   */
#define _Z       0x2C   /*  Z                        */
#define _X       0x2D   /*  X                        */
#define _C       0x2E   /*  C                        */
#define _V       0x2F   /*  V                        */
#define _B       0x30   /*  B                        */
#define _N       0x31   /*  N                        */
#define _M       0x32   /*  M                        */
#define _COMMA   0x33   /*  ,                        */
#define _DOT     0x34   /*  .                        */
#define _SLASH   0x35   /*  / key                    */
#define _SPACE   0x39   /*  space barkey             */

#define _F1      0x3B   /*  Function  1 key          */
#define _F2      0x3C   /*  Function  2              */
#define _F3      0x3D   /*  Function  3              */
#define _F4      0x3E   /*  Function  4              */
#define _F5      0x3F   /*  Function  5              */
#define _F6      0x40   /*  Function  6              */
#define _F7      0x41   /*  Function  7              */
#define _F8      0x42   /*  Function  8              */
#define _F9      0x43   /*  Function  9              */
#define _F10     0x44   /*  Function 10              */
#define _F11     0x57   /*  Function 11              */
#define _F12     0x58   /*  Function 12              */

#define _RET     0x1C   /* Return or Enter key       */
#define _TAB     0x0F   /* Tab key                   */

#define _LSHIFT  0x2A   /* Left Shift Key            */
#define _RSHIFT  0x36   /* Right Shift Key           */

#define _LCTRL   0x1D   /* Left Control key          */
#define _RCTRL   0x1D   /* Right Control key         */

#define _LALT    0x38   /* Left  Alternate key       */
#define _RALT    0x38   /* Right Alternate key       */

#define _PRTSCR  0x37   /* print screen              */
#define _SCRLOCK 0x46   /* scroll lock               */
#define _PAUSE   0x45   /* pause                     */
#define _NUMLOCK 0x45   /* num lock                  */
#define _CAPLOCK 0x3A   /* caps lock                 */

#define _INS	 0x52   /* insert                    */
#define _DEL	 0x53   /* delete                    */
#define _HOME    0x47   /* home                      */
#define _END	 0x4F   /* end                       */
#define _PGUP    0x49   /* page up                   */
#define _PGDN    0x51   /* page down                 */

#define _UP      0x48   /* up arrow                  */
#define _DOWN    0x50   /* down arrow                */
#define _LEFT    0x4B   /* left                      */
#define _RIGHT   0x4D   /* right                     */

#define _N7      0x47   /* Number Keypad 7           */
#define _N8      0x48   /* Number Keypad 8           */
#define _N9      0x49   /* Number Keypad 9           */

#define _N4      0x4B   /* Number Keypad 4           */
#define _N5      0x4C   /* Number Keypad 5           */
#define _N6      0x4D   /* Number Keypad 6           */

#define _N1      0x4F   /* Number Keypad 1           */
#define _N2      0x50   /* Number Keypad 2           */
#define _N3      0x51   /* Number Keypad 3           */

#define _N0      0x52   /* Number Keypad 0           */

#define _NSLASH  0x35   /* Number Keypad /           */
#define _NMULTI  0x37   /* Number Keypad *           */
#define _NMIMUS  0x4A   /* Number Keypad -           */
#define _NPLUS   0x4E   /* Number Keypad +           */
#define _NRET    0x1C   /* Number Keypad enter       */
#define _NDOT    0x53   /* Number Keypad .           */

#endif

