#ifndef	_DGSYS_H
#define	_DGSYS_H

#include "dgType.h"

typedef struct  tagdgSURFACE dgSURFACE;

////////////////////////////////////////////////////
typedef struct
{
	S32		cx,cy;

	U8		colorformat;
	U8		palette[256*3];
	void	*image;
} dgSURFACEINFO;

#define		DG_FORMAT_RGB_565	0
#define		DG_FORMAT_PI_8		1

/***********************************************
	Fixed point
************************************************/
#define		vFIX	S32		// 12.4
#define		cFIX	S32		// 12.12
#define		zFIX	S32		// 20.12
#define		wFIX	S32		//  2.30
#define		aFIX	S32		// 12.12
#define		fFIX 	S32		// 12.12
#define		uvFIX	S32		// 14.18

/***********************************************
	vertex structer
************************************************/

typedef struct
{
	vFIX x, y;
	zFIX z;
	wFIX w;
	uvFIX u, v;
	cFIX r, g, b;
	aFIX a;
	fFIX f;
} dgVERTEX;

typedef struct
{
	float x, y;
	float z;
	float w;
	float u, v;
	float r, g, b;
	float a;
	float f;
} dgfVERTEX;
    
/***********************************************
	Draw Mode
************************************************/
#define		DG_ALPHA			0x0001
#define		DG_ZBUFFER			0x0002
#define		DG_SHADE			0x0004
#define		DG_TEXTURE			0x0008
#define		DG_FOG				0x0010
#define		DG_TRANSPARENCY		0x0020
#define		DG_PERSPECTIVE		0x0040
#define		DG_FILTER			0x0080
 
//////////////////////////////////////////////////
#define		DG_256x200			0
#define		DG_320x200			1
#define		DG_320x240			2
#define		DG_512x240			3
#define		DG_512x400			4
#define		DG_640x400			5
#define		DG_640x480			6

#define		DG_DepthZBuffer		0
#define		DG_DepthWBuffer		1

extern S32 SCREEN_CX, SCREEN_CY;

void dgSetScreenMode( U32 smode );
void dgSetDrawMode( U32 dmode );
U32  dgGetDrawMode( void );
void dgSetDepthBuffer( U32 depth );
void dgSetTransparencyColor( U8 r, U8 g, U8 b );
void dgSetFogColor( U8 r, U8 g, U8 b );
void dgClearScreen( U8 r, U8 g, U8 b );
void dgClearZBuffer( void );
void dgFlip( void );

//////////////////////////////////////////////////
#define DG_SURFACE_WIDTH		0
#define DG_SURFACE_HEIGHT		1
#define DG_SURFACE_COLORFORMAT	2

dgSURFACE *dgCreateSurface( dgSURFACEINFO *surfaceinfo );
void dgSetTexture( dgSURFACE *s );

S32  dgGetSurfaceInfo( dgSURFACE *s, U8 option );
S32  dgGetCurrentSurfaceInfo( U8 option );
void dgFreeTextureMemory( void );
U32  dgGetTextureUsage( void );
//////////////////////////////////////////////////

void dgDrawTriangle( dgVERTEX *v1, dgVERTEX *v2, dgVERTEX *v3 );
void dgDrawBox( dgVERTEX *v1, dgVERTEX *v2 ); 

void dgfDrawTriangle( dgfVERTEX *v1, dgfVERTEX *v2, dgfVERTEX *v3 );
void dgfDrawBox( dgfVERTEX *v1, dgfVERTEX *v2 );
/***********************************************
	Special Draw Function
************************************************/
void dgSetParmTriangle( dgVERTEX *v1, dgVERTEX *v2, dgVERTEX *v3 );
void dgSetParmBox( dgVERTEX *v1, dgVERTEX *v2 ); 
void dgDrawParmTriangle( vFIX x, vFIX y, uvFIX u, uvFIX v ); 
void dgDrawParmBox( vFIX x, vFIX y, uvFIX u, uvFIX v );  

void dgfSetParmTriangle( dgfVERTEX *v1, dgfVERTEX *v2, dgfVERTEX *v3 );
void dgfSetParmBox( dgfVERTEX *v1, dgfVERTEX *v2 );
void dgfDrawParmTriangle( float x, float y, float u, float v );
void dgfDrawParmBox( float x, float y, float u, float v );

/***********************************************
	System.c
************************************************/
S32		dgSetSystemMemory( S32 KB_size );
void	dgResetMemory(void);
void*	dgMalloc( long bytesize );
void	dgFree( void *pdata );

void dgError( char* error_message, ... );
void dgReport( char* format, ... );
void dgExit();

/***********************************************
	Frame.c
************************************************/
long dgGetSystemTime(void);
void dgSetFrame( int fps );
dgBOOL dgFrameSkip(void);

/***********************************************
	File.c
************************************************/
#include <stdio.h>
typedef FILE*	dgFILE;
#define dgSEEK_SET SEEK_SET 
#define dgSEEK_CUR SEEK_CUR
#define dgSEEK_END SEEK_END

dgFILE	dgfopen( char* filename, const char *mode );
void	dgfclose( dgFILE file );
long	dgfread( void* dest, U32 size, dgFILE file );
dgBOOL	dgfseek( dgFILE file, S32 offset, int where );
long	dgftell( dgFILE file );
long	dgfgetc( dgFILE file );
S8	*dgfgets(S8 *buf, S16 n, dgFILE fp);

dgFILE	dgHfopen( char* filename, const char *mode );
void	dgHfclose( dgFILE file );
long	dgHfread( void* dest, U32 size, dgFILE file );
dgBOOL	dgHfseek( dgFILE file, S32 offset, int where );
long	dgHftell( dgFILE file );
long	dgHfgetc( dgFILE file );
S8	*dgHfgets(S8 *buf, S16 n, dgFILE fp);

/***********************************************
	Input.c
************************************************/
#define dgLEFT_PLAYER	0
#define dgRIGHT_PLAYER	1

#define dgPLAY_LEFT		0x01
#define dgPLAY_RIGHT	0x02
#define dgPLAY_UP		0x04
#define dgPLAY_DOWN		0x08

#define dgPLAY_A		0x10
#define dgPLAY_B		0x20
#define dgPLAY_C		0x30
#define dgPLAY_D		0x40

int dgGetCoin( void );
U8	dgGetStick( int who );
U8	dgGetButton( int who );
void dgGetLightXY(S32 who, S32 *x, S32 *y);

void dgSetStick( int who, int up, int left, int right, int down );
void dgSetButton( int who, int a, int b, int c, int d );
void dgSetCoinKey( int key );

/***********************************************
	Sound.c
************************************************/
#define DG_MIDI_PLAY	0x00	//  ̵ ÷ ΰ?
#define DG_MIDI_CURPOS	0x01	// ÷ ġ

int  dgPlayMidi(U8 *pData, U16 size);
void dgEndMidi(void);
U32	 dgGetMidiState( U16 option );

void dgSetMidiMainVolume(S16 volume);
void dgSetMidiChannelVolume( S16 channel, S16 volume);

void dgSoundFX(S16 fx_num, S16 pitch, S16 percursion);
/***********************************************
	Special Math Function
************************************************/
#define MulDiv16( a, b, c ) (((S32)(a)*(b))/(c))
#pragma aux MulDiv32= \
" imul edx "           \
" idiv ebx "           \
parm [eax] [edx] [ebx] \
value [eax] ;

/***********************************************
	Time Interrupt Service Rountine
************************************************/
void dgSetTimerFunction( void (*f)( void ) );
void dgSetTimerHz( long hz );

#endif