    /*
    theme: BEZIER
    author: lee jong whan
    date: 1998.6.1
    compiler: turbo c++ 3.0
    email: leejw51@hitel.net
    */
    #include <stdio.h>
    #include <stdlib.h>
    #include <conio.h>
    #include <graphics.h>
    #include <math.h>
	float fac(float a)
	{
	if (a==0.0 || a==1.0) return 1;
	return a*fac(a-1);
	}
	float Blend(float t, int i)
	{
	float a;
	switch(i) {
	case 0:a=(1-t)*(1-t)*(1-t);break;
	case 1:a=3*t*(1-t)*(1-t);break;
	case 2:a=3*t*t*(1-t);break;
	case 3:a=t*t*t;break;
	}
	return a;
	}


void draw_bezier(float P[4][2])
{

	float V[4];
	int i;

	//draw original lines
	moveto(P[0][0],P[0][1]);
	for (i=0;i<4;i++) {
	lineto(P[i][0],P[i][1]);
	}
	for (i=0;i<4;i++) {
	circle(P[i][0],P[i][1],10);

	}

	//draw approximation
	float t=0.;
	float Qx,Qy;

	for (t=0.;t<=1.;t+=0.001) {

	for (i=0;i<4;i++) V[i]=P[i][0];
	Qx=Blend(t,0)*V[0]+Blend(t,1)*V[1]+Blend(t,2)*V[2]+Blend(t,3)*V[3];
	for (i=0;i<4;i++) V[i]=P[i][1];
	Qy=Blend(t,0)*V[0]+Blend(t,1)*V[1]+Blend(t,2)*V[2]+Blend(t,3)*V[3];

	putpixel(Qx,Qy,BLACK);



	}

}
    void main(void)
    {
	int card=VGA, mode=VGAHI;initgraph(&card,&mode,"");
	setcolor(BLACK);
	setfillstyle(SOLID_FILL,WHITE);
	//setlinestyle(DOTTED_LINE,0, 2);
	bar(0,0, 639,479);
	float P[4][2]={{50,300}, {80,50} , {150,20},{300,320}};
	int i;
	for (i=0;i<=80;i+=10) {
	P[2][0]+=i;
	draw_bezier(P);
	}
        getch();
        closegraph();
    }
