#include <dxinput.h>

LPDIRECTINPUT		  lpDI;
LPDIRECTINPUTDEVICE lpDIDeviceKeyboard;
LPDIRECTINPUTDEVICE lpDIDeviceMouse;

DIDEVICEOBJECTDATA  diKeyboard[DINPUT_BUFFERSIZE];
BYTE					  diKeys[256];
DIMOUSESTATE		  diMouse;

HRESULT CreateDirectInput(HINSTANCE hInstance, HWND hwnd)
{
	HRESULT ddrval;

	// Register with the DirectInput subsystem and get a pointer
	// to a IDirectInput interface we can use.
	ddrval = DirectInputCreate(hInstance, DIRECTINPUT_VERSION, &lpDI, NULL);
	if(DI_OK != ddrval)
		return ddrval;

	// Obtain an interface to the system keyboard device.
	ddrval = lpDI->CreateDevice(GUID_SysKeyboard, &lpDIDeviceKeyboard, NULL);
	if(DI_OK != ddrval)
		return ddrval;

	// Set the data format to "keyboard format".
	ddrval = lpDIDeviceKeyboard->SetDataFormat(&c_dfDIKeyboard);
	if(DI_OK != ddrval)
		return ddrval;

	// Set the cooperativity level to let DirectInput know how
	// this device should interact with the system and with other
	// DirectInput applications.
	ddrval = lpDIDeviceKeyboard->SetCooperativeLevel(hwnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND);
	if(DI_OK != ddrval)
		return ddrval;

	// DirectInput uses unbuffered I/O (buffer size = 0) by default.
	// If you want to read buffered data, you need to set a nonzero
	// buffer size.
	DIPROPDWORD dipdw;

	memset(&dipdw, 0, sizeof(DIPROPDWORD));

	dipdw.diph.dwSize 		= sizeof(DIPROPDWORD);
	dipdw.diph.dwHeaderSize = sizeof(DIPROPHEADER);
	dipdw.diph.dwHow			= DIPH_DEVICE;
	dipdw.dwData				= DINPUT_BUFFERSIZE;

	ddrval = lpDIDeviceKeyboard->SetProperty(DIPROP_BUFFERSIZE, &dipdw.diph);
	if(DI_OK != ddrval)
		return ddrval;

	// Obtain an interface to the system mouse device.
	ddrval = lpDI->CreateDevice(GUID_SysMouse, &lpDIDeviceMouse, NULL);
	if(DI_OK != ddrval)
		return ddrval;

	// Set the data format to "mouse format".
	ddrval = lpDIDeviceMouse->SetDataFormat(&c_dfDIMouse);
	if(DI_OK != ddrval)
		return ddrval;

	// Set the cooperativity level to let DirectInput know how
	// this device should interact with the system and with other
	// DirectInput applications.
	ddrval = lpDIDeviceMouse->SetCooperativeLevel(hwnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND);
	if(DI_OK != ddrval)
		return ddrval;

	return DI_OK;
}

LPDIDEVICEOBJECTDATA GetKeyboardData(DWORD &dwSize)
{
	HRESULT ddrval;

	do
	{
		dwSize = DINPUT_BUFFERSIZE;

		ddrval = lpDIDeviceKeyboard->GetDeviceData(sizeof(DIDEVICEOBJECTDATA), diKeyboard, &dwSize, NULL);
		if(DI_OK == ddrval)
			break;

		if(DIERR_INPUTLOST == ddrval)
		{
			ddrval = lpDIDeviceKeyboard->Acquire();
			if(DI_OK == ddrval)
				continue;
		}
	} while(true);

	return diKeyboard;
}

LPBYTE GetKeyboardData()
{
	HRESULT ddrval;

	do
	{
		ddrval = lpDIDeviceKeyboard->GetDeviceState(sizeof(diKeys), &diKeys);
		if(DI_OK == ddrval)
			break;

		if(DIERR_INPUTLOST == ddrval)
		{
			ddrval = lpDIDeviceKeyboard->Acquire();
			if(DI_OK == ddrval)
				continue;
		}
	} while(true);

	return diKeys;
}

DIMOUSESTATE GetMouseData()
{
	HRESULT ddrval;

	do
	{
		ddrval = lpDIDeviceMouse->GetDeviceState(sizeof(DIMOUSESTATE), &diMouse);
		if(DI_OK == ddrval)
			break;

		if(DIERR_INPUTLOST == ddrval)
		{
			ddrval = lpDIDeviceMouse->Acquire();
			if(DI_OK == ddrval)
				continue;
		}

	} while(true);

	return diMouse;
}

void SyncronizeAcquire(BOOL fIsActive)
{
	if(fIsActive)
	{
		lpDIDeviceKeyboard->Acquire();
		lpDIDeviceMouse->Acquire();
	}
	else
	{
		lpDIDeviceKeyboard->Unacquire();
		lpDIDeviceMouse->Unacquire();
	}
}

void ReleaseDirectInput()
{
	// Cleanliness is next to godliness.  Unacquire the device
	// one last time just in case we got really confused and tried
	// to exit while the device is still acquired.

	if(NULL != lpDIDeviceKeyboard)
	{
		lpDIDeviceKeyboard->Unacquire();

		lpDIDeviceKeyboard->Release();
		lpDIDeviceKeyboard = NULL;
	}

	if(NULL != lpDIDeviceMouse)
	{
		lpDIDeviceMouse->Unacquire();

		lpDIDeviceMouse->Release();
		lpDIDeviceMouse= NULL;
	}

	if(NULL != lpDI)
	{
		lpDI->Release();
		lpDI = NULL;
	}
}

